% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test-app.R
\name{local_app_support}
\alias{local_app_support}
\alias{with_app_support}
\alias{load_app_support}
\title{Attach the Shiny application's support environment}
\usage{
local_app_support(app_dir, envir = rlang::caller_env())

with_app_support(app_dir, expr, envir = rlang::caller_env())

load_app_support(app_dir, envir = rlang::caller_env())
}
\arguments{
\item{app_dir}{The base directory for the Shiny application.}

\item{envir}{The environment in which the App support should
be made available.}

\item{expr}{An expression to evaluate within the support environment.}
}
\description{
Executes all \code{./R} files and \code{global.R} into a temp environment that is
attached appropriately. This is useful when wanting access to functions or
values created in the \code{./R} folder for testing purposes.
}
\details{
For Shiny application testing within R packages, \code{local_app_support()} and
\code{with_app_support()} where loading an App's support files should not happen
automatically.

For non-package based Shiny applications, it is recommended to use
\code{\link[=load_app_support]{load_app_support()}} for the support to be available throughout all test
files.
}
\section{Functions}{
\itemize{
\item \code{local_app_support()}: Temporarily attach the Shiny application's support
environment into the current environment.

\item \code{with_app_support()}: For the provided \code{expr}, attach the Shiny
application's support environment into the current environment.

\item \code{load_app_support()}: Loads all support files into the current environment.
No cleanup actions are ever performed.

}}
\examples{
\dontrun{
# ./tests/testthat/apps/myapp/R/utils.R
n <- 42

#' # ./tests/testthat/test-utils.R
test_that("Can access support environment", {
  expect_false(exists("n"))
  shinytest2::local_app_support(test_path("apps/myapp"))
  expect_equal(n, 42)
})

# Or using with_app_support()
test_that("Can access support environment", {
  expect_false(exists("n"))
  shinytest2::with_app_support(test_path("apps/myapp"), {
    expect_equal(n, 42)
  })
  expect_false(exists("n"))
})
}
}
