% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slasso_functions.R
\name{slasso.fr}
\alias{slasso.fr}
\title{Smooth LASSO estimator for the function-on-function linear regression model}
\usage{
slasso.fr(
  Y_fd,
  X_fd,
  basis_s,
  basis_t,
  lambda_L,
  lambda_s,
  lambda_t,
  B0 = NULL,
  ...
)
}
\arguments{
\item{Y_fd}{An object of class fd corresponding to the response functions.}

\item{X_fd}{An object of class fd corresponding to the covariate functions.}

\item{basis_s}{B-splines basis along the \code{s}-direction of class basisfd.}

\item{basis_t}{B-splines basis along the \code{t}-direction of class basisfd.}

\item{lambda_L}{Regularization parameter of the functional LASSO penalty.}

\item{lambda_s}{Regularization parameter of the smoothness penalty along the \code{s}-direction.}

\item{lambda_t}{Regularization parameter of the smoothness penalty along the \code{t}-direction.}

\item{B0}{Initial estimator of the basis coefficients matrix of the coefficient function. Should have dimensions in accordance with the basis dimensions of \code{basis_s} and \code{basis_t}.}

\item{...}{Other arguments to be passed to the Orthant-Wise Limited-memory Quasi-Newton optimization function. See the \code{lbfgs} help page of the package \code{lbfgs}.}
}
\value{
A list containing the following arguments:
\itemize{
\item \code{B}: The basis coefficients matrix estimate of the coefficient function.

\item \code{Beta_hat_fd}: The coefficient function estimate of class bifd.

\item \code{alpha}: The intercept function estimate.

\item \code{lambdas_L}: Regularization parameter of the functional LASSO penalty.

\item \code{lambda_s}: Regularization parameter of the smoothness penalty along the \code{s}-direction.

\item \code{lambda_t}: Regularization parameter of the smoothness penalty along the \code{t}-direction.

\item \code{Y_fd}: The response functions.

\item \code{X_fd}: The covariate functions.

\item \code{per_0}: The fraction of domain where the coefficient function is zero.

\item \code{type}: The output type.
}
}
\description{
The smooth LASSO (S-LASSO) method for the function-on-function linear regression model provides interpretable coefficient function estimates that are both locally sparse and smooth (Centofanti et al., 2020).
}
\examples{
library(slasso)
data<-simulate_data("Scenario II",n_obs=150)
X_fd=data$X_fd
Y_fd=data$Y_fd
domain=c(0,1)
n_basis_s<-30
n_basis_t<-30
breaks_s<-seq(0,1,length.out = (n_basis_s-2))
breaks_t<-seq(0,1,length.out = (n_basis_t-2))
basis_s <- fda::create.bspline.basis(domain,breaks=breaks_s)
basis_t <- fda::create.bspline.basis(domain,breaks=breaks_t)
mod_slasso<-slasso.fr(Y_fd = Y_fd,X_fd=X_fd,basis_s=basis_s,basis_t=basis_t,
lambda_L = -1.5,lambda_s =-8,lambda_t = -7,B0 =NULL,invisible=1,max_iterations=10)
}
\references{
Centofanti, F., Fontana, M., Lepore, A., & Vantini, S. (2022).
Smooth lasso estimator for the function-on-function linear regression model.
\emph{Computational Statistics & Data Analysis}, 176, 107556.
}
\seealso{
\code{\link{slasso.fr_cv}}
}
