% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{competition}
\alias{competition}
\title{Weed competition experiment}
\format{
A data frame with 7 variables: \code{ID}, \code{Block}, \code{WholePlot}, \code{Subplot}, \code{Irrigation}, \code{Species}, \code{Grain}.
\describe{
  \item{ID}{Factor. Unique identifier for each subplot (observation).}
  \item{Block}{Factor. Block number in the experiment (four blocks in total).}
  \item{WholePlot}{Factor. Identifier for each whole plot within a block (two per block, corresponding to irrigation treatments).}
  \item{Subplot}{Factor. Identifier for each subplot within a whole plot (four per whole plot,  corresponding to weed species treatments).}
  \item{Irrigation}{Factor. Irrigation treatment applied to the whole plot ("yes" or "no").}
  \item{Species}{Factor. Weed species sown in each subplot ("-", "Am", "Ga", "Sm"; "-" denotes no weeds).}
  \item{Grain}{Numeric. Grain yield (in appropriate units) measured for each subplot of winter wheat.}
}
}
\source{
Welham, S. J., Gezan, S. A., Clark, S. J., and Mead, A. (2015) \emph{Statistical Methods in Biology: Design and analysis of experiments and regression}
}
\usage{
competition
}
\description{
This dataset arises from a split-plot experiment designed to assess the competitive effects of different weed species and the impact of irrigation on the grain yield of winter wheat. The experimental design included four blocks (Block), with each block containing two whole plots assigned to either irrigation or no irrigation (Irrigation, WholePlot). Each whole plot was further divided into four subplots (Subplot), where different weed species treatments (none, Am, Ga, Sm; Species) were applied. The measured outcome was grain yield (Grain) in each subplot. The hierarchical, nested structure of the experiment (Block/WholePlot/Subplot) allows for analysis of main effects and interactions of weed species and irrigation, while accounting for variation between blocks and plots.
}
\examples{
fit <- aov(Grain ~ Irrigation * Species + Error(Block/WholePlot/Subplot),
           data = competition)
summary(fit)
}
\keyword{datasets}
