% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{examine}
\alias{examine}
\title{Aphid catch}
\format{
A data frame with 23 variables: \code{Trap}, \code{JDay}, \code{Latitude}, \code{Longitude}, \code{Altitude}, \code{OctRain}, \code{NovRain}, \code{DecRain}, \code{JanRain}, \code{FebRain}, \code{MarRain}, \code{AprRain}, \code{MayRain}, \code{C30Day}, \code{F60Day}, \code{ConForest}, \code{DecForest}, \code{MixForest}, \code{Grassland}, \code{Arable}, \code{InlandWater}, \code{Sea}, \code{Urban}.
\describe{
  \item{Trap}{Factor. Unique identifier for each suction trap location.}
  \item{JDay}{Integer. Julian day of first catch of \emph{Myzus persicae} at the site in 1995.}
  \item{Latitude}{Numeric. Latitude (in decimal degrees) of the trap site.}
  \item{Longitude}{Numeric. Longitude (in decimal degrees) of the trap site.}
  \item{Altitude}{Integer. Altitude (in meters above sea level) of the trap site.}
  \item{OctRain}{Numeric. Rainfall (mm) at the trap site in October 1994.}
  \item{NovRain}{Numeric. Rainfall (mm) at the trap site in November 1994.}
  \item{DecRain}{Numeric. Rainfall (mm) at the trap site in December 1994.}
  \item{JanRain}{Numeric. Rainfall (mm) at the trap site in January 1995.}
  \item{FebRain}{Numeric. Rainfall (mm) at the trap site in February 1995.}
  \item{MarRain}{Numeric. Rainfall (mm) at the trap site in March 1995.}
  \item{AprRain}{Numeric. Rainfall (mm) at the trap site in April 1995.}
  \item{MayRain}{Numeric. Rainfall (mm) at the trap site in May 1995.}
  \item{C30Day}{Numeric. Mean temperature (°C) for the coldest consecutive 30-day period at the site.}
  \item{F60Day}{Numeric. Mean temperature (°C) for the following 60-day period after the coldest period at the site.}
  \item{ConForest}{Numeric. Proportion of land (within 75 km radius) under coniferous forest.}
  \item{DecForest}{Numeric. Proportion of land (within 75 km radius) under deciduous forest.}
  \item{MixForest}{Numeric. Proportion of land (within 75 km radius) under mixed forest.}
  \item{Grassland}{Numeric. Proportion of land (within 75 km radius) as grassland.}
  \item{Arable}{Numeric. Proportion of land (within 75 km radius) as arable land.}
  \item{InlandWater}{Numeric. Proportion of land (within 75 km radius) as inland water.}
  \item{Sea}{Numeric. Proportion of area (within 75 km radius) that is sea.}
  \item{Urban}{Numeric. Proportion of land (within 75 km radius) classified as urban area.}
}
}
\source{
Welham, S. J., Gezan, S. A., Clark, S. J., and Mead, A. (2015) \emph{Statistical Methods in Biology: Design and analysis of experiments and regression}
}
\usage{
examine
}
\description{
The EXAMINE project collected data from 50 suction trap locations across Europe to explore environmental and landscape factors affecting aphid flight timing and abundance. This dataset specifically focuses on the Julian day of the first capture of the aphid species \emph{Myzus persicae} at each site in 1995. Explanatory variables include geographical information (latitude, longitude, altitude), ten meteorologicalvariables (monthly rainfall from October 1994 to May 1995, mean temperature for the coldest 30-day period, and mean temperature for the subsequent 60-day period), and eight land-use variables representing the proportion of land within a 75 km radius used for different purposes (such as forest types, agricultural land, urban areas, and water bodies). These factors were selected for their potential influence on aphid migration patterns, with earlier flight dates expected in warmer and drier regions. The dataset enables analysis of how geography, climate, and landscape usage affect the seasonal timing of aphid arrival across Europe.
}
\examples{
step(lm(JDay ~ . - Trap, data = examine), direction = "backward")

}
\keyword{datasets}
