% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api-seeds.R
\name{seeds_api}
\alias{seeds_api}
\alias{as_seeds_rc}
\alias{as_seeds_xy}
\alias{as_seeds_wgs84}
\title{Convert seed coordinates between raster index, map, and WGS84 systems}
\usage{
as_seeds_rc(seeds, x)

as_seeds_xy(seeds, x)

as_seeds_wgs84(seeds, x)
}
\arguments{
\item{seeds}{A data frame, \code{tibble}, or matrix that contains one of the
column pairs \code{(r, c)}, \code{(x, y)}, or \code{(lat, lon)}.}

\item{x}{A \code{\link[terra:SpatRaster-class]{SpatRaster}} or in-memory
array that supplies the metadata needed to perform conversions. For array
inputs, note that the internal coordinate system has its y-axis inverted
(increasing upwards) compared to matrix indices (which increase downwards).}
}
\value{
A data frame with the target coordinate columns and any additional
  columns that were present in \code{seeds}.
}
\description{
These helpers make it easy to express an existing set of seed coordinates in
a different coordinate system. Seeds are accepted when they already contain
the target column pair and otherwise are projected using the provided raster.
}
\note{
Only rasters with a defined coordinate reference system (CRS) can be
  transformed to WGS84 coordinates. If the input raster `x` lacks a CRS,
  attempting to convert to WGS84 will result in an error.
}
\section{Target systems}{

\describe{
  \item{\code{as_seeds_rc()}}{Ensures seeds are expressed in raster row /
  column indices \code{(r, c)}.}
  \item{\code{as_seeds_xy()}}{Ensures seeds use the raster CRS in map units
  \code{(x, y)}.}
  \item{\code{as_seeds_wgs84()}}{Ensures seeds are in geographic
  coordinates \code{(lat, lon)} in \code{EPSG:4326}.}
}
}

\examples{
if (requireNamespace("terra", quietly = TRUE) && terra_is_working()) {
    # Load a test Sentinel-2 band
    s2_file <- system.file(
        "demo-geotiff/S2_20LMR_B04_20220630.tif",
        package = "snic"
    )
    s2_rast <- terra::rast(s2_file)

    # Create some test coordinates in pixel space
    seeds_rc <- data.frame(r = c(10, 20, 30), c = c(15, 25, 35))

    # Convert to map coordinates (x,y)
    seeds_xy <- as_seeds_xy(seeds_rc, s2_rast)

    # Convert to geographic coordinates (lat,lon)
    seeds_wgs84 <- as_seeds_wgs84(seeds_rc, s2_rast)
}

}
