% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/contact-matrix-utils.R
\name{impute_participant_ages}
\alias{impute_participant_ages}
\title{Impute participant ages}
\usage{
impute_participant_ages(
  participants,
  estimate = c("mean", "sample", "missing")
)
}
\arguments{
\item{participants}{A survey data set of participants}

\item{estimate}{if set to "mean" (default), people whose ages are given as a
range (in columns named "..._est_min" and "..._est_max") but not exactly
(in a column named "..._exact") will have their age set to the mid-point of
the range; if set to "sample", the age will be sampled from the range; if
set to "missing", age ranges will be treated as missing}
}
\value{
The participant data, potentially with participant ages imputed depending on
the \code{estimate} method and whether age columns are present in the data.
}
\description{
Imputes participant survey data, where variables are named:
"part_age_est_min" and "part_age_est_max". Uses mean imputation, sampling
(hot deck), or leaves them as missing. These are controlled by the
\code{estimate} argument.
}
\keyword{internal}
