% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_survey.R
\name{load_survey}
\alias{load_survey}
\title{Load a survey from local files}
\usage{
load_survey(files, participant_key = NULL, ...)
}
\arguments{
\item{files}{a vector of file names as returned by \code{\link[=download_survey]{download_survey()}}}

\item{participant_key}{character vector specifying columns that uniquely
identify participant observations. For cross-sectional surveys this is
typically just \code{"part_id"} (the default). For longitudinal surveys with
multiple observations per participant, specify additional columns like
\code{c("part_id", "wave")}. When \code{NULL} (the default), the function will
auto-detect if additional columns are needed and inform you.}

\item{...}{options for \code{\link[=clean]{clean()}}, which is called at the end of this}
}
\value{
a survey in the correct format. For longitudinal surveys with
multiple observations per participant, the returned object includes an
\code{observation_key} field containing the column names (excluding \code{part_id})
that distinguish observations for the same participant.
}
\description{
Loads a survey from a local file system. Tables are expected
as csv files, and a reference (if present) as JSON.
}
\examples{
\dontrun{
list_surveys()
peru_files <- download_survey("https://doi.org/10.5281/zenodo.1095664")
peru_survey <- load_survey(peru_files)

# For longitudinal surveys, specify the unique key explicitly:
france_files <- download_survey("https://doi.org/10.5281/zenodo.1157918")
france_survey <- load_survey(france_files,
  participant_key = c("part_id", "wave", "studyDay")
)
}
}
