# append_dissimilarities() works

    Code
      append_dissimilarities(mtcars)
    Condition
      Warning in `cluster::daisy()`:
      binary variable(s) 8, 9 treated as interval scaled
    Output
                           mpg cyl  disp  hp drat    wt  qsec vs am gear carb
      Mazda RX4           21.0   6 160.0 110 3.90 2.620 16.46  0  1    4    4
      Mazda RX4 Wag       21.0   6 160.0 110 3.90 2.875 17.02  0  1    4    4
      Datsun 710          22.8   4 108.0  93 3.85 2.320 18.61  1  1    4    1
      Hornet 4 Drive      21.4   6 258.0 110 3.08 3.215 19.44  1  0    3    1
      Hornet Sportabout   18.7   8 360.0 175 3.15 3.440 17.02  0  0    3    2
      Valiant             18.1   6 225.0 105 2.76 3.460 20.22  1  0    3    1
      Duster 360          14.3   8 360.0 245 3.21 3.570 15.84  0  0    3    4
      Merc 240D           24.4   4 146.7  62 3.69 3.190 20.00  1  0    4    2
      Merc 230            22.8   4 140.8  95 3.92 3.150 22.90  1  0    4    2
      Merc 280            19.2   6 167.6 123 3.92 3.440 18.30  1  0    4    4
      Merc 280C           17.8   6 167.6 123 3.92 3.440 18.90  1  0    4    4
      Merc 450SE          16.4   8 275.8 180 3.07 4.070 17.40  0  0    3    3
      Merc 450SL          17.3   8 275.8 180 3.07 3.730 17.60  0  0    3    3
      Merc 450SLC         15.2   8 275.8 180 3.07 3.780 18.00  0  0    3    3
      Cadillac Fleetwood  10.4   8 472.0 205 2.93 5.250 17.98  0  0    3    4
      Lincoln Continental 10.4   8 460.0 215 3.00 5.424 17.82  0  0    3    4
      Chrysler Imperial   14.7   8 440.0 230 3.23 5.345 17.42  0  0    3    4
      Fiat 128            32.4   4  78.7  66 4.08 2.200 19.47  1  1    4    1
      Honda Civic         30.4   4  75.7  52 4.93 1.615 18.52  1  1    4    2
      Toyota Corolla      33.9   4  71.1  65 4.22 1.835 19.90  1  1    4    1
      Toyota Corona       21.5   4 120.1  97 3.70 2.465 20.01  1  0    3    1
      Dodge Challenger    15.5   8 318.0 150 2.76 3.520 16.87  0  0    3    2
      AMC Javelin         15.2   8 304.0 150 3.15 3.435 17.30  0  0    3    2
      Camaro Z28          13.3   8 350.0 245 3.73 3.840 15.41  0  0    3    4
      Pontiac Firebird    19.2   8 400.0 175 3.08 3.845 17.05  0  0    3    2
      Fiat X1-9           27.3   4  79.0  66 4.08 1.935 18.90  1  1    4    1
      Porsche 914-2       26.0   4 120.3  91 4.43 2.140 16.70  0  1    5    2
      Lotus Europa        30.4   4  95.1 113 3.77 1.513 16.90  1  1    5    2
      Ford Pantera L      15.8   8 351.0 264 4.22 3.170 14.50  0  1    5    4
      Ferrari Dino        19.7   6 145.0 175 3.62 2.770 15.50  0  1    5    6
      Maserati Bora       15.0   8 301.0 335 3.54 3.570 14.60  0  1    5    8
      Volvo 142E          21.4   4 121.0 109 4.11 2.780 18.60  1  1    4    2
                                                                                                                                                                                                                                                                                                                                                                                                         dissimilarities
      Mazda RX4           0.00000000, 0.01198794, 0.23187696, 0.37043816, 0.33946363, 0.40177475, 0.35415475, 0.34519339, 0.35223675, 0.23449261, 0.24640198, 0.33999492, 0.33077468, 0.34438970, 0.44231101, 0.44218258, 0.41003056, 0.30187460, 0.32525438, 0.32872495, 0.37724793, 0.35086256, 0.33518783, 0.34490061, 0.35927113, 0.28206832, 0.18728973, 0.29577612, 0.25120927, 0.12634569, 0.32761284, 0.20872696
      Mazda RX4 Wag       0.01198794, 0.00000000, 0.23174369, 0.35845022, 0.32747569, 0.38978680, 0.35428801, 0.33320545, 0.34024881, 0.22250467, 0.23441404, 0.32800698, 0.31878674, 0.33240176, 0.43032306, 0.43019463, 0.39804261, 0.30174133, 0.32512111, 0.32859168, 0.37711466, 0.34212137, 0.32319988, 0.34503388, 0.34728319, 0.28193505, 0.19408287, 0.29824026, 0.25134254, 0.13136029, 0.32774610, 0.20115547
      Datsun 710          0.23187696, 0.23174369, 0.00000000, 0.28875393, 0.50308197, 0.31997296, 0.58184235, 0.17078855, 0.18063041, 0.24472455, 0.24992396, 0.52136218, 0.50781293, 0.51276994, 0.63709818, 0.64043295, 0.61693894, 0.07418700, 0.12548885, 0.10103735, 0.17022741, 0.51772765, 0.49274556, 0.57258821, 0.52224012, 0.05438071, 0.21431469, 0.13780811, 0.48308624, 0.34723042, 0.55530044, 0.04818353
      Hornet 4 Drive      0.37043816, 0.35845022, 0.28875393, 0.00000000, 0.23815851, 0.04939769, 0.32194612, 0.18835620, 0.21485443, 0.17035987, 0.16928223, 0.25057362, 0.23702437, 0.24198138, 0.36630961, 0.36964439, 0.35871845, 0.34497556, 0.41424278, 0.37182591, 0.13086418, 0.24693909, 0.22782210, 0.35626132, 0.25145156, 0.33685759, 0.49749026, 0.40893713, 0.55163308, 0.46635010, 0.59578125, 0.28854554
      Hornet Sportabout   0.33946363, 0.32747569, 0.50308197, 0.23815851, 0.00000000, 0.25620644, 0.08378761, 0.39467559, 0.42117381, 0.31617057, 0.32421147, 0.06469212, 0.05547188, 0.06908690, 0.15479543, 0.15466700, 0.12921795, 0.57726897, 0.60064875, 0.60411932, 0.36315759, 0.04975541, 0.03741572, 0.12263806, 0.02367597, 0.55746269, 0.46961051, 0.56094816, 0.32801630, 0.38355718, 0.38438072, 0.47668310
      Valiant             0.40177475, 0.38978680, 0.31997296, 0.04939769, 0.25620644, 0.00000000, 0.33442211, 0.20745402, 0.22919034, 0.17730995, 0.16772167, 0.26221173, 0.24866249, 0.25361950, 0.36621752, 0.37541740, 0.37119444, 0.37554524, 0.44546181, 0.39308823, 0.14974555, 0.23260318, 0.24146031, 0.36873730, 0.27243818, 0.36807662, 0.52870929, 0.44336849, 0.57549885, 0.48762866, 0.60825724, 0.32233444
      Duster 360          0.35415475, 0.35428801, 0.58184235, 0.32194612, 0.08378761, 0.33442211, 0.00000000, 0.47343596, 0.49993419, 0.34298290, 0.34406054, 0.09545484, 0.09319785, 0.09056528, 0.12727486, 0.12072176, 0.08370325, 0.65602935, 0.67940912, 0.68287970, 0.44191797, 0.10181893, 0.09412402, 0.03885045, 0.10142002, 0.63622306, 0.54144448, 0.63711113, 0.26187767, 0.38482838, 0.30600897, 0.55544348
      Merc 240D           0.34519339, 0.33320545, 0.17078855, 0.18835620, 0.39467559, 0.20745402, 0.47343596, 0.00000000, 0.06007875, 0.14972412, 0.14864647, 0.41295579, 0.39940655, 0.40436356, 0.52869179, 0.53202657, 0.50853256, 0.19663511, 0.23800779, 0.21353563, 0.10431458, 0.40932127, 0.38433917, 0.46753332, 0.41383373, 0.18916649, 0.33988681, 0.26354056, 0.57083376, 0.44093855, 0.62871224, 0.16571733
      Merc 230            0.35223675, 0.34024881, 0.18063041, 0.21485443, 0.42117381, 0.22919034, 0.49993419, 0.06007875, 0.00000000, 0.15695129, 0.15587364, 0.43945402, 0.42590477, 0.43086178, 0.55519002, 0.55852479, 0.53503078, 0.23033758, 0.27428013, 0.24788057, 0.12522313, 0.43581949, 0.41083740, 0.49068005, 0.44033196, 0.22286896, 0.35752761, 0.29117956, 0.57713115, 0.46480623, 0.65521046, 0.16840915
      Merc 280            0.23449261, 0.22250467, 0.24472455, 0.17035987, 0.31617057, 0.17730995, 0.34298290, 0.14972412, 0.15695129, 0.00000000, 0.01190937, 0.30847675, 0.29492751, 0.29988452, 0.39823873, 0.40157350, 0.37807949, 0.31304645, 0.33642623, 0.33989680, 0.20827734, 0.33081625, 0.30606661, 0.33372876, 0.33532872, 0.29324016, 0.41491180, 0.33699934, 0.43273187, 0.33545486, 0.49825917, 0.21246058
      Merc 280C           0.24640198, 0.23441404, 0.24992396, 0.16928223, 0.32421147, 0.16772167, 0.34406054, 0.14864647, 0.15587364, 0.01190937, 0.00000000, 0.30955440, 0.29600516, 0.30096217, 0.39931637, 0.40265115, 0.37915713, 0.31196880, 0.34357369, 0.33881915, 0.20719969, 0.33189390, 0.30714425, 0.33480641, 0.34723809, 0.29216252, 0.42682116, 0.34890871, 0.43380952, 0.34736423, 0.49933682, 0.21787644
      Merc 450SE          0.33999492, 0.32800698, 0.52136218, 0.25057362, 0.06469212, 0.26221173, 0.09545484, 0.41295579, 0.43945402, 0.30847675, 0.30955440, 0.00000000, 0.01354924, 0.01787657, 0.12829011, 0.12816168, 0.10941561, 0.59554918, 0.61892895, 0.62239952, 0.38143780, 0.06718242, 0.05285486, 0.11721803, 0.06302562, 0.57574289, 0.49611582, 0.58745347, 0.34164536, 0.38408847, 0.36928997, 0.49496331
      Merc 450SL          0.33077468, 0.31878674, 0.50781293, 0.23702437, 0.05547188, 0.24866249, 0.09319785, 0.39940655, 0.42590477, 0.29492751, 0.29600516, 0.01354924, 0.00000000, 0.01361502, 0.13751035, 0.13738192, 0.12253195, 0.58199993, 0.60537971, 0.60885028, 0.36788855, 0.06492543, 0.05059787, 0.12007482, 0.05915161, 0.56219365, 0.48689558, 0.57823324, 0.33938837, 0.37486823, 0.36703298, 0.48141407
      Merc 450SLC         0.34438970, 0.33240176, 0.51276994, 0.24198138, 0.06908690, 0.25361950, 0.09056528, 0.40436356, 0.43086178, 0.29988452, 0.30096217, 0.01787657, 0.01361502, 0.00000000, 0.12432823, 0.12766301, 0.11757494, 0.58695694, 0.61033672, 0.61380729, 0.37284556, 0.06461395, 0.04796531, 0.11511781, 0.07044218, 0.56715066, 0.50051060, 0.59184825, 0.34139797, 0.38848325, 0.36440042, 0.48637108
      Cadillac Fleetwood  0.44231101, 0.43032306, 0.63709818, 0.36630961, 0.15479543, 0.36621752, 0.12727486, 0.52869179, 0.55519002, 0.39823873, 0.39931637, 0.12829011, 0.13751035, 0.12432823, 0.00000000, 0.01464217, 0.05275858, 0.71128518, 0.73466495, 0.73813552, 0.49717380, 0.15764032, 0.15907123, 0.14583635, 0.13498793, 0.69147889, 0.62440594, 0.71574359, 0.38915252, 0.48640456, 0.43328383, 0.61069931
      Lincoln Continental 0.44218258, 0.43019463, 0.64043295, 0.36964439, 0.15466700, 0.37541740, 0.12072176, 0.53202657, 0.55852479, 0.40157350, 0.40265115, 0.12816168, 0.13738192, 0.12766301, 0.01464217, 0.00000000, 0.04178903, 0.71461995, 0.73799973, 0.74147030, 0.50050857, 0.16337699, 0.15894280, 0.13928325, 0.13485950, 0.69481366, 0.62427750, 0.71561516, 0.38259942, 0.48627613, 0.42673072, 0.61403408
      Chrysler Imperial   0.41003056, 0.39804261, 0.61693894, 0.35871845, 0.12921795, 0.37119444, 0.08370325, 0.50853256, 0.53503078, 0.37807949, 0.37915713, 0.10941561, 0.12253195, 0.11757494, 0.05275858, 0.04178903, 0.00000000, 0.69112594, 0.71450572, 0.71797629, 0.47701456, 0.15049602, 0.13349376, 0.10832595, 0.11527556, 0.67131965, 0.59212549, 0.68346314, 0.34081040, 0.45412411, 0.38494170, 0.59054007
      Fiat 128            0.30187460, 0.30174133, 0.07418700, 0.34497556, 0.57726897, 0.37554524, 0.65602935, 0.19663511, 0.23033758, 0.31304645, 0.31196880, 0.59554918, 0.58199993, 0.58695694, 0.71128518, 0.71461995, 0.69112594, 0.00000000, 0.08539046, 0.02685035, 0.22579969, 0.59191465, 0.56693256, 0.64677521, 0.59642712, 0.03212585, 0.23760881, 0.14176519, 0.53800218, 0.42141741, 0.62948744, 0.10309948
      Honda Civic         0.32525438, 0.32512111, 0.12548885, 0.41424278, 0.60064875, 0.44546181, 0.67940912, 0.23800779, 0.27428013, 0.33642623, 0.34357369, 0.61892895, 0.60537971, 0.61033672, 0.73466495, 0.73799973, 0.71450572, 0.08539046, 0.00000000, 0.08153910, 0.29571626, 0.61529443, 0.59031233, 0.67015499, 0.61980689, 0.07738520, 0.22887374, 0.13794895, 0.54965175, 0.44479719, 0.65286721, 0.12569724
      Toyota Corolla      0.32872495, 0.32859168, 0.10103735, 0.37182591, 0.60411932, 0.39308823, 0.68287970, 0.21353563, 0.24788057, 0.33989680, 0.33881915, 0.62239952, 0.60885028, 0.61380729, 0.73813552, 0.74147030, 0.71797629, 0.02685035, 0.08153910, 0.00000000, 0.24334268, 0.61876500, 0.59378291, 0.67362556, 0.62327747, 0.04665663, 0.24993961, 0.15164709, 0.55312232, 0.44826776, 0.65633778, 0.12743621
      Toyota Corona                                       0.3772479, 0.3771147, 0.1702274, 0.1308642, 0.3631576, 0.1497455, 0.4419180, 0.1043146, 0.1252231, 0.2082773, 0.2071997, 0.3814378, 0.3678886, 0.3728456, 0.4971738, 0.5005086, 0.4770146, 0.2257997, 0.2957163, 0.2433427, 0.0000000, 0.3778033, 0.3528212, 0.4351774, 0.3823157, 0.2183311, 0.3790544, 0.2987627, 0.6284572, 0.4800333, 0.6881033, 0.1935545
      Dodge Challenger    0.35086256, 0.34212137, 0.51772765, 0.24693909, 0.04975541, 0.23260318, 0.10181893, 0.40932127, 0.43581949, 0.33081625, 0.33189390, 0.06718242, 0.06492543, 0.06461395, 0.15764032, 0.16337699, 0.15049602, 0.59191465, 0.61529443, 0.61876500, 0.37780327, 0.00000000, 0.02730318, 0.13613413, 0.06384716, 0.57210837, 0.48100944, 0.57299644, 0.34800609, 0.41101779, 0.38336399, 0.49132878
      AMC Javelin         0.33518783, 0.32319988, 0.49274556, 0.22782210, 0.03741572, 0.24146031, 0.09412402, 0.38433917, 0.41083740, 0.30606661, 0.30714425, 0.05285486, 0.05059787, 0.04796531, 0.15907123, 0.15894280, 0.13349376, 0.56693256, 0.59031233, 0.59378291, 0.35282118, 0.02730318, 0.00000000, 0.12843922, 0.06044234, 0.54712627, 0.46533470, 0.55667235, 0.33868071, 0.39534305, 0.36931973, 0.46634669
      Camaro Z28          0.34490061, 0.34503388, 0.57258821, 0.35626132, 0.12263806, 0.36873730, 0.03885045, 0.46753332, 0.49068005, 0.33372876, 0.33480641, 0.11721803, 0.12007482, 0.11511781, 0.14583635, 0.13928325, 0.10832595, 0.64677521, 0.67015499, 0.67362556, 0.43517745, 0.13613413, 0.12843922, 0.00000000, 0.12771846, 0.62696893, 0.53219034, 0.62785700, 0.24376970, 0.37743153, 0.30336704, 0.54618935
      Pontiac Firebird    0.35927113, 0.34728319, 0.52224012, 0.25145156, 0.02367597, 0.27243818, 0.10142002, 0.41383373, 0.44033196, 0.33532872, 0.34723809, 0.06302562, 0.05915161, 0.07044218, 0.13498793, 0.13485950, 0.11527556, 0.59642712, 0.61980689, 0.62327747, 0.38231574, 0.06384716, 0.06044234, 0.12771846, 0.00000000, 0.57662083, 0.48941801, 0.58075566, 0.35169227, 0.40336468, 0.40201313, 0.49584125
      Fiat X1-9           0.28206832, 0.28193505, 0.05438071, 0.33685759, 0.55746269, 0.36807662, 0.63622306, 0.18916649, 0.22286896, 0.29324016, 0.29216252, 0.57574289, 0.56219365, 0.56715066, 0.69147889, 0.69481366, 0.67131965, 0.03212585, 0.07738520, 0.04665663, 0.21833107, 0.57210837, 0.54712627, 0.62696893, 0.57662083, 0.00000000, 0.21501319, 0.13362387, 0.51819590, 0.40161113, 0.60968115, 0.08329320
      Porsche 914-2                                       0.1872897, 0.1940829, 0.2143147, 0.4974903, 0.4696105, 0.5287093, 0.5414445, 0.3398868, 0.3575276, 0.4149118, 0.4268212, 0.4961158, 0.4868956, 0.5005106, 0.6244059, 0.6242775, 0.5921255, 0.2376088, 0.2288737, 0.2499396, 0.3790544, 0.4810094, 0.4653347, 0.5321903, 0.4894180, 0.2150132, 0.0000000, 0.1651005, 0.3207780, 0.2159235, 0.4239935, 0.2089447
      Lotus Europa                                        0.2957761, 0.2982403, 0.1378081, 0.4089371, 0.5609482, 0.4433685, 0.6371111, 0.2635406, 0.2911796, 0.3369993, 0.3489087, 0.5874535, 0.5782332, 0.5918483, 0.7157436, 0.7156152, 0.6834631, 0.1417652, 0.1379490, 0.1516471, 0.2987627, 0.5729964, 0.5566724, 0.6278570, 0.5807557, 0.1336239, 0.1651005, 0.0000000, 0.4541489, 0.3115901, 0.5196601, 0.1495217
      Ford Pantera L                                      0.2512093, 0.2513425, 0.4830862, 0.5516331, 0.3280163, 0.5754988, 0.2618777, 0.5708338, 0.5771312, 0.4327319, 0.4338095, 0.3416454, 0.3393884, 0.3413980, 0.3891525, 0.3825994, 0.3408104, 0.5380022, 0.5496518, 0.5531223, 0.6284572, 0.3480061, 0.3386807, 0.2437697, 0.3516923, 0.5181959, 0.3207780, 0.4541489, 0.0000000, 0.2070749, 0.1280562, 0.4349027
      Ferrari Dino                                        0.1263457, 0.1313603, 0.3472304, 0.4663501, 0.3835572, 0.4876287, 0.3848284, 0.4409386, 0.4648062, 0.3354549, 0.3473642, 0.3840885, 0.3748682, 0.3884833, 0.4864046, 0.4862761, 0.4541241, 0.4214174, 0.4447972, 0.4482678, 0.4800333, 0.4110178, 0.3953431, 0.3774315, 0.4033647, 0.4016111, 0.2159235, 0.3115901, 0.2070749, 0.0000000, 0.2080700, 0.3212964
      Maserati Bora                                       0.3276128, 0.3277461, 0.5553004, 0.5957813, 0.3843807, 0.6082572, 0.3060090, 0.6287122, 0.6552105, 0.4982592, 0.4993368, 0.3692900, 0.3670330, 0.3644004, 0.4332838, 0.4267307, 0.3849417, 0.6294874, 0.6528672, 0.6563378, 0.6881033, 0.3833640, 0.3693197, 0.3033670, 0.4020131, 0.6096812, 0.4239935, 0.5196601, 0.1280562, 0.2080700, 0.0000000, 0.5289016
      Volvo 142E          0.20872696, 0.20115547, 0.04818353, 0.28854554, 0.47668310, 0.32233444, 0.55544348, 0.16571733, 0.16840915, 0.21246058, 0.21787644, 0.49496331, 0.48141407, 0.48637108, 0.61069931, 0.61403408, 0.59054007, 0.10309948, 0.12569724, 0.12743621, 0.19355450, 0.49132878, 0.46634669, 0.54618935, 0.49584125, 0.08329320, 0.20894472, 0.14952170, 0.43490270, 0.32129644, 0.52890157, 0.00000000
                                                                                                                                                                                                                                                                                                                                                                                                                                        sampling_weights
      Mazda RX4           0.311730615, 0.311730615, 0.016116345, 0.010088078, 0.011008570, 0.009301254, 0.010551910, 0.010825842, 0.010609367, 0.015936575, 0.015166311, 0.010991367, 0.011297748, 0.010851106, 0.008448827, 0.008451281, 0.009113977, 0.012379343, 0.011489497, 0.011368194, 0.009905976, 0.010650920, 0.011149000, 0.010835032, 0.010401640, 0.013248596, 0.019953091, 0.012634587, 0.014876079, 0.029577655, 0.011406785, 0.017903816
      Mazda RX4 Wag       0.310121985, 0.310121985, 0.016042400, 0.010371663, 0.011352675, 0.009537842, 0.010493510, 0.011157455, 0.010926489, 0.016708526, 0.015859652, 0.011334286, 0.011662107, 0.011184432, 0.008639381, 0.008641960, 0.009340017, 0.012320901, 0.011434893, 0.011314118, 0.009858341, 0.010866684, 0.011502866, 0.010774956, 0.010705168, 0.013186459, 0.019155348, 0.012465537, 0.014791467, 0.028301741, 0.011343308, 0.018481849
      Datsun 710          0.025014787, 0.025029172, 0.120380395, 0.020087529, 0.011529638, 0.018127634, 0.009968942, 0.033962187, 0.032111719, 0.023701557, 0.023208470, 0.011125381, 0.011422224, 0.011311803, 0.009104331, 0.009056924, 0.009401826, 0.078185571, 0.046222056, 0.057408009, 0.034074141, 0.011203483, 0.011771497, 0.010130060, 0.011106678, 0.106661947, 0.027064654, 0.042090068, 0.012006868, 0.016704622, 0.010445432, 0.120380395
      Hornet 4 Drive                                      0.01843384, 0.01905034, 0.02364850, 0.13823719, 0.02867249, 0.13823719, 0.02121037, 0.03625364, 0.03178244, 0.04008337, 0.04033854, 0.02725186, 0.02880969, 0.02821952, 0.01864160, 0.01847342, 0.01903609, 0.01979444, 0.01648453, 0.01836504, 0.05218080, 0.02765296, 0.02997338, 0.01916738, 0.02715671, 0.02027147, 0.01372609, 0.01669840, 0.01237888, 0.01464264, 0.01146159, 0.02366558
      Hornet Sportabout   0.010865238, 0.011262983, 0.007331515, 0.015486968, 0.155784671, 0.014396021, 0.044020271, 0.009345278, 0.008757319, 0.011665707, 0.011376381, 0.057013947, 0.066490501, 0.053387157, 0.023827275, 0.023847061, 0.028543660, 0.006389315, 0.006140616, 0.006105339, 0.010156343, 0.074129695, 0.098577646, 0.030075111, 0.155784671, 0.006616323, 0.007854069, 0.006575212, 0.011244421, 0.009616176, 0.009595573, 0.007737537
      Valiant                                             0.01770692, 0.01825150, 0.02223373, 0.14401872, 0.02776742, 0.14401872, 0.02127309, 0.03429286, 0.03104054, 0.04012291, 0.04241665, 0.02713148, 0.02860983, 0.02805065, 0.01942614, 0.01895009, 0.01916567, 0.01894364, 0.01597037, 0.01809821, 0.04750854, 0.03058510, 0.02946319, 0.01929339, 0.02611305, 0.01932802, 0.01345577, 0.01604578, 0.01236178, 0.01458936, 0.01169603, 0.02207084
      Duster 360          0.014072518, 0.014067225, 0.008565635, 0.015480383, 0.059481935, 0.014902870, 0.128282923, 0.010526976, 0.009969010, 0.014530897, 0.014485384, 0.052211592, 0.053476010, 0.055030458, 0.039158159, 0.041283769, 0.059541881, 0.007596991, 0.007335564, 0.007298283, 0.011277770, 0.048948159, 0.052949811, 0.128282923, 0.049140684, 0.007833493, 0.009204728, 0.007822574, 0.019031211, 0.012950835, 0.016286611, 0.008972738
      Merc 240D                                           0.02023208, 0.02095998, 0.04089255, 0.03707857, 0.01769549, 0.03366519, 0.01475169, 0.11624708, 0.11624708, 0.04664565, 0.04698382, 0.01691217, 0.01748589, 0.01727153, 0.01320992, 0.01312712, 0.01373359, 0.03551746, 0.02934349, 0.03270639, 0.06695113, 0.01706234, 0.01817139, 0.01493793, 0.01687629, 0.03691975, 0.02054795, 0.02650058, 0.01223470, 0.01583889, 0.01110839, 0.04214392
      Merc 230                                            0.02113935, 0.02188415, 0.04122261, 0.03465629, 0.01767930, 0.03248853, 0.01489407, 0.12393828, 0.12393828, 0.04744183, 0.04776982, 0.01694388, 0.01748291, 0.01728178, 0.01341173, 0.01333165, 0.01391706, 0.03232671, 0.02714763, 0.03003889, 0.05946231, 0.01708518, 0.01812410, 0.01517497, 0.01691010, 0.03341002, 0.02082652, 0.02557204, 0.01290184, 0.01601970, 0.01136437, 0.04421409
      Merc 280            0.015450954, 0.016283409, 0.014804949, 0.021267535, 0.011459430, 0.020433904, 0.010563601, 0.024198737, 0.023084452, 0.304225611, 0.304225611, 0.011745243, 0.012284831, 0.012081766, 0.009097896, 0.009022345, 0.009582997, 0.011573792, 0.010769477, 0.010659514, 0.017395721, 0.010952106, 0.011837732, 0.010856525, 0.010804725, 0.012355519, 0.008732301, 0.010751162, 0.008372701, 0.010800662, 0.007271586, 0.017053208
      Merc 280C           0.014744024, 0.015498034, 0.014536248, 0.021460946, 0.011205516, 0.021660629, 0.010559062, 0.024440249, 0.023307062, 0.305050356, 0.305050356, 0.011736085, 0.012273289, 0.012071141, 0.009097941, 0.009022591, 0.009581665, 0.011645256, 0.010574025, 0.010722407, 0.017533601, 0.010946139, 0.011828177, 0.010850917, 0.010462437, 0.012434712, 0.008511660, 0.010412342, 0.008374544, 0.010458638, 0.007275563, 0.016674390
      Merc 450SE          0.008112801, 0.008409306, 0.005290585, 0.011007987, 0.042637510, 0.010519404, 0.028896503, 0.006679434, 0.006276677, 0.008941714, 0.008910586, 0.203576747, 0.203576747, 0.154297581, 0.021500574, 0.021522120, 0.025209484, 0.004631542, 0.004456587, 0.004431737, 0.007231352, 0.041057036, 0.052186517, 0.023531458, 0.043764914, 0.004790873, 0.005559813, 0.004695369, 0.008073609, 0.007181447, 0.007469228, 0.005572759
      Merc 450SL          0.007860116, 0.008155695, 0.005119852, 0.010969029, 0.046869281, 0.010455647, 0.027896859, 0.006509476, 0.006104480, 0.008815479, 0.008783385, 0.191887257, 0.191887257, 0.190960244, 0.018907138, 0.018924814, 0.021218361, 0.004467229, 0.004294705, 0.004270224, 0.007067160, 0.040044822, 0.051384125, 0.021652560, 0.043953617, 0.004624612, 0.005339805, 0.004496330, 0.007660626, 0.006935576, 0.007083634, 0.005400605
      Merc 450SLC         0.008004916, 0.008293610, 0.005376311, 0.011392655, 0.039903519, 0.010869868, 0.030440036, 0.006817653, 0.006398364, 0.009192907, 0.009159990, 0.154213643, 0.202483051, 0.202483051, 0.022173648, 0.021594435, 0.023447262, 0.004696785, 0.004516868, 0.004491329, 0.007393974, 0.042665872, 0.057475094, 0.023947733, 0.039135790, 0.004860808, 0.005507996, 0.004657968, 0.008075064, 0.007096343, 0.007565333, 0.005668122
      Cadillac Fleetwood  0.008717703, 0.008960561, 0.006052342, 0.010526440, 0.024909884, 0.010529087, 0.030296133, 0.007293353, 0.006945255, 0.009682474, 0.009656344, 0.030056378, 0.028041060, 0.031014163, 0.263344489, 0.263344489, 0.073086433, 0.005421083, 0.005248564, 0.005223886, 0.007755711, 0.024460341, 0.024240310, 0.026440157, 0.028565044, 0.005576361, 0.006175367, 0.005387315, 0.009908547, 0.007927426, 0.008899331, 0.006313968
      Lincoln Continental 0.008549024, 0.008787254, 0.005902615, 0.010226665, 0.024441087, 0.010069404, 0.031313572, 0.007105340, 0.006768239, 0.009413543, 0.009388349, 0.029495785, 0.027516208, 0.029611001, 0.258174038, 0.258174038, 0.090459861, 0.005289846, 0.005122264, 0.005098288, 0.007552777, 0.023138077, 0.023783584, 0.027140589, 0.028030873, 0.005440638, 0.006055367, 0.005282489, 0.009880385, 0.007773833, 0.008858583, 0.006156384
      Chrysler Imperial   0.013117449, 0.013512510, 0.008718132, 0.014993806, 0.041623899, 0.014489859, 0.064257420, 0.010576619, 0.010052795, 0.014225990, 0.014185557, 0.049157108, 0.043895121, 0.045745758, 0.101946554, 0.128707356, 0.128707356, 0.007782308, 0.007527658, 0.007491271, 0.011275452, 0.035738851, 0.040290685, 0.049651585, 0.046658244, 0.008011913, 0.009083471, 0.007869561, 0.015781663, 0.011843800, 0.013972388, 0.009107858
      Fiat 128            0.015825933, 0.015832923, 0.064397366, 0.013848654, 0.008275947, 0.012721363, 0.007282368, 0.024296003, 0.020741067, 0.015261145, 0.015313862, 0.008021919, 0.008208673, 0.008139349, 0.006716641, 0.006685298, 0.006912557, 0.177928694, 0.055948255, 0.177928694, 0.021157900, 0.008071176, 0.008426835, 0.007386565, 0.008010111, 0.148710380, 0.020106356, 0.033699719, 0.008879977, 0.011336616, 0.007589424, 0.046338228
      Honda Civic                                         0.02374762, 0.02375736, 0.06155143, 0.01864611, 0.01285946, 0.01733935, 0.01136873, 0.03245280, 0.02816106, 0.02295903, 0.02248140, 0.01247965, 0.01275896, 0.01265534, 0.01051366, 0.01046615, 0.01081030, 0.09045528, 0.09981261, 0.09472778, 0.02611969, 0.01255337, 0.01308463, 0.01152572, 0.01246198, 0.09981261, 0.03374794, 0.05599186, 0.01405257, 0.01736526, 0.01183092, 0.06144938
      Toyota Corolla      0.015959718, 0.015966191, 0.051924934, 0.014109715, 0.008684307, 0.013346514, 0.007682697, 0.024569002, 0.021164859, 0.015435148, 0.015484241, 0.008429244, 0.008616827, 0.008547239, 0.007107580, 0.007075614, 0.007307146, 0.195392536, 0.064341613, 0.195392536, 0.021559545, 0.008478756, 0.008835481, 0.007788240, 0.008417371, 0.112446125, 0.020990500, 0.034595835, 0.009484986, 0.011703624, 0.007993380, 0.041168498
      Toyota Corona                                       0.02127415, 0.02128167, 0.04714651, 0.06132792, 0.02209957, 0.05359510, 0.01816090, 0.07693678, 0.06409062, 0.03853337, 0.03873378, 0.02104046, 0.02181538, 0.02152534, 0.01614250, 0.01603495, 0.01682470, 0.03554313, 0.02713962, 0.03298077, 0.07693678, 0.02124288, 0.02274701, 0.01844220, 0.02099215, 0.03675898, 0.02117276, 0.02686289, 0.01277037, 0.01671890, 0.01166341, 0.04146444
      Dodge Challenger    0.011827257, 0.012129443, 0.008015298, 0.016804717, 0.083402825, 0.017840434, 0.040756092, 0.010138104, 0.009521698, 0.012543947, 0.012503217, 0.061768266, 0.063915505, 0.064223618, 0.026324113, 0.025399792, 0.027573762, 0.007010709, 0.006744318, 0.006706491, 0.010983869, 0.151987505, 0.151987505, 0.030482743, 0.064994927, 0.007253419, 0.008627152, 0.007242177, 0.011924336, 0.010096258, 0.010824547, 0.008445957
      AMC Javelin         0.011181572, 0.011596312, 0.007606211, 0.016451112, 0.100169853, 0.015521917, 0.039819026, 0.009751613, 0.009122653, 0.012245461, 0.012202497, 0.070909786, 0.074072818, 0.078138286, 0.023561311, 0.023580349, 0.028075671, 0.006610887, 0.006349057, 0.006311948, 0.010622738, 0.137270727, 0.137270727, 0.029180548, 0.062008305, 0.006850204, 0.008054260, 0.006732734, 0.011066254, 0.009480189, 0.010148190, 0.008036782
      Camaro Z28          0.016252323, 0.016246045, 0.009789646, 0.015734057, 0.045707150, 0.015201706, 0.144282402, 0.011989383, 0.011423811, 0.016796383, 0.016742320, 0.047820597, 0.046682861, 0.048693040, 0.038436480, 0.040244868, 0.051746014, 0.008666745, 0.008364388, 0.008321294, 0.012880805, 0.041175833, 0.043642713, 0.144282402, 0.043889005, 0.008940532, 0.010532765, 0.008927886, 0.022994803, 0.014851531, 0.018477406, 0.010262807
      Pontiac Firebird    0.010982188, 0.011361284, 0.007555113, 0.015691225, 0.166649264, 0.014482489, 0.038903395, 0.009534223, 0.008960474, 0.011766314, 0.011362760, 0.062602838, 0.066702883, 0.056011651, 0.029229154, 0.029256990, 0.034227404, 0.006615365, 0.006365826, 0.006330380, 0.010320221, 0.061797313, 0.065278467, 0.030892818, 0.166649264, 0.006842595, 0.008061786, 0.006793878, 0.011218851, 0.009781677, 0.009814563, 0.007957351
      Fiat X1-9           0.017807383, 0.017815801, 0.092365442, 0.014911045, 0.009010287, 0.013646340, 0.007894870, 0.026552793, 0.022537453, 0.017128959, 0.017192139, 0.008724204, 0.008934464, 0.008856375, 0.007263994, 0.007229131, 0.007482127, 0.156350689, 0.064907747, 0.107656693, 0.023005881, 0.008779628, 0.009180511, 0.008011400, 0.008710921, 0.156350689, 0.023360887, 0.037589830, 0.009693050, 0.012506871, 0.008238566, 0.060303829
      Porsche 914-2                                       0.05365477, 0.05177679, 0.04688894, 0.02019937, 0.02139856, 0.01900664, 0.01855959, 0.02956569, 0.02810689, 0.02421958, 0.02354379, 0.02025533, 0.02063890, 0.02007747, 0.01609368, 0.01609699, 0.01697105, 0.04229215, 0.04390625, 0.04020567, 0.02651067, 0.02089146, 0.02159518, 0.01888232, 0.02053253, 0.04673661, 0.06086590, 0.06086590, 0.03132692, 0.04653959, 0.02370081, 0.04809401
      Lotus Europa                                        0.03055986, 0.03030737, 0.06559032, 0.02210334, 0.01611357, 0.02038683, 0.01418729, 0.03429786, 0.03104228, 0.02682165, 0.02590614, 0.01538654, 0.01563189, 0.01527229, 0.01262865, 0.01263092, 0.01322511, 0.06375950, 0.06552335, 0.05960469, 0.03025437, 0.01577475, 0.01623734, 0.01439640, 0.01556399, 0.06764419, 0.05474774, 0.06764419, 0.01990290, 0.02900887, 0.01739383, 0.06045195
      Ford Pantera L                                      0.04176517, 0.04174302, 0.02171827, 0.01901952, 0.03198560, 0.01823079, 0.04006373, 0.01837978, 0.01817923, 0.02424549, 0.02418526, 0.03070961, 0.03091384, 0.03073187, 0.02696063, 0.02742241, 0.03078485, 0.01950140, 0.01908808, 0.01896831, 0.01669453, 0.03014832, 0.03097843, 0.04303979, 0.02983232, 0.02024678, 0.03270734, 0.02310211, 0.08193118, 0.05066667, 0.08193118, 0.02412447
      Ferrari Dino                                        0.07739399, 0.07443952, 0.02816112, 0.02096793, 0.02549398, 0.02005296, 0.02540976, 0.02217633, 0.02103758, 0.02914967, 0.02815027, 0.02545871, 0.02608489, 0.02517070, 0.02010342, 0.02010873, 0.02153243, 0.02320359, 0.02198395, 0.02181374, 0.02037025, 0.02379069, 0.02473395, 0.02590774, 0.02424208, 0.02434792, 0.04528641, 0.03138225, 0.04722154, 0.07739399, 0.04699570, 0.03043419
      Maserati Bora                                       0.03587505, 0.03586046, 0.02116535, 0.01972725, 0.03057679, 0.01932263, 0.03840779, 0.01869397, 0.01793794, 0.02358838, 0.02353747, 0.03182628, 0.03202199, 0.03225333, 0.02712570, 0.02754226, 0.03053223, 0.01867095, 0.01800232, 0.01790713, 0.01708047, 0.03065788, 0.03182372, 0.03874227, 0.02923568, 0.01927750, 0.02772007, 0.02261695, 0.09178100, 0.05648640, 0.09178100, 0.02222177
      Volvo 142E          0.029285195, 0.030387490, 0.126860969, 0.021184212, 0.012823215, 0.018963564, 0.011004918, 0.036885760, 0.036296186, 0.028770559, 0.028055395, 0.012349622, 0.012697198, 0.012567791, 0.010009197, 0.009954838, 0.010350881, 0.059288463, 0.048629625, 0.047966035, 0.031580819, 0.012440976, 0.013107437, 0.011191375, 0.012327756, 0.073386664, 0.029254675, 0.040881089, 0.014055120, 0.019024829, 0.011557178, 0.126860969

---

    Code
      append_dissimilarities(mtcars, cols = !c(wt, qsec))
    Condition
      Warning:
      
      Duplicate rows detected. The dissimilarity measures and sampling
      weights of identical rows will be identical.
      Rows with duplicates:
      1, 2
      Warning in `cluster::daisy()`:
      binary variable(s) 6, 7 treated as interval scaled
    Output
                           mpg cyl  disp  hp drat    wt  qsec vs am gear carb
      Mazda RX4           21.0   6 160.0 110 3.90 2.620 16.46  0  1    4    4
      Mazda RX4 Wag       21.0   6 160.0 110 3.90 2.875 17.02  0  1    4    4
      Datsun 710          22.8   4 108.0  93 3.85 2.320 18.61  1  1    4    1
      Hornet 4 Drive      21.4   6 258.0 110 3.08 3.215 19.44  1  0    3    1
      Hornet Sportabout   18.7   8 360.0 175 3.15 3.440 17.02  0  0    3    2
      Valiant             18.1   6 225.0 105 2.76 3.460 20.22  1  0    3    1
      Duster 360          14.3   8 360.0 245 3.21 3.570 15.84  0  0    3    4
      Merc 240D           24.4   4 146.7  62 3.69 3.190 20.00  1  0    4    2
      Merc 230            22.8   4 140.8  95 3.92 3.150 22.90  1  0    4    2
      Merc 280            19.2   6 167.6 123 3.92 3.440 18.30  1  0    4    4
      Merc 280C           17.8   6 167.6 123 3.92 3.440 18.90  1  0    4    4
      Merc 450SE          16.4   8 275.8 180 3.07 4.070 17.40  0  0    3    3
      Merc 450SL          17.3   8 275.8 180 3.07 3.730 17.60  0  0    3    3
      Merc 450SLC         15.2   8 275.8 180 3.07 3.780 18.00  0  0    3    3
      Cadillac Fleetwood  10.4   8 472.0 205 2.93 5.250 17.98  0  0    3    4
      Lincoln Continental 10.4   8 460.0 215 3.00 5.424 17.82  0  0    3    4
      Chrysler Imperial   14.7   8 440.0 230 3.23 5.345 17.42  0  0    3    4
      Fiat 128            32.4   4  78.7  66 4.08 2.200 19.47  1  1    4    1
      Honda Civic         30.4   4  75.7  52 4.93 1.615 18.52  1  1    4    2
      Toyota Corolla      33.9   4  71.1  65 4.22 1.835 19.90  1  1    4    1
      Toyota Corona       21.5   4 120.1  97 3.70 2.465 20.01  1  0    3    1
      Dodge Challenger    15.5   8 318.0 150 2.76 3.520 16.87  0  0    3    2
      AMC Javelin         15.2   8 304.0 150 3.15 3.435 17.30  0  0    3    2
      Camaro Z28          13.3   8 350.0 245 3.73 3.840 15.41  0  0    3    4
      Pontiac Firebird    19.2   8 400.0 175 3.08 3.845 17.05  0  0    3    2
      Fiat X1-9           27.3   4  79.0  66 4.08 1.935 18.90  1  1    4    1
      Porsche 914-2       26.0   4 120.3  91 4.43 2.140 16.70  0  1    5    2
      Lotus Europa        30.4   4  95.1 113 3.77 1.513 16.90  1  1    5    2
      Ford Pantera L      15.8   8 351.0 264 4.22 3.170 14.50  0  1    5    4
      Ferrari Dino        19.7   6 145.0 175 3.62 2.770 15.50  0  1    5    6
      Maserati Bora       15.0   8 301.0 335 3.54 3.570 14.60  0  1    5    8
      Volvo 142E          21.4   4 121.0 109 4.11 2.780 18.60  1  1    4    2
                                                                                                                                                                                                                                                                                                                                                                                                                                         dissimilarities
      Mazda RX4                                                                           0.0000000, 0.0000000, 0.2464431, 0.3964359, 0.3841965, 0.4174583, 0.3976653, 0.3588840, 0.3302692, 0.2389673, 0.2455867, 0.3619211, 0.3576658, 0.3675949, 0.4457785, 0.4427946, 0.4110331, 0.3172109, 0.3417325, 0.3339705, 0.4097196, 0.3978398, 0.3754088, 0.3729962, 0.3965028, 0.2930143, 0.2120983, 0.3242343, 0.2654822, 0.1374626, 0.3488231, 0.2222583
      Mazda RX4 Wag                                                                       0.0000000, 0.0000000, 0.2464431, 0.3964359, 0.3841965, 0.4174583, 0.3976653, 0.3588840, 0.3302692, 0.2389673, 0.2455867, 0.3619211, 0.3576658, 0.3675949, 0.4457785, 0.4427946, 0.4110331, 0.3172109, 0.3417325, 0.3339705, 0.4097196, 0.3978398, 0.3754088, 0.3729962, 0.3965028, 0.2930143, 0.2120983, 0.3242343, 0.2654822, 0.1374626, 0.3488231, 0.2222583
      Datsun 710                                          0.24644305, 0.24644305, 0.00000000, 0.31651578, 0.56202713, 0.33739448, 0.63898807, 0.16563871, 0.14044425, 0.26318817, 0.26980756, 0.57149783, 0.56724251, 0.57717159, 0.68710122, 0.68411732, 0.65235580, 0.07588815, 0.13215581, 0.09264780, 0.18541777, 0.57567049, 0.55323949, 0.61431895, 0.57433346, 0.05169153, 0.23156184, 0.12288630, 0.51192524, 0.37047071, 0.59014584, 0.04569016
      Hornet 4 Drive                                      0.39643588, 0.39643588, 0.31651578, 0.00000000, 0.25267982, 0.04309707, 0.33578514, 0.22209548, 0.21498602, 0.18674603, 0.19336541, 0.25498205, 0.25072673, 0.26065581, 0.37058544, 0.36760155, 0.35120101, 0.39240393, 0.44867159, 0.40916357, 0.13109801, 0.25915471, 0.24389218, 0.36436743, 0.25781769, 0.36820730, 0.54125962, 0.41786052, 0.60759584, 0.50522465, 0.65407041, 0.32919735
      Hornet Sportabout                                   0.38419647, 0.38419647, 0.56202713, 0.25267982, 0.00000000, 0.27024497, 0.08310532, 0.43586081, 0.42875134, 0.36949948, 0.37139074, 0.05614346, 0.05188814, 0.06181722, 0.12507408, 0.12209019, 0.09852119, 0.63791528, 0.66243691, 0.65467493, 0.37660936, 0.05655525, 0.04188457, 0.11723070, 0.01703446, 0.61371866, 0.53280273, 0.62927013, 0.35990480, 0.42965166, 0.43409478, 0.54296268
      Valiant                                             0.41745826, 0.41745826, 0.33739448, 0.04309707, 0.27024497, 0.00000000, 0.34767653, 0.24297419, 0.23586472, 0.19074714, 0.18696463, 0.26584938, 0.26159406, 0.27152314, 0.36711585, 0.37130042, 0.36309240, 0.41328263, 0.46955029, 0.43004228, 0.15197671, 0.23827601, 0.25578357, 0.37625883, 0.28011097, 0.38908601, 0.56213833, 0.44266541, 0.61948724, 0.51395389, 0.66596180, 0.35321701
      Duster 360                                          0.39766534, 0.39766534, 0.63898807, 0.33578514, 0.08310532, 0.34767653, 0.00000000, 0.51282174, 0.50571227, 0.38296835, 0.37634897, 0.08182715, 0.08608247, 0.07615340, 0.07952265, 0.06868639, 0.03097693, 0.71487621, 0.73939784, 0.73163586, 0.45357029, 0.10940052, 0.09189296, 0.03412538, 0.10013979, 0.69067959, 0.60976366, 0.70623106, 0.29098387, 0.44312053, 0.35760885, 0.61992361
      Merc 240D                                           0.35888400, 0.35888400, 0.16563871, 0.22209548, 0.43586081, 0.24297419, 0.51282174, 0.00000000, 0.03393339, 0.15340690, 0.16002628, 0.44533150, 0.44107618, 0.45100526, 0.56093489, 0.55795100, 0.52618948, 0.20519542, 0.22657610, 0.22116983, 0.10676615, 0.44950417, 0.42707317, 0.49224889, 0.44816714, 0.18099880, 0.34193603, 0.23345644, 0.62436619, 0.46746893, 0.68620173, 0.17237683
      Merc 230                                            0.33026916, 0.33026916, 0.14044425, 0.21498602, 0.42875134, 0.23586472, 0.50571227, 0.03393339, 0.00000000, 0.12274392, 0.12936331, 0.43822204, 0.43396672, 0.44389579, 0.55382542, 0.55084153, 0.51908001, 0.20916394, 0.23368557, 0.22592359, 0.09536219, 0.44239470, 0.41996370, 0.48104316, 0.44105767, 0.18496732, 0.32627361, 0.23001405, 0.59370321, 0.45941714, 0.67909227, 0.13844343
      Merc 280            0.238967342, 0.238967342, 0.263188172, 0.186746029, 0.369499484, 0.190747138, 0.382968352, 0.153406897, 0.122743921, 0.000000000, 0.006619385, 0.347224146, 0.342968827, 0.352897905, 0.431081503, 0.428097611, 0.396336086, 0.331907863, 0.356429493, 0.348667510, 0.204242496, 0.383142841, 0.360711844, 0.358299238, 0.381805814, 0.307711241, 0.449017530, 0.338623694, 0.470959289, 0.353928719, 0.556348344, 0.236955260
      Merc 280C           0.245586727, 0.245586727, 0.269807558, 0.193365414, 0.371390737, 0.186964632, 0.376348966, 0.160026282, 0.129363307, 0.006619385, 0.000000000, 0.340604761, 0.336349442, 0.346278520, 0.424462118, 0.421478226, 0.389716701, 0.338527248, 0.363048878, 0.355286896, 0.210861881, 0.376523455, 0.354092458, 0.351679853, 0.388425200, 0.314330626, 0.455636915, 0.345243079, 0.464339904, 0.360548105, 0.549728959, 0.243574645
      Merc 450SE          0.361921135, 0.361921135, 0.571497828, 0.254982051, 0.056143458, 0.265849379, 0.081827155, 0.445331504, 0.438222036, 0.347224146, 0.340604761, 0.000000000, 0.004255319, 0.005673759, 0.115603388, 0.112619497, 0.097243020, 0.647385977, 0.671907607, 0.664145625, 0.386080057, 0.059475820, 0.045237348, 0.110409449, 0.066009462, 0.623189356, 0.542273422, 0.638740826, 0.353637857, 0.407376325, 0.400112421, 0.552433374
      Merc 450SL          0.357665816, 0.357665816, 0.567242509, 0.250726732, 0.051888139, 0.261594060, 0.086082474, 0.441076185, 0.433966717, 0.342968827, 0.336349442, 0.004255319, 0.000000000, 0.009929078, 0.119858708, 0.116874816, 0.101498339, 0.643130658, 0.667652288, 0.659890306, 0.381824738, 0.063731139, 0.049492667, 0.114664768, 0.061754143, 0.618934037, 0.538018103, 0.634485506, 0.357893176, 0.403121006, 0.404367741, 0.548178055
      Merc 450SLC         0.367594894, 0.367594894, 0.577171587, 0.260655810, 0.061817217, 0.271523138, 0.076153396, 0.451005263, 0.443895795, 0.352897905, 0.346278520, 0.005673759, 0.009929078, 0.000000000, 0.109929630, 0.106945738, 0.091569261, 0.653059736, 0.677581366, 0.669819384, 0.391753816, 0.056638941, 0.039563589, 0.104735690, 0.071683221, 0.628863115, 0.547947181, 0.644414584, 0.353637857, 0.413050084, 0.394438663, 0.558107133
      Cadillac Fleetwood                                  0.44577849, 0.44577849, 0.68710122, 0.37058544, 0.12507408, 0.36711585, 0.07952265, 0.56093489, 0.55382542, 0.43108150, 0.42446212, 0.11560339, 0.11985871, 0.10992963, 0.00000000, 0.01083627, 0.05437636, 0.76298937, 0.78751100, 0.77974901, 0.50168345, 0.12883984, 0.13386172, 0.10419177, 0.11276775, 0.73879274, 0.65787681, 0.75434421, 0.37050653, 0.49123368, 0.43713150, 0.66803676
      Lincoln Continental                                 0.44279460, 0.44279460, 0.68411732, 0.36760155, 0.12209019, 0.37130042, 0.06868639, 0.55795100, 0.55084153, 0.42809761, 0.42147823, 0.11261950, 0.11687482, 0.10694574, 0.01083627, 0.00000000, 0.04354009, 0.76000547, 0.78452710, 0.77676512, 0.49869955, 0.13302441, 0.13087783, 0.09335550, 0.10978386, 0.73580885, 0.65489292, 0.75136032, 0.35967026, 0.48824979, 0.42629523, 0.66505287
      Chrysler Imperial                                   0.41103307, 0.41103307, 0.65235580, 0.35120101, 0.09852119, 0.36309240, 0.03097693, 0.52618948, 0.51908001, 0.39633609, 0.38971670, 0.09724302, 0.10149834, 0.09156926, 0.05437636, 0.04354009, 0.00000000, 0.72824395, 0.75276558, 0.74500360, 0.46693803, 0.12481639, 0.10730883, 0.06305418, 0.09338332, 0.70404733, 0.62313139, 0.71959880, 0.31613017, 0.45648827, 0.38275514, 0.63329135
      Fiat 128                                            0.31721087, 0.31721087, 0.07588815, 0.39240393, 0.63791528, 0.41328263, 0.71487621, 0.20519542, 0.20916394, 0.33190786, 0.33852725, 0.64738598, 0.64313066, 0.65305974, 0.76298937, 0.76000547, 0.72824395, 0.00000000, 0.07518019, 0.01675965, 0.26130592, 0.65155864, 0.62912764, 0.69020710, 0.65022161, 0.02419662, 0.25206596, 0.11975626, 0.56425988, 0.44635886, 0.66603398, 0.09802480
      Honda Civic                                         0.34173250, 0.34173250, 0.13215581, 0.44867159, 0.66243691, 0.46955029, 0.73939784, 0.22657610, 0.23368557, 0.35642949, 0.36304888, 0.67190761, 0.66765229, 0.67758137, 0.78751100, 0.78452710, 0.75276558, 0.07518019, 0.00000000, 0.07515476, 0.31757358, 0.67608027, 0.65364927, 0.71472873, 0.67474324, 0.08046428, 0.24074530, 0.14427789, 0.57444459, 0.47088049, 0.69055561, 0.11947423
      Toyota Corolla                                      0.33397052, 0.33397052, 0.09264780, 0.40916357, 0.65467493, 0.43004228, 0.73163586, 0.22116983, 0.22592359, 0.34866751, 0.35528690, 0.66414563, 0.65989031, 0.66981938, 0.77974901, 0.77676512, 0.74500360, 0.01675965, 0.07515476, 0.00000000, 0.27806557, 0.66831829, 0.64588729, 0.70696675, 0.66698126, 0.04095627, 0.25448869, 0.13651591, 0.56668261, 0.46311851, 0.68279363, 0.11171225
      Toyota Corona                                       0.40971960, 0.40971960, 0.18541777, 0.13109801, 0.37660936, 0.15197671, 0.45357029, 0.10676615, 0.09536219, 0.20424250, 0.21086188, 0.38608006, 0.38182474, 0.39175382, 0.50168345, 0.49869955, 0.46693803, 0.26130592, 0.31757358, 0.27806557, 0.00000000, 0.39025272, 0.36782172, 0.43197338, 0.38891569, 0.23710930, 0.41027248, 0.29697060, 0.67520179, 0.51838627, 0.73806140, 0.20896670
      Dodge Challenger                                    0.39783983, 0.39783983, 0.57567049, 0.25915471, 0.05655525, 0.23827601, 0.10940052, 0.44950417, 0.44239470, 0.38314284, 0.37652346, 0.05947582, 0.06373114, 0.05663894, 0.12883984, 0.13302441, 0.12481639, 0.65155864, 0.67608027, 0.66831829, 0.39025272, 0.00000000, 0.02526788, 0.13798282, 0.06642125, 0.62736202, 0.54644608, 0.64291349, 0.38404811, 0.46292596, 0.43710903, 0.55660604
      AMC Javelin                                         0.37540883, 0.37540883, 0.55323949, 0.24389218, 0.04188457, 0.25578357, 0.09189296, 0.42707317, 0.41996370, 0.36071184, 0.35409246, 0.04523735, 0.04949267, 0.03956359, 0.13386172, 0.13087783, 0.10730883, 0.62912764, 0.65364927, 0.64588729, 0.36782172, 0.02526788, 0.00000000, 0.12047526, 0.05891903, 0.60493102, 0.52401509, 0.62048249, 0.36937743, 0.44049496, 0.41184116, 0.53417504
      Camaro Z28                                          0.37299623, 0.37299623, 0.61431895, 0.36436743, 0.11723070, 0.37625883, 0.03412538, 0.49224889, 0.48104316, 0.35829924, 0.35167985, 0.11040945, 0.11466477, 0.10473569, 0.10419177, 0.09335550, 0.06305418, 0.69020710, 0.71472873, 0.70696675, 0.43197338, 0.13798282, 0.12047526, 0.00000000, 0.13426517, 0.66601048, 0.58509455, 0.68156195, 0.26686907, 0.42971614, 0.35239698, 0.59525450
      Pontiac Firebird                                    0.39650280, 0.39650280, 0.57433346, 0.25781769, 0.01703446, 0.28011097, 0.10013979, 0.44816714, 0.44105767, 0.38180581, 0.38842520, 0.06600946, 0.06175414, 0.07168322, 0.11276775, 0.10978386, 0.09338332, 0.65022161, 0.67474324, 0.66698126, 0.38891569, 0.06642125, 0.05891903, 0.13426517, 0.00000000, 0.62602499, 0.54510906, 0.64157646, 0.37693927, 0.44195799, 0.45112925, 0.55526901
      Fiat X1-9                                           0.29301425, 0.29301425, 0.05169153, 0.36820730, 0.61371866, 0.38908601, 0.69067959, 0.18099880, 0.18496732, 0.30771124, 0.31433063, 0.62318936, 0.61893404, 0.62886311, 0.73879274, 0.73580885, 0.70404733, 0.02419662, 0.08046428, 0.04095627, 0.23710930, 0.62736202, 0.60493102, 0.66601048, 0.62602499, 0.00000000, 0.22786934, 0.12487406, 0.54006326, 0.42216224, 0.64183736, 0.07382818
      Porsche 914-2                                                                       0.2120983, 0.2120983, 0.2315618, 0.5412596, 0.5328027, 0.5621383, 0.6097637, 0.3419360, 0.3262736, 0.4490175, 0.4556369, 0.5422734, 0.5380181, 0.5479472, 0.6578768, 0.6548929, 0.6231314, 0.2520660, 0.2407453, 0.2544887, 0.4102725, 0.5464461, 0.5240151, 0.5850945, 0.5451091, 0.2278693, 0.0000000, 0.1813310, 0.3336993, 0.2301352, 0.4498103, 0.2120623
      Lotus Europa                                                                        0.3242343, 0.3242343, 0.1228863, 0.4178605, 0.6292701, 0.4426654, 0.7062311, 0.2334564, 0.2300140, 0.3386237, 0.3452431, 0.6387408, 0.6344855, 0.6444146, 0.7543442, 0.7513603, 0.7195988, 0.1197563, 0.1442779, 0.1365159, 0.2969706, 0.6429135, 0.6204825, 0.6815619, 0.6415765, 0.1248741, 0.1813310, 0.0000000, 0.4762497, 0.3266026, 0.5462777, 0.1242666
      Ford Pantera L                                                                      0.2654822, 0.2654822, 0.5119252, 0.6075958, 0.3599048, 0.6194872, 0.2909839, 0.6243662, 0.5937032, 0.4709593, 0.4643399, 0.3536379, 0.3578932, 0.3536379, 0.3705065, 0.3596703, 0.3161302, 0.5642599, 0.5744446, 0.5666826, 0.6752018, 0.3840481, 0.3693774, 0.2668691, 0.3769393, 0.5400633, 0.3336993, 0.4762497, 0.0000000, 0.2285001, 0.1438264, 0.4662351
      Ferrari Dino                                                                        0.1374626, 0.1374626, 0.3704707, 0.5052246, 0.4296517, 0.5139539, 0.4431205, 0.4674689, 0.4594171, 0.3539287, 0.3605481, 0.4073763, 0.4031210, 0.4130501, 0.4912337, 0.4882498, 0.4564883, 0.4463589, 0.4708805, 0.4631185, 0.5183863, 0.4629260, 0.4404950, 0.4297161, 0.4419580, 0.4221622, 0.2301352, 0.3266026, 0.2285001, 0.0000000, 0.2196751, 0.3514063
      Maserati Bora                                                                       0.3488231, 0.3488231, 0.5901458, 0.6540704, 0.4340948, 0.6659618, 0.3576088, 0.6862017, 0.6790923, 0.5563483, 0.5497290, 0.4001124, 0.4043677, 0.3944387, 0.4371315, 0.4262952, 0.3827551, 0.6660340, 0.6905556, 0.6827936, 0.7380614, 0.4371090, 0.4118412, 0.3523970, 0.4511292, 0.6418374, 0.4498103, 0.5462777, 0.1438264, 0.2196751, 0.0000000, 0.5710814
      Volvo 142E                                          0.22225827, 0.22225827, 0.04569016, 0.32919735, 0.54296268, 0.35321701, 0.61992361, 0.17237683, 0.13844343, 0.23695526, 0.24357465, 0.55243337, 0.54817806, 0.55810713, 0.66803676, 0.66505287, 0.63329135, 0.09802480, 0.11947423, 0.11171225, 0.20896670, 0.55660604, 0.53417504, 0.59525450, 0.55526901, 0.07382818, 0.21206227, 0.12426663, 0.46623508, 0.35140626, 0.57108138, 0.00000000
                                                                                                                                                                                                                                                                                                                                                                                                                                        sampling_weights
      Mazda RX4                                           0.06647171, 0.06647171, 0.03707702, 0.02304881, 0.02378308, 0.02188812, 0.02297755, 0.02546053, 0.02766645, 0.03823692, 0.03720631, 0.02524687, 0.02554724, 0.02485719, 0.02049757, 0.02063570, 0.02223027, 0.02880537, 0.02673838, 0.02735983, 0.02230153, 0.02296747, 0.02433980, 0.02449723, 0.02304492, 0.03118406, 0.04308085, 0.02818140, 0.03441803, 0.06647171, 0.02619487, 0.04111152
      Mazda RX4 Wag                                       0.06647171, 0.06647171, 0.03707702, 0.02304881, 0.02378308, 0.02188812, 0.02297755, 0.02546053, 0.02766645, 0.03823692, 0.03720631, 0.02524687, 0.02554724, 0.02485719, 0.02049757, 0.02063570, 0.02223027, 0.02880537, 0.02673838, 0.02735983, 0.02230153, 0.02296747, 0.02433980, 0.02449723, 0.02304492, 0.03118406, 0.04308085, 0.02818140, 0.03441803, 0.06647171, 0.02619487, 0.04111152
      Datsun 710          0.023359482, 0.023359482, 0.125996107, 0.018187978, 0.010242890, 0.017062466, 0.009009217, 0.034755052, 0.040989802, 0.021873255, 0.021336622, 0.010073148, 0.010148714, 0.009974126, 0.008378361, 0.008414905, 0.008824605, 0.075858775, 0.043560567, 0.062136200, 0.031047628, 0.010000134, 0.010405588, 0.009370999, 0.010023414, 0.111367999, 0.024860668, 0.046846409, 0.011245357, 0.015539102, 0.009754846, 0.125996107
      Hornet 4 Drive                                      0.01729860, 0.01729860, 0.02166649, 0.15912420, 0.02714022, 0.15912420, 0.02042314, 0.03087765, 0.03189876, 0.03672253, 0.03546542, 0.02689517, 0.02735164, 0.02630974, 0.01850528, 0.01865549, 0.01952667, 0.01747635, 0.01528465, 0.01676050, 0.05231038, 0.02646213, 0.02811811, 0.01882107, 0.02659936, 0.01862480, 0.01267005, 0.01641166, 0.01128676, 0.01357374, 0.01048478, 0.02083184
      Hornet Sportabout   0.008522685, 0.008522685, 0.005826027, 0.012958635, 0.192221235, 0.012116361, 0.039400429, 0.007512457, 0.007637027, 0.008861678, 0.008816551, 0.058321763, 0.063104700, 0.052968827, 0.026179568, 0.026819398, 0.033235342, 0.005132947, 0.004942939, 0.005001544, 0.008694381, 0.057897113, 0.078176420, 0.027931126, 0.192221235, 0.005335320, 0.006145587, 0.005203466, 0.009097921, 0.007621024, 0.007543020, 0.006030590
      Valiant                                             0.01693941, 0.01693941, 0.02095914, 0.16408304, 0.02616699, 0.16408304, 0.02033930, 0.02910391, 0.02998116, 0.03707263, 0.03782265, 0.02659964, 0.02703233, 0.02604381, 0.01926231, 0.01904522, 0.01947575, 0.01711056, 0.01506015, 0.01644373, 0.04653014, 0.02967776, 0.02764641, 0.01879424, 0.02524534, 0.01817464, 0.01257964, 0.01597481, 0.01141508, 0.01375901, 0.01061847, 0.02002026
      Duster 360          0.010366103, 0.010366103, 0.006451200, 0.012276422, 0.049602598, 0.011856538, 0.133074498, 0.008038349, 0.008151355, 0.010763918, 0.010953239, 0.050377409, 0.047887100, 0.054130745, 0.051837305, 0.060015387, 0.133074498, 0.005766369, 0.005575131, 0.005634278, 0.009088426, 0.037680258, 0.044859147, 0.120796903, 0.041164857, 0.005968383, 0.006760390, 0.005836957, 0.014166558, 0.009302751, 0.011527232, 0.006649593
      Merc 240D           0.016977871, 0.016977871, 0.036785400, 0.027434535, 0.013979431, 0.025077093, 0.011881490, 0.179560175, 0.179560175, 0.039718464, 0.038075535, 0.013682136, 0.013814136, 0.013510011, 0.010862377, 0.010920468, 0.011579643, 0.029694065, 0.026892007, 0.027549355, 0.057069459, 0.013555127, 0.014267078, 0.012378060, 0.013595567, 0.033663683, 0.017819375, 0.026099457, 0.009758834, 0.013034206, 0.008879439, 0.035347478
      Merc 230            0.017612316, 0.017612316, 0.041417179, 0.027056665, 0.013566849, 0.024661614, 0.011502202, 0.171418297, 0.171418297, 0.047389758, 0.044964873, 0.013273647, 0.013403804, 0.013103987, 0.010502957, 0.010559851, 0.011205989, 0.027809787, 0.024891587, 0.025746779, 0.060996968, 0.013148450, 0.013850732, 0.012092064, 0.013188309, 0.031447743, 0.017827996, 0.025288911, 0.009797496, 0.012661271, 0.008565559, 0.042015750
      Merc 280            0.010346012, 0.010346012, 0.009393883, 0.013239151, 0.006691103, 0.012961447, 0.006455779, 0.016116348, 0.020142414, 0.373502797, 0.373502797, 0.007120354, 0.007208699, 0.007005876, 0.005735247, 0.005775222, 0.006238036, 0.007448932, 0.006936460, 0.007090878, 0.012105017, 0.006452839, 0.006854111, 0.006900263, 0.006475436, 0.008034672, 0.005506152, 0.007301199, 0.005249623, 0.006985471, 0.004443905, 0.010433864
      Merc 280C           0.010098381, 0.010098381, 0.009191842, 0.012825605, 0.006677680, 0.013264693, 0.006589704, 0.015497632, 0.019171035, 0.374661441, 0.374661441, 0.007281250, 0.007373369, 0.007161947, 0.005842756, 0.005884120, 0.006363670, 0.007325935, 0.006831114, 0.006980354, 0.011761388, 0.006586651, 0.007003901, 0.007051949, 0.006384829, 0.007889872, 0.005442993, 0.007183427, 0.005340976, 0.006878495, 0.004511366, 0.010181801
      Merc 450SE          0.003393309, 0.003393309, 0.002148933, 0.004816458, 0.021874505, 0.004619572, 0.015008592, 0.002757744, 0.002802484, 0.003536938, 0.003605676, 0.288605937, 0.288605937, 0.216454453, 0.010623481, 0.010904953, 0.012629291, 0.001897030, 0.001827796, 0.001849158, 0.003180973, 0.020648902, 0.027148151, 0.011123236, 0.018605065, 0.001970686, 0.002264744, 0.001922705, 0.003472791, 0.003014683, 0.003069413, 0.002223092
      Merc 450SL          0.003795686, 0.003795686, 0.002393310, 0.005414609, 0.026163729, 0.005189671, 0.015770774, 0.003077897, 0.003128321, 0.003958340, 0.004036240, 0.319033001, 0.319033001, 0.136728429, 0.011326563, 0.011615738, 0.013375463, 0.002110904, 0.002033375, 0.002057292, 0.003555525, 0.021301788, 0.027430068, 0.011839620, 0.021983743, 0.002193428, 0.002523311, 0.002139666, 0.003793275, 0.003367692, 0.003357308, 0.002476544
      Merc 450SLC         0.004354013, 0.004354013, 0.002773028, 0.006140331, 0.025891055, 0.005894573, 0.021016962, 0.003548768, 0.003605605, 0.004535343, 0.004622040, 0.282090416, 0.161194523, 0.282090416, 0.014559432, 0.014965655, 0.017478715, 0.002450791, 0.002362097, 0.002389470, 0.004085507, 0.028258173, 0.040454191, 0.015281448, 0.022327582, 0.002545090, 0.002920926, 0.002483670, 0.004525853, 0.003874864, 0.004057698, 0.002867752
      Cadillac Fleetwood  0.006977139, 0.006977139, 0.004526638, 0.008392824, 0.024867330, 0.008472144, 0.039111604, 0.005544776, 0.005615955, 0.007215013, 0.007327529, 0.026904562, 0.025949374, 0.028293177, 0.287023052, 0.287023052, 0.057198730, 0.004076411, 0.003949479, 0.003988794, 0.006199643, 0.024140503, 0.023234861, 0.029851289, 0.027581099, 0.004209920, 0.004727722, 0.004123129, 0.008394612, 0.006331525, 0.007115155, 0.004655819
      Lincoln Continental 0.006832544, 0.006832544, 0.004422361, 0.008230144, 0.024780154, 0.008148156, 0.044046775, 0.005422365, 0.005492349, 0.007067112, 0.007178102, 0.026864032, 0.025885934, 0.028289241, 0.279193350, 0.279193350, 0.069485706, 0.003980779, 0.003856353, 0.003894889, 0.006066606, 0.022743298, 0.023116319, 0.032407451, 0.027557910, 0.004111684, 0.004619708, 0.004026582, 0.008411632, 0.006196447, 0.007096992, 0.004549133
      Chrysler Imperial   0.010482581, 0.010482581, 0.006604812, 0.012268438, 0.043733614, 0.011866642, 0.139093418, 0.008188472, 0.008300623, 0.010871298, 0.011055948, 0.044308452, 0.042450820, 0.047053865, 0.079238258, 0.098959094, 0.139093418, 0.005916544, 0.005723811, 0.005783445, 0.009227536, 0.034520208, 0.040152219, 0.068333100, 0.046139800, 0.006119884, 0.006914573, 0.005987625, 0.013629473, 0.009438770, 0.011257034, 0.006803642
      Fiat 128            0.011959182, 0.011959182, 0.049989132, 0.009667545, 0.005946844, 0.009179149, 0.005306629, 0.018487657, 0.018136887, 0.011429626, 0.011206137, 0.005859847, 0.005898619, 0.005808937, 0.004971999, 0.004991520, 0.005209220, 0.226352172, 0.050459870, 0.226352172, 0.014517783, 0.005822320, 0.006029909, 0.005496296, 0.005834292, 0.156781504, 0.015049960, 0.031677531, 0.006723113, 0.008498952, 0.005695779, 0.038700234
      Honda Civic         0.022618468, 0.022618468, 0.058487522, 0.017227447, 0.011668229, 0.016461423, 0.010453731, 0.034114215, 0.033076350, 0.021685820, 0.021290428, 0.011503763, 0.011577083, 0.011407436, 0.009815058, 0.009852389, 0.010268091, 0.102812532, 0.102847324, 0.102847324, 0.024339134, 0.011432764, 0.011825097, 0.010814545, 0.011455418, 0.096060830, 0.032106404, 0.053573459, 0.013455546, 0.016414921, 0.011193111, 0.064695673
      Toyota Corolla      0.012491349, 0.012491349, 0.045027972, 0.010195781, 0.006372235, 0.009700773, 0.005701938, 0.018862167, 0.018465280, 0.011964815, 0.011741898, 0.006281367, 0.006321872, 0.006228160, 0.005350109, 0.005370661, 0.005599627, 0.248915871, 0.055508692, 0.248915871, 0.015002729, 0.006242149, 0.006458932, 0.005900903, 0.006254662, 0.101858456, 0.016392643, 0.030558653, 0.007361691, 0.009007937, 0.006109814, 0.037343643
      Toyota Corona                                       0.01975727, 0.01975727, 0.04365785, 0.06174725, 0.02149426, 0.05326435, 0.01784716, 0.07581936, 0.08488627, 0.03963397, 0.03838978, 0.02096700, 0.02120067, 0.02066334, 0.01613555, 0.01623210, 0.01733622, 0.03097879, 0.02548997, 0.02911163, 0.08488627, 0.02074282, 0.02200778, 0.01873944, 0.02081413, 0.03414012, 0.01973065, 0.02725839, 0.01198892, 0.01561565, 0.01096784, 0.03873795
      Dodge Challenger    0.010168214, 0.010168214, 0.007027146, 0.015609673, 0.071528650, 0.016977456, 0.036977158, 0.008999517, 0.009144143, 0.010558257, 0.010743874, 0.068016219, 0.063474786, 0.071422953, 0.031398055, 0.030410362, 0.032410170, 0.006208682, 0.005983491, 0.006052985, 0.010365899, 0.160097366, 0.160097366, 0.029317566, 0.060904009, 0.006448144, 0.007402964, 0.006292169, 0.010533369, 0.008738591, 0.009254717, 0.007267834
      AMC Javelin         0.009564696, 0.009564696, 0.006490265, 0.014722371, 0.085727786, 0.014037927, 0.039074495, 0.008407625, 0.008549956, 0.009954403, 0.010140490, 0.079374043, 0.072549559, 0.090756963, 0.026823734, 0.027435290, 0.033461097, 0.005707381, 0.005493269, 0.005559284, 0.009761988, 0.142104194, 0.142104194, 0.029804220, 0.060942470, 0.005935670, 0.006852229, 0.005786902, 0.009720873, 0.008151447, 0.008718583, 0.006721900
      Camaro Z28          0.013566938, 0.013566938, 0.008237442, 0.013888225, 0.043166309, 0.013449297, 0.148288957, 0.010280199, 0.010519673, 0.014123437, 0.014389271, 0.045833185, 0.044132272, 0.048316068, 0.048568298, 0.054205878, 0.080255054, 0.007331737, 0.007080192, 0.007157928, 0.011714650, 0.036674253, 0.042003784, 0.148288957, 0.037689722, 0.007598104, 0.008648887, 0.007424735, 0.018962170, 0.011776185, 0.014359989, 0.008501266
      Pontiac Firebird    0.008824858, 0.008824858, 0.006092420, 0.013571919, 0.205411864, 0.012491766, 0.034941963, 0.007807535, 0.007933386, 0.009164556, 0.009008377, 0.053008775, 0.056661474, 0.048813107, 0.031029090, 0.031872451, 0.037470084, 0.005381366, 0.005185796, 0.005246146, 0.008997016, 0.052680140, 0.059387957, 0.026060972, 0.205411864, 0.005589363, 0.006419047, 0.005453880, 0.009282877, 0.007917225, 0.007756271, 0.006301596
      Fiat X1-9           0.015329904, 0.015329904, 0.086897808, 0.012199325, 0.007319120, 0.011544698, 0.006503566, 0.024817183, 0.024284725, 0.014597713, 0.014290305, 0.007207890, 0.007257446, 0.007142859, 0.006080028, 0.006104684, 0.006380083, 0.185640810, 0.055824525, 0.109675038, 0.018944345, 0.007159950, 0.007425442, 0.006744459, 0.007175241, 0.185640810, 0.019712527, 0.035971284, 0.008317323, 0.010640176, 0.006998471, 0.060842358
      Porsche 914-2                                       0.05072355, 0.05072355, 0.04646008, 0.01987656, 0.02019205, 0.01913832, 0.01764353, 0.03146314, 0.03297349, 0.02395982, 0.02361174, 0.01983940, 0.01999632, 0.01963397, 0.01635318, 0.01642769, 0.01726503, 0.04268082, 0.04468781, 0.04227449, 0.02622253, 0.01968791, 0.02053067, 0.01838742, 0.01973620, 0.04721294, 0.05933008, 0.05933008, 0.03223975, 0.04674809, 0.02391759, 0.05073218
      Lotus Europa                                        0.02699204, 0.02699204, 0.07121824, 0.02094418, 0.01390777, 0.01977057, 0.01239218, 0.03748770, 0.03804875, 0.02584505, 0.02534952, 0.01370156, 0.01379345, 0.01358092, 0.01160179, 0.01164787, 0.01216198, 0.07307965, 0.06065895, 0.06410788, 0.02947008, 0.01361263, 0.01410474, 0.01284072, 0.01364100, 0.07008458, 0.04826394, 0.07307965, 0.01837638, 0.02679631, 0.01602069, 0.07042716
      Ford Pantera L                                      0.04210423, 0.04210423, 0.02183507, 0.01839697, 0.03105800, 0.01804383, 0.03841424, 0.01790283, 0.01882746, 0.02373437, 0.02407272, 0.03160839, 0.03123257, 0.03160839, 0.03016930, 0.03107825, 0.03535861, 0.01980988, 0.01945866, 0.01972519, 0.01655494, 0.02910553, 0.03026152, 0.04188542, 0.02965444, 0.02069743, 0.03349699, 0.02347072, 0.07771814, 0.04891868, 0.07771814, 0.02397486
      Ferrari Dino                                        0.07609455, 0.07609455, 0.02823477, 0.02070397, 0.02434567, 0.02035232, 0.02360567, 0.02237615, 0.02276832, 0.02955441, 0.02901182, 0.02567689, 0.02594793, 0.02532418, 0.02129364, 0.02142378, 0.02291440, 0.02343441, 0.02221403, 0.02258635, 0.02017830, 0.02259574, 0.02374637, 0.02434201, 0.02366776, 0.02477757, 0.04545222, 0.03202717, 0.04577747, 0.07609455, 0.04761648, 0.02976656
      Maserati Bora                                       0.03665099, 0.03665099, 0.02166365, 0.01954639, 0.02945143, 0.01919737, 0.03575055, 0.01863113, 0.01882618, 0.02297969, 0.02325640, 0.03195280, 0.03161655, 0.03241243, 0.02924684, 0.02999028, 0.03340181, 0.01919529, 0.01851366, 0.01872413, 0.01732202, 0.02924834, 0.03104283, 0.03627930, 0.02833936, 0.01991893, 0.02842246, 0.02340332, 0.08888987, 0.05819828, 0.08888987, 0.02238685
      Volvo 142E          0.027110787, 0.027110787, 0.131879534, 0.018303904, 0.011097626, 0.017059192, 0.009719902, 0.034955955, 0.043523889, 0.025429259, 0.024738194, 0.010907373, 0.010992043, 0.010796488, 0.009019858, 0.009060327, 0.009514731, 0.061470126, 0.050434278, 0.053938549, 0.028835200, 0.010825604, 0.011280191, 0.010122724, 0.010851671, 0.081616490, 0.028414280, 0.048489258, 0.012923945, 0.017147096, 0.010551205, 0.131879534

