% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/max_edges.R
\name{max_edges}
\alias{max_edges}
\title{Maximum number of edges in your grid}
\usage{
max_edges(
  rst,
  contiguity = c("queen", "rook"),
  spherical = TRUE,
  extent = NULL
)
}
\arguments{
\item{rst}{SpatRaster (terra), RasterLayer (raster), matrix, or list of matrices object. RasterLayers are converted to SpatRasters.}

\item{contiguity}{\code{"queen"} (default) for queen's case contiguity or \code{"rook"} for rook's case contiguity. In the latter case, the algorithm
only moves between horizontally or vertically adjacent cells. In the former case, it is also travels between diagonally adjacent cells.}

\item{spherical}{Logical specifying whether coordinates are unprojected, i.e. lonlat, and refer to a sphere, e.g., a planet, if \code{rst} is a matrix
or a list of matrices. It defaults to \code{TRUE}. If \code{FALSE}, the function assumes the coordinates to originate from a planar projection. This
argument has no effect when \code{rst} is a SpatRaster or RasterLayer.}

\item{extent}{Vector of length 4, specifying the extent of \code{rst}, if \code{rst} is a matrix or a list of matrices. It must contain xmin, xmax,
ymin, and ymax, in that order. The argument has no effect when \code{rst} is a SpatRaster or RasterLayer.}
}
\value{
Returns a numeric value denoting the maximum number of edges in \code{rst} that \code{shortest_paths} may store in an adjacency list in R at
some point. If there are any NA cells, the returned number is greater than the final graph's number of edges for two reasons. First,
\link{shortest_paths} assembles the adjacency list in multiple steps. Second, for efficiency reasons, \code{max_edges} does not evaluate where in the
grid the NA cells are and assumes the most conservative impact.

The returned value is the same number upon which \link{shortest_paths} decides to either construct the adjacency list in R or in C++. If the result is
larger than 2,147,483,647 (the maximum number of elements native R objects can store), it chooses C++. Otherwise, it
selects R. In the C++ case, any \code{tr_fun} transition function must be an Rcpp C++ function with various restrictions (see the
\href{../doc/transition_functions.html}{transition functions vignette}).
}
\description{
The maximum number of edges in your grid, determining what type of transition function you can use in \link{shortest_paths}.
}
\details{
An edge is a connection between adjacent grid cells. With queen's case contiguity, each cell has up to 8 edges. With rook's case contiguity,
they have up 4 edges. It is up to 8 and 4, and not exactly 8 or 4, because \code{rst}'s outer pixels do not have neighbors in all directions.

If the data is unprojected and spans from 180 degrees West to 180 degrees East, the easternmost cells are connected to the westernmost cells. Like in
any other geo-spatial software, this is the only scenario in which the algorithm connects cells across the grid boundary, i.e. in which, e.g., a
shortest path leaves the grid on one side and enters it on the opposite side. In all other cases, cells are only connected to their direct neighbors
within the grid.

Another source of edge removal are NA cells. There are no edges to or from NA cells in \code{rst}.
}
\examples{
# Generate example data
set.seed(2L)
input_grid <- terra::rast(crs = "epsg:4326", resolution = 2, vals = sample(c(1L, NA_integer_),
  16200L, TRUE, c(0.8, 0.2)))

# Obtain maximum number of edges
max_edges(input_grid)

}
\seealso{
\link{shortest_paths}.
}
