% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trasp.R
\name{trasp}
\alias{trasp}
\title{Solar-radiation Aspect Index}
\usage{
trasp(x, ...)
}
\arguments{
\item{x}{A terra SpatRaster object}

\item{...}{Additional arguments passed to terra::app}
}
\value{
A terra SpatRaster object of Roberts and Cooper (1989) Solar-radiation Aspect Index
}
\description{
Calculates the Roberts and Cooper (1989) Solar-radiation Aspect Index
}
\details{
Roberts and Cooper (1989) rotates (transforms) the circular aspect to assign a 
value of zero to land oriented in a north-northeast direction, (typically the 
coolest and wettest orientation), and a value of one on the hotter, dryer 
south-southwesterly slopes. The result is a continuous variable between 0 - 1. 
The metric is defined as: trasp = ( 1 - cos((pi/180)(a-30) ) / 2 
where; a = aspect in degrees
}
\examples{
library(terra)
elev <- rast(system.file("extdata/elev.tif", package="spatialEco"))
  s <- trasp(elev)
    plot(s)
    
}
\references{
Roberts. D.W., and Cooper, S.V. (1989). Concepts and techniques of vegetation mapping. 
  In Land Classifications Based on Vegetation: Applications for Resource Management.
  USDA Forest Service GTR INT-257, Ogden, UT, pp 90-96
}
\author{
Jeffrey S. Evans  <jeffrey_evans@tnc.org>
}
