% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_evaluation.R
\name{plot_evaluation}
\alias{plot_evaluation}
\title{Visualize spatial cross-validation results}
\usage{
plot_evaluation(
  model,
  fill.color = viridis::viridis(3, option = "F", alpha = 0.8, direction = -1),
  line.color = "gray30",
  verbose = TRUE,
  notch = TRUE
)
}
\arguments{
\item{model}{Model fitted with \code{\link[=rf_evaluate]{rf_evaluate()}}. Must be of class "rf_evaluate".}

\item{fill.color}{Character vector with three colors (one for each model type: Testing, Training, Full) or a function that generates a color palette. Accepts hexadecimal codes (e.g., \code{c("#440154FF", "#21908CFF", "#FDE725FF")}) or palette functions (e.g., \code{viridis::viridis(3)}). Default: \code{viridis::viridis(3, option = "F", alpha = 0.8, direction = -1)}.}

\item{line.color}{Character string specifying the color of boxplot borders. Default: \code{"gray30"}.}

\item{verbose}{Logical. If \code{TRUE}, prints the plot to the graphics device. Default: \code{TRUE}.}

\item{notch}{Logical. If \code{TRUE}, displays notched boxplots where notches represent approximate 95\% confidence intervals around the median. Non-overlapping notches suggest significant differences between medians. Default: \code{TRUE}.}
}
\value{
ggplot object that can be further customized or saved. The plot displays boxplots of performance metrics (R-squared, RMSE, NRMSE, pseudo R-squared, or AUC depending on model type) across spatial folds, faceted by metric.
}
\description{
Creates boxplots comparing model performance metrics across training, testing, and full datasets from spatial cross-validation performed by \code{\link[=rf_evaluate]{rf_evaluate()}}. Displays distributions of R-squared, RMSE, and other metrics across all spatial folds.
}
\details{
This function visualizes the distribution of performance metrics across spatial folds, with separate boxplots for three model variants:
\itemize{
\item \strong{Testing}: Performance on spatially independent testing folds (most reliable estimate of generalization)
\item \strong{Training}: Performance on training folds (typically optimistic)
\item \strong{Full}: Performance on the complete dataset (reference baseline)
}

\strong{Interpreting the plot:}

The boxplots show the distribution of each metric across all spatial folds. Ideally:
\itemize{
\item Testing performance should be reasonably close to training performance (indicates good generalization)
\item Large gaps between training and testing suggest overfitting
\item Low variance across folds indicates stable, consistent model performance
\item High variance suggests performance depends strongly on spatial location
}

The plot includes a title showing the number of spatial folds used in the evaluation.

\strong{Available metrics:}

Displayed metrics depend on the response variable type:
\itemize{
\item \strong{Continuous response}: R-squared, RMSE (Root Mean Squared Error), NRMSE (Normalized RMSE)
\item \strong{Binary response}: AUC (Area Under ROC Curve), pseudo R-squared
}
}
\examples{
if(interactive()){

data(plants_rf, plants_xy)

# Perform spatial cross-validation
plants_rf <- rf_evaluate(
  model = plants_rf,
  xy = plants_xy,
  repetitions = 5,
  n.cores = 1
)

# Visualize evaluation results
plot_evaluation(plants_rf)

# Without notches for simpler boxplots
plot_evaluation(plants_rf, notch = FALSE)

# Custom colors
plot_evaluation(
  plants_rf,
  fill.color = c("#E64B35FF", "#4DBBD5FF", "#00A087FF")
)

# Print summary statistics
print_evaluation(plants_rf)

# Extract evaluation data for custom analysis
evaluation_data <- get_evaluation(plants_rf)
head(evaluation_data)

}
}
\seealso{
\code{\link[=rf_evaluate]{rf_evaluate()}}, \code{\link[=get_evaluation]{get_evaluation()}}, \code{\link[=print_evaluation]{print_evaluation()}}

Other visualization: 
\code{\link{plot_importance}()},
\code{\link{plot_moran}()},
\code{\link{plot_optimization}()},
\code{\link{plot_residuals_diagnostics}()},
\code{\link{plot_response_curves}()},
\code{\link{plot_response_surface}()},
\code{\link{plot_training_df}()},
\code{\link{plot_training_df_moran}()},
\code{\link{plot_tuning}()}
}
\concept{visualization}
