% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cov_panel_dsgn.R
\name{cov_panel_dsgn}
\alias{cov_panel_dsgn}
\title{Create a covariance matrix for a panel design}
\usage{
cov_panel_dsgn(
  paneldsgn = matrix(50, 1, 10),
  nrepeats = 1,
  unit_var = NULL,
  period_var = NULL,
  unitperiod_var = NULL,
  index_var = NULL,
  unit_rho = 1,
  period_rho = 0
)
}
\arguments{
\item{paneldsgn}{A matrix (dimensions: number of panels (rows) by number of
periods (columns)) containing the number of units visited for each
combination of panel and period. Default is matrix(50, 1, 10) which is a
single panel of 50 units visited 10 times, typical time is a period.}

\item{nrepeats}{Either \code{NULL} or a list of matrices the same length as
paneldsgn specifying the number of revisits made to units in a panel in the
same period for each design.  Specifying \code{NULL} indicates that number of
revisits to units is the same for all panels and for all periods and for
all panel designs. The default is \code{NULL}, a single visit. Names must match
list names in \code{paneldsgn}.}

\item{unit_var}{The variance component estimate for unit. The default is
\code{NULL}.}

\item{period_var}{The variance component estimate for period The default is
\code{NULL}.}

\item{unitperiod_var}{The variance component estimate for unit by period
interaction. The default is \code{NULL}.}

\item{index_var}{The variance component estimate for index error. The
default is \code{NULL}.}

\item{unit_rho}{Unit correlation across periods. The default is \code{1}.}

\item{period_rho}{Period autocorrelation. The default is \code{0}.}
}
\value{
A list containing the covariance matrix (\code{cov}) for the panel design,
  the input panel design (\code{paneldsgn}), the input \code{nrepeats} design
  (\code{nrepeats.dsgn}) and the function call.
}
\description{
Covariance structure accounts for the panel design and the four variance
components: unit variation, period variation, unit by period interaction
variation and index (or residual) variation. The model incorporates unit,
period, unit by period, and index variance components. It also includes a
provision for unit correlation and period autocorrelation.
}
\details{
Covariance structure accounts for the panel design and the four
  variance components: unit variation, period variation, unit by period
  interaction variation and index (or residual) variation. Uses the model
  structure defined by Urquhart 2012.

  If \code{nrepeats} is \code{NULL}, then no units sampled more than once in a specific
  panel, period combination) and then unit by period and index variances are
  added together or user may have only estimated unit, period and unit by
  period variance components so that index component is zero. It calculates
  the covariance matrix for the simple linear regression. The standard error
  for a linear trend coefficient is the square root of the variance.
}
\references{
Urquhart, N. S., W. S. Overton, et al. (1993) Comparing sampling designs
  for monitoring ecological status and trends: impact of temporal patterns.
  In: \emph{Statistics for the Environment.} V. Barnett and K. F. Turkman.
  John Wiley & Sons, New York, pp. 71-86.

  Urquhart, N. S. and T. M. Kincaid (1999). Designs for detecting trends
  from repeated surveys of ecological resources. \emph{Journal of
  Agricultural, Biological, and Environmental Statistics}, \bold{4(4)},
  404-414.

  Urquhart, N. S. (2012). The role of monitoring design in detecting trend in
  long-term ecological monitoring studies. In: \emph{Design and Analysis of
  Long-term Ecological Monitoring Studies.} R. A. Gitzen, J. J. Millspaugh,
  A. B. Cooper, and D. S. Licht (eds.). Cambridge University Press, New York,
  pp. 151-173.
}
\seealso{
\describe{
    \item{\code{\link{power_dsgn}}}{ for power calculations of multiple panel
      designs}
  }
}
\author{
Tony Olsen \email{Olsen.Tony@epa.gov}
}
\keyword{survey}
