% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createFW.R
\name{report.FW}
\alias{report.FW}
\title{Report method for class FW}
\usage{
\method{report}{FW}(x, sortBy = c("sens", "genMean", "mse"), ..., outfile = NULL)
}
\arguments{
\item{x}{An object of class FW.}

\item{sortBy}{A character string indicating by which variable the estimates
should be sorted. Either \code{sens}(itivity), \code{genMean} (genotypic
Mean) or \code{mse} (mean squared error).}

\item{...}{Not used.}

\item{outfile}{A character string, the name and location of the output .pdf
and .tex file for the report. If \code{NULL}, a report with a default name
will be created in the current working directory.}
}
\value{
A pdf and tex report.
}
\description{
A pdf report will be created containing a summary of an FW object.
Simultaneously the same report will be created as a tex file.
}
\examples{
## Run Finlay-Wilkinson analysis on TDMaize.
geFW <- gxeFw(TDMaize, trait = "yld")

\donttest{
## Create a report summarizing the results.
report(geFW, outfile = tempfile(fileext = ".pdf"))
}

}
\seealso{
Other Finlay-Wilkinson: 
\code{\link{fitted.FW}()},
\code{\link{gxeFw}()},
\code{\link{plot.FW}()},
\code{\link{residuals.FW}()}
}
\concept{Finlay-Wilkinson}
