% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_deps.R
\name{find_deps}
\alias{find_deps}
\title{List places where dependencies are used}
\usage{
find_deps(path = ".", threshold = NULL)
}
\arguments{
\item{path}{Path to the base directory of a package.}

\item{threshold}{Only report on dependencies used in fewer than this many
top-level expressions.}
}
\value{
A data frame, with one row per distinct top-level expression where a
package is used. Packages used in the fewest places are listed first.
}
\description{
A quick-and-dirty diagnostic tool to find dependency usage within top-level
expressions (e.g. declared functions) in R scripts within a development
package.
}
\details{
This might be useful for package developers hoping to use \code{\link[=need]{need()}}
in their package, and looking for good candidates for dependencies which
could be moved from \code{Imports} to \code{Suggests} in the \code{DESCRIPTION} file.

Dependencies are searched for in two ways:
\itemize{
\item \code{import()} and \code{importFrom()} statements in the package's \code{NAMESPACE}
file, such as those created by \verb{@import} and \verb{@importFrom} tags if
creating package documentation with roxygen2
\item Functions called by using \code{::} or \code{:::} to access a dependency's namespace
directly
}

This approach isn't perfect, but it should capture most dependency uses.
}
\examples{
  find_deps(system.file("demopkg", package = "suggests"))

}
