% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tn_pan.R
\name{tn_pan}
\alias{tn_pan}
\alias{tn_pfn}
\alias{tn_pfna}
\alias{tn_pfnas}
\alias{tn_pana}
\title{Print formatted names for parents}
\usage{
tn_pfn(x, level, ...)

tn_pfna(x, level, ...)

tn_pfnas(x, level, ...)

tn_pan(x, level, ...)

tn_pana(x, level, ...)
}
\arguments{
\item{x}{A vector containing selected identifiers for taxon concepts
(\strong{TaxonConceptID}) included in the internal taxonomic object
(see \code{\link[=set_tax]{set_tax()}}).}

\item{level}{A character value indicating the taxon rank set for parent
taxa. I is passed to \code{\link[taxlist:parents]{taxlist::parents()}}.}

\item{...}{Further arguments passed to \code{\link[taxlist:print_name]{taxlist::print_name()}}.}
}
\value{
All these functions return a character value.
}
\description{
Displaying names of parent taxa.

Suffixes in the function names are explained as follows:
\itemize{
\item \strong{pfn:} Parent's full name without author name.
\item \strong{pfna:} Parent's full name with author name.
\item \strong{pfnas:} Parent's full name with author name and taxon view (secundum).
\item \strong{pan:} Parent's abbreviated name without author name.
\item \strong{pana:} Parent's abbreviated name with author name.
}
}
\examples{
## Compare all these outputs
tn_pfn(13, "family")
tn_pfna(13, "family")
tn_pfnas(13, "family")
tn_pan(13, "family")
tn_pana(13, "family")
}
