% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/teal_report-class.R
\name{teal_report}
\alias{teal_report}
\alias{as.teal_report}
\title{Comprehensive data integration function for \code{teal} applications}
\usage{
teal_report(
  ...,
  teal_card = NULL,
  code = character(0),
  join_keys = teal.data::join_keys()
)

as.teal_report(x)
}
\arguments{
\item{...}{any number of objects (presumably data objects) provided as \code{name = value} pairs.}

\item{teal_card}{(\code{teal_card}) object containing the report content.}

\item{code}{(\code{character}, \code{language}) optional code to reproduce the datasets provided in \code{...}.
Note this code is not executed and the \code{teal_data} may not be reproducible

Use \code{\link[teal.data:verify]{verify()}} to verify code reproducibility.}

\item{join_keys}{(\code{join_keys} or single \code{join_key_set})
optional object with datasets column names used for joining.
If empty then no joins between pairs of objects.}

\item{x}{(\code{qenv} or \code{teal_data}) object to convert to \code{teal_report}.}
}
\value{
A \code{teal_report} object.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Initializes a reportable data for \code{teal} application.
}
\examples{
# Initialize teal_report with existing h2 header
report <- teal_report(teal_card = teal_card("## Analysis Report"))

# Use within() to execute code and add code-chunk
report <- within(report, {
  data <- iris
  summary_stats <- summary(data)
})

# Access objects created within the report
report$data
report$summary_stats

# within() automatically captures code and outputs
report <- within(report, {
  head(iris)
})

# Add arbitrary markdown content to the card
teal_card(report) <- c(
  teal_card(report),
  teal_card("### Conclusion", "The analysis is complete.")
)

# View the generated card with code chunks
teal_card(report)

# View report in HTML format
tools::toHTML(report)

if (interactive()) {
  # Render the report to various formats
  render(report, output_format = rmarkdown::html_document())
  render(report, output_format = rmarkdown::pdf_document())
}

}
\seealso{
\code{\link[teal.data:teal_data]{teal.data::teal_data}}
}
