% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_rtables.R
\name{h_split_param}
\alias{h_split_param}
\title{Split parameters}
\usage{
h_split_param(param, value, f)
}
\arguments{
\item{param}{(\code{vector})\cr the parameter to be split.}

\item{value}{(\code{vector})\cr the value used to split.}

\item{f}{(\code{list})\cr the reference to make the split.}
}
\value{
A named \code{list} with the same element names as \code{f}, each containing the elements specified in \code{.stats}.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

It divides the data in the vector \code{param} into the groups defined by \code{f} based on specified \code{values}. It is relevant
in \code{rtables} layers so as to distribute parameters \code{.stats} or' \code{.formats} into lists with items corresponding to
specific analysis function.
}
\examples{
f <- list(
  surv = c("pt_at_risk", "event_free_rate", "rate_se", "rate_ci"),
  surv_diff = c("rate_diff", "rate_diff_ci", "ztest_pval")
)

.stats <- c("pt_at_risk", "rate_diff")
h_split_param(.stats, .stats, f = f)

# $surv
# [1] "pt_at_risk"
#
# $surv_diff
# [1] "rate_diff"

.formats <- c("pt_at_risk" = "xx", "event_free_rate" = "xxx")
h_split_param(.formats, names(.formats), f = f)

# $surv
# pt_at_risk event_free_rate
# "xx"           "xxx"
#
# $surv_diff
# NULL

}
