% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chk.R
\name{chk-patterns}
\alias{chk-patterns}
\alias{chk_regex}
\alias{chk_max_length}
\title{Checks: patterns}
\usage{
chk_regex(x, pattern)

chk_max_length(x, len)
}
\arguments{
\item{x}{A vector to check.}

\item{pattern}{A \link[stringr:str_detect]{str_detect()} pattern to match.}

\item{len}{Maximum string length.}
}
\value{
A logical vector flagging records that have passed or failed the
check.
}
\description{
Check that a vector conforms to a certain pattern.
}
\examples{

x <- c("a_1", "b_2", "c_2", NA, "NULL")
chk_regex(x, "[a-z]_[0-9]")
chk_max_length(x, 3)

}
\seealso{
\link[=chk-helper]{Checks: data frame helpers}

\link[=pattern-expectations]{Expectations: patterns}

Other vector checks: 
\code{\link{chk-dates}},
\code{\link{chk-dummy}},
\code{\link{chk-labels}},
\code{\link{chk-text}},
\code{\link{chk-uniqueness}},
\code{\link{chk-values}}
}
\concept{vector checks}
