% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/document_file.R
\name{document_file}
\alias{document_file}
\title{Generate idempotent listings of test_that() titles with sections}
\usage{
document_file(
  path,
  section_prefix = "# -",
  template = c("simple", "advanced", "full", "custom"),
  global_fmt = NULL,
  section_fmt = NULL,
  encoding = "UTF-8",
  backup = TRUE,
  write = TRUE
)
}
\arguments{
\item{path}{Character. Path to the text file to process (typically a test file).}

\item{section_prefix}{Character scalar. Lines starting with this prefix denote
sections and are converted to \verb{#' @testsSection}. Default \code{"# -"}.}

\item{template}{One of \code{c("simple", "advanced", "custom")}. Controls the
default numbering format(s). Default \code{"simple"}.}

\item{global_fmt}{Character. Numbering template for the global listing. Uses
placeholders \code{{g}}, \code{{s}}, \code{{i}}, \code{{l}}. If \code{NULL},
it is derived from \code{template}.}

\item{section_fmt}{Character. Numbering template for section listings.
If \code{NULL}, it is derived from \code{template}.}

\item{encoding}{File encoding for reading and writing. Default \code{"UTF-8"}.}

\item{backup}{Logical. If \code{TRUE}, save a timestamped backup before
overwriting. Default \code{TRUE}.}

\item{write}{Logical. If \code{TRUE}, write changes back to \code{path}.
If \code{FALSE}, return the would-be modified text without writing. Default \code{TRUE}.}
}
\value{
A list with components:
\itemize{
\item \code{text}: the final modified text (character vector, one element per line)
\item \code{listing}: data frame of discovered tests with columns
\code{g}, \code{s}, \code{i}, \code{l} (final line), \code{title_raw},
\code{section_title}.
\item \code{written}: logical, whether the file was written
\item \code{backup}: path to backup file (or \code{NULL})
}
}
\description{
Scans an R text file for \code{test_that()} calls, generates a global listing
and per-section listings as roxygen comments, and inserts them right after the
corresponding markers. The function is \strong{idempotent}: it only replaces content
between existing \verb{@testsList} and \verb{@testsSection} markers and leaves
other code/comments unchanged. If section headers are given using a plain-text
prefix (e.g., \code{"# -"}), they are converted to roxygen markers
\verb{#' @testsSection} (with any following text treated as the section title).
}
\details{
The title extracted from \code{test_that()} is the first argument as a \emph{raw
expression}. If that argument is a single, quoted string (single/double/backtick),
the outer quotes are stripped for cleaner listings. If it is constructed via
functions like \code{paste()} or \code{glue::glue()}, the raw expression is listed
without evaluation (and inner quotes remain).

Numbering is customizable via templates using placeholders:
\itemize{
\item \code{{g}} – global incremental index across all tests
\item \code{{s}} – section index (1-based, order of appearance)
\item \code{{i}} – local index within a section (1-based)
\item \code{{l}} – line index (line number in the final, modified text)
\item aliases: \code{{local}} \eqn{\rightarrow} \code{{i}}, \code{{line}} \eqn{\rightarrow} \code{{l}}
}

Two presets are available via \code{template}:
\itemize{
\item \code{"simple"} → \code{"{g}"}
\item \code{"advanced"} → \code{"{g}.{s}.{i}"}
\item \code{"full"} → \code{"{g}.{s}.{i}.{l}"}
}
You may fully override formats using \code{global_fmt} and \code{section_fmt}.

After inserting listings, the file is rescanned to compute the \strong{final}
\code{test_that()} line numbers reported in the returned data frame.
}
\examples{
\dontrun{
  res <- document_file("tests/testthat/test-example.R",
                                section_prefix = "# -",
                                template = "advanced")
  res$listing
}
}
