% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/start_method.R
\name{start_method_api}
\alias{start_method_api}
\alias{add_start_method}
\alias{update_start_method}
\alias{remove_start_method}
\title{Add, update, or reset a start method within an existing \code{roadmap}.}
\usage{
add_start_method(roadmap, start_method)

update_start_method(roadmap, ...)

remove_start_method(roadmap)
}
\arguments{
\item{roadmap}{A \code{roadmap} object}

\item{start_method}{A \code{start_method} object.}

\item{...}{Optional named parameters passed to \code{start_method()}}
}
\value{
A new \code{roadmap} object.

A new \code{roadmap} object with added start_method.

A new \code{roadmap} object with updated start_method.

A new \code{roadmap} object with removed start_method.
}
\description{
Add, update, or reset a start method within an existing \code{roadmap}.
}
\examples{

rm <- roadmap( 
 conf_data = acs_conf_nw,
 start_data = acs_start_nw,
)

add_start_method(
  roadmap = rm,
  start_method = start_method()
)


rm <- roadmap( 
 conf_data = acs_conf_nw,
 start_data = acs_start_nw
)

update_start_method(
  roadmap = rm,
  start_method = start_method()
)

rm <- roadmap( 
 conf_data = acs_conf_nw,
 start_data = acs_start_nw,
 start_method = start_method()
)

remove_start_method(
  roadmap = rm
)

}
