% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/topology_functions.R
\name{simplest_topology}
\alias{simplest_topology}
\title{Create a topology with completely disconnected sets}
\usage{
simplest_topology(datos)
}
\arguments{
\item{datos}{Numeric vector containing the data points to analyze}
}
\value{
A \code{list} with four components:
\describe{
\item{R}{List. The equivalence relation defined on the data vertices.}
\item{subbase}{List. Sets of individual vertices forming the subbase.}
\item{base}{List. Singleton sets forming the base of the topology.}
\item{topology}{List. The complete topology consisting of disconnected singleton sets.}
}
}
\description{
This function generates a topology where each set in the topology
is a singleton (contains only one element), resulting in a completely
disconnected topological structure. Each vertex exists in isolation,
with no meaningful connections between sets.
}
\details{
The subbase contains individual elements. The base consists of singleton sets.
The topology is formed by these singleton sets. No meaningful topological
relationships are established between elements.
}
\examples{
data <- c(1, 2, 3, 4, 5)
result <- simplest_topology(data)
}
