% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/berkowitz.R, R/dac.R, R/gmm.R, R/hongli.R,
%   R/minzar.R, R/nyblom.R, R/shortfall_de.R, R/signbias.R, R/var.R, R/var_cp.R
\name{as_flextable.tstest.berkowitz}
\alias{as_flextable.tstest.berkowitz}
\alias{as_flextable.tstest}
\alias{as_flextable.tstest.dac}
\alias{as_flextable.tstest.gmm}
\alias{as_flextable.tstest.hongli}
\alias{as_flextable.tstest.minzar}
\alias{as_flextable.tstest.nyblom}
\alias{as_flextable.tstest.shortfall_de}
\alias{as_flextable.tstest.signbias}
\alias{as_flextable.tstest.vares}
\alias{as_flextable.tstest.var_cp}
\title{Transform a summary object into flextable}
\usage{
\method{as_flextable}{tstest.berkowitz}(
  x,
  digits = max(3L, getOption("digits") - 3L),
  signif.stars = getOption("show.signif.stars"),
  include.decision = FALSE,
  table.caption = x$test_name,
  footnote.reference = FALSE,
  ...
)

\method{as_flextable}{tstest.dac}(
  x,
  digits = max(3L, getOption("digits") - 3L),
  signif.stars = getOption("show.signif.stars"),
  include.decision = FALSE,
  table.caption = x$test_name,
  footnote.reference = FALSE,
  ...
)

\method{as_flextable}{tstest.gmm}(
  x,
  digits = max(3L, getOption("digits") - 3L),
  signif.stars = getOption("show.signif.stars"),
  include.decision = FALSE,
  collapse = TRUE,
  use.symbols = TRUE,
  table.caption = x$test_name,
  footnote.reference = FALSE,
  ...
)

\method{as_flextable}{tstest.hongli}(
  x,
  digits = max(3L, getOption("digits") - 3L),
  signif.stars = getOption("show.signif.stars"),
  include.decision = FALSE,
  table.caption = x$test_name,
  footnote.reference = FALSE,
  ...
)

\method{as_flextable}{tstest.minzar}(
  x,
  digits = max(3L, getOption("digits") - 3L),
  signif.stars = getOption("show.signif.stars"),
  include.decision = FALSE,
  table.caption = x$test_name,
  footnote.reference = FALSE,
  ...
)

\method{as_flextable}{tstest.nyblom}(
  x,
  digits = max(3L, getOption("digits") - 3L),
  signif.stars = getOption("show.signif.stars"),
  include.decision = FALSE,
  use.symbols = TRUE,
  table.caption = x$test_name,
  footnote.reference = FALSE,
  ...
)

\method{as_flextable}{tstest.shortfall_de}(
  x,
  digits = max(3L, getOption("digits") - 3L),
  signif.stars = getOption("show.signif.stars"),
  include.decision = FALSE,
  table.caption = x$test_name,
  footnote.reference = FALSE,
  ...
)

\method{as_flextable}{tstest.signbias}(
  x,
  digits = max(3L, getOption("digits") - 3L),
  signif.stars = getOption("show.signif.stars"),
  include.decision = FALSE,
  use.symbols = TRUE,
  table.caption = x$test_name,
  footnote.reference = FALSE,
  ...
)

\method{as_flextable}{tstest.vares}(
  x,
  digits = max(3L, getOption("digits") - 3L),
  signif.stars = getOption("show.signif.stars"),
  include.decision = FALSE,
  table.caption = x$test_name,
  footnote.reference = FALSE,
  ...
)

\method{as_flextable}{tstest.var_cp}(
  x,
  digits = max(3L, getOption("digits") - 3L),
  signif.stars = getOption("show.signif.stars"),
  include.decision = FALSE,
  table.caption = x$test_name,
  footnote.reference = FALSE,
  ...
)
}
\arguments{
\item{x}{an object of which inherits a \dQuote{tstest} class.}

\item{digits}{integer, used for number formatting. Optionally, to avoid
scientific notation, set \sQuote{options(scipen=999)}.}

\item{signif.stars}{logical. If TRUE, \sQuote{significance stars} are printed.}

\item{include.decision}{prints out whether to reject the NULL at the 5\% level
of significance.}

\item{table.caption}{an optional string for the table caption.}

\item{footnote.reference}{whether to include the reference paper of the test
in the footnotes.}

\item{...}{not currently used. The returned object can be manipulated further
using flextable.}

\item{collapse}{collapses the results for multiple lags to just report the
joint test.}

\item{use.symbols}{for tests which either have parameters for which the
latex symbols were included in the calling function or for which the tests
generate values which can be represented as latex symbols, then these will
be generated.}
}
\value{
A flextable object.
}
\description{
Transforms a \dQuote{tstest.test} object into a flextable
with options on symbolic representation and model equation.
}
