% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/control.R
\name{control_last_fit}
\alias{control_last_fit}
\title{Control aspects of the last fit process}
\usage{
control_last_fit(verbose = FALSE, event_level = "first", allow_par = FALSE)
}
\arguments{
\item{verbose}{A logical for logging results (other than warnings and errors,
which are always shown) as they are generated during training in a single
R process. When using most parallel backends, this argument typically will
not result in any logging. If using a dark IDE theme, some logging messages
might be hard to see; try setting the \code{tidymodels.dark} option with
\code{options(tidymodels.dark = TRUE)} to print lighter colors.}

\item{event_level}{A single string containing either \code{"first"} or \code{"second"}.
This argument is passed on to yardstick metric functions when any type
of class prediction is made, and specifies which level of the outcome
is considered the "event".}

\item{allow_par}{A logical to allow parallel processing (if a parallel
backend is registered).}
}
\description{
Control aspects of the last fit process
}
\details{
\code{\link[=control_last_fit]{control_last_fit()}} is a wrapper around \code{\link[=control_resamples]{control_resamples()}} and is meant
to be used with \code{\link[=last_fit]{last_fit()}}.
}
