% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculated_fields.R
\name{extract_calculated_fields}
\alias{extract_calculated_fields}
\title{Extract calculated fields from a TWB}
\usage{
extract_calculated_fields(xml_doc)
}
\arguments{
\item{xml_doc}{An \code{xml2} document for a Tableau \code{.twb}.}
}
\value{
A tibble with columns:
\describe{
\item{datasource}{Datasource name.}
\item{name}{User-visible caption or cleaned internal name.}
\item{tableau_internal_name}{Internal Tableau name (often bracketed).}
\item{datatype}{Tableau datatype.}
\item{role}{Tableau role.}
\item{formula}{Calculation formula string.}
\item{calc_class}{Tableau calc class (often \code{"tableau"}).}
\item{is_table_calc}{Heuristic flag for table calcs (e.g., \code{WINDOW_}, \code{LOOKUP}).}
\item{table}{Raw table reference.}
\item{table_clean}{Cleaned table name.}
}
}
\description{
Finds columns that contain \verb{<calculation>} nodes and returns metadata and
formulas, with a heuristic flag for table calculations.
}
\examples{
# A tiny TWB shipped with the package:
twb <- system.file("extdata", "test_for_wenjie.twb", package = "twbparser")
stopifnot(nzchar(twb), file.exists(twb))
xml <- xml2::read_xml(twb)
# Extract calculated fields
calcs <- extract_calculated_fields(xml)
head(calcs)

}
