% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_number_occurrence.R
\name{calc_number_occurrence}
\alias{calc_number_occurrence}
\title{Calculate number of molecular formulas that were assigned to a molecular mass.}
\usage{
calc_number_occurrence(mfd, ...)
}
\arguments{
\item{mfd}{data.table with molecular formula data as derived from
\code{ume::assign_formulas}. Column names of elements/isotopes must match names in
the \code{isotope} column of \code{ume::masses}; values are integers representing
counts per formula.}

\item{...}{Additional arguments passed to methods.}
}
\value{
data.table; an additional column "n_occurrence" is added to the original table mfd
}
\description{
Calculates the number of molecular formula (mf) assignments
for each individual peak (peak_id) in a given mass spectrum (ms_id).
}
\seealso{
Other calculations: 
\code{\link{calc_data_summary}()},
\code{\link{calc_dbe}()},
\code{\link{calc_eval_params}()},
\code{\link{calc_exact_mass}()},
\code{\link{calc_ideg}()},
\code{\link{calc_ma}()},
\code{\link{calc_neutral_mass}()},
\code{\link{calc_nm}()},
\code{\link{calc_norm_int}()},
\code{\link{calc_number_assignment}()},
\code{\link{calc_recalibrate_ms}()}
}
\concept{calculations}
\keyword{internal}
\keyword{misc}
