% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uplot_ppm_avg.R
\name{uplot_ppm_avg}
\alias{uplot_ppm_avg}
\title{Plot Median of Mass Accuracy per Sample (ppm)}
\usage{
uplot_ppm_avg(df, cex.axis = 12, cex.lab = 15, plotly = FALSE, ...)
}
\arguments{
\item{df}{A data frame containing the data. The columns \code{ppm} (ppm values) and \code{file_id}
(sample identifiers) should be present in the data.}

\item{cex.axis}{Numeric. Size of axis text (default is \code{1}).}

\item{cex.lab}{Numeric. Size of axis labels (default is \code{1.4}).}

\item{plotly}{Logical. If TRUE, return interactive plotly object.}

\item{...}{Additional arguments passed to methods.}
}
\value{
A \code{ggplot} object or a \code{plotly} object depending on the \code{plotly} argument.
}
\description{
This function generates a bar plot showing the median of mass accuracy (ppm) for each sample.
It also provides the option to convert the plot into an interactive \code{plotly} object.
}
