% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_vangogh_cvd.R
\name{check_vangogh_cvd}
\alias{check_vangogh_cvd}
\title{Check Color Vision Deficiency (CVD) Accessibility of Van Gogh Palettes}
\usage{
check_vangogh_cvd(
  palette_name,
  n = NULL,
  simulate = TRUE,
  return_scores = FALSE
)
}
\arguments{
\item{palette_name}{Character string specifying the palette name (e.g., "StarryNight")}

\item{n}{Integer. Number of colors to extract from palette. Default is NULL (uses all colors).}

\item{simulate}{Logical. If TRUE, displays simulations for each CVD type. Default TRUE.}

\item{return_scores}{Logical. If TRUE, returns detailed scoring data. Default FALSE.}
}
\value{
If return_scores = TRUE, returns a data frame with CVD scores. Otherwise,
displays visual simulations and prints a summary.
}
\description{
Simulates how a Van Gogh palette appears under different types of color vision
deficiency and provides accessibility scores. This function complements the existing
check_palette() function by adding visual simulation and quantitative metrics.
}
\details{
This function evaluates palette accessibility across three main types of color
vision deficiency:
\itemize{
\item Deuteranopia (red-green, affects ~5\% of males)
\item Protanopia (red-green, affects ~2\% of males)
\item Tritanopia (blue-yellow, affects ~0.01\% of population)
}

The function uses the colorspace package for CVD simulation and calculates
minimum pairwise perceptual distance in CIELAB color space to assess
distinguishability.
}
\examples{
\dontrun{
# Visual simulation of StarryNight palette
check_vangogh_cvd("StarryNight")

# Get detailed scores without plotting
scores <- check_vangogh_cvd("Irises", simulate = FALSE, return_scores = TRUE)

# Check subset of colors
check_vangogh_cvd("CafeTerrace", n = 3)
}

}
