% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normal3d.R
\name{normal3d}
\alias{normal3d}
\title{Principal normal vectors along a 3D curve}
\usage{
normal3d(
  X,
  Y,
  Z,
  a,
  b,
  t_points,
  h = 1e-04,
  plot = FALSE,
  n_samples = 400,
  vec_scale = NULL,
  vec_factor = 1,
  curve_line = list(color = "blue", width = 2, dash = "solid"),
  N_line = list(color = "green", width = 5, dash = "solid"),
  show_curve = TRUE,
  show_points = TRUE,
  point_marker = list(color = "black", size = 3, symbol = "circle"),
  scene = list(aspectmode = "data", xaxis = list(title = "x(t)"), yaxis = list(title =
    "y(t)"), zaxis = list(title = "z(t)")),
  bg = list(paper = "white", plot = "white"),
  tol = 1e-10
)
}
\arguments{
\item{X}{Function giving the \code{x} coordinate of the curve as a function
of the parameter \code{t}.}

\item{Y}{Function giving the \code{y} coordinate of the curve as a function
of the parameter \code{t}.}

\item{Z}{Function giving the \code{z} coordinate of the curve as a function
of the parameter \code{t}.}

\item{a}{Lower endpoint of the parameter interval.}

\item{b}{Upper endpoint of the parameter interval.}

\item{t_points}{Numeric vector of parameter values at which the principal
normal is evaluated and, optionally, plotted.}

\item{h}{Step size for the centered finite-difference approximations used
to compute derivatives.}

\item{plot}{Logical; if \code{TRUE}, displays a 3D plot of the curve and
the corresponding normal segments using \pkg{plotly}.}

\item{n_samples}{Number of points used to sample and draw the curve for
plotting purposes.}

\item{vec_scale}{Base length used for the normal segments. If
\code{NULL}, it is estimated as a small fraction of the overall size
of the sampled curve.}

\item{vec_factor}{Multiplicative factor applied to \code{vec_scale} to
control the visual length of the normal segments.}

\item{curve_line}{List with \pkg{plotly} style options for the base curve.}

\item{N_line}{List with \pkg{plotly} style options for the normal segments.}

\item{show_curve}{Logical; if \code{TRUE}, the base curve is drawn.}

\item{show_points}{Logical; if \code{TRUE}, the evaluation points are
marked on the curve.}

\item{point_marker}{List with \pkg{plotly} marker options for the
evaluation points.}

\item{scene}{List with 3D scene settings for \pkg{plotly}.}

\item{bg}{Background colors for the figure, given as a list with entries
such as \code{paper} and \code{plot}.}

\item{tol}{Numeric tolerance used to detect singular or nearly singular
situations in which the normal direction cannot be computed reliably.}
}
\value{
A tibble with columns \code{t}, \code{x}, \code{y}, \code{z}, \code{Nx},
\code{Ny} and \code{Nz}, where the last three columns contain the
components of the principal normal vector at each parameter value.
}
\description{
Computes numerical principal normal vectors of a three-dimensional
parametric curve at several parameter values. The curve is described by
three coordinate functions \code{X}, \code{Y} and \code{Z}. At each
evaluation point, the function approximates the first and second
derivatives of the curve, builds the unit tangent and binormal vectors,
and then obtains the principal normal as the unit vector orthogonal to
both of them.
}
\details{
For every parameter value in \code{t_points}, the function:
\itemize{
\item approximates the first derivative of the curve with respect to the
parameter,
\item normalizes this derivative to obtain a unit tangent direction,
\item uses the first and second derivative vectors to construct a
direction orthogonal to the tangent and interprets it as a
binormal direction,
\item builds the principal normal direction as a unit vector orthogonal
to both the tangent and the binormal.
}

When the curvature of the curve at a given parameter value is extremely
small, the normal direction becomes poorly defined from a numerical point
of view. In such situations, the function marks the corresponding
components of the normal vector as \code{NA}.

Optionally, the function can display the curve and the associated normal
segments in a 3D interactive plot using \pkg{plotly}. The base curve,
the evaluation points and the normal segments can be shown or hidden
independently.
}
\examples{
X <- function(t) t*cos(t)
Y <- function(t) t*sin(3*t)
Z <- function(t) t
normal3d(X, Y, Z, a = 0, b = 2*pi, t_points = c(pi/3, pi, 5*pi/3))

}
