% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Vehicles.R
\name{Vehicles}
\alias{Vehicles}
\alias{print.Vehicles}
\alias{summary.Vehicles}
\alias{plot.Vehicles}
\title{Construction function for class "Vehicles"}
\usage{
Vehicles(x, ..., time = NULL)

\method{print}{Vehicles}(x, ...)

\method{summary}{Vehicles}(object, ...)

\method{plot}{Vehicles}(
  x,
  pal = "colo_lightningmccarl_into_the_night",
  rev = TRUE,
  bk = NULL,
  fig1 = c(0, 0.8, 0, 0.8),
  fig2 = c(0, 0.8, 0.55, 1),
  fig3 = c(0.7, 1, 0, 0.8),
  mai1 = c(1, 0.82, 0.82, 0.42),
  mai2 = c(1.8, 0.82, 0.5, 0.42),
  mai3 = c(1, 1, 0.82, 0.2),
  bias = 1.5,
  ...
)
}
\arguments{
\item{x}{Object with class "Vehicles"}

\item{...}{ignored}

\item{time}{Character to be the time units as denominator, eg "1/h"}

\item{object}{Object with class "Vehicles"}

\item{pal}{Palette of colors available or the number of the position}

\item{rev}{Logical; to internally revert order of rgb color vectors.}

\item{bk}{Break points in sorted order to indicate the intervals for assigning the colors.}

\item{fig1}{par parameters for fig, \code{\link{par}}.}

\item{fig2}{par parameters for fig, \code{\link{par}}.}

\item{fig3}{par parameters for fig, \code{\link{par}}.}

\item{mai1}{par parameters for mai, \code{\link{par}}.}

\item{mai2}{par parameters for mai, \code{\link{par}}.}

\item{mai3}{par parameters for mai, \code{\link{par}}.}

\item{bias}{positive number. Higher values give more widely spaced colors at the high end.}
}
\value{
Objects of class "Vehicles" or "units"
}
\description{
\code{Vehicles} returns a tranformed object with class "Vehicles" and units
 'veh'. The type of objects supported are of classes "matrix", "data.frame",
 "numeric" and "array". If the object is a matrix it is converted to data.frame.
 If the object is "numeric" it is converted to class "units".
}
\examples{
\dontrun{
lt <- rnorm(100, 300, 10)
class(lt)
vlt <- Vehicles(lt)
class(vlt)
plot(vlt)
LT_B5 <- age_hdv(x = lt,name = "LT_B5")
summary(LT_B5)
plot(LT_B5)
}
}
