% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/moves_rpdy_meta.R
\name{moves_rpdy_meta}
\alias{moves_rpdy_meta}
\title{MOVES estimation of using rates per distance by model year}
\usage{
moves_rpdy_meta(
  metadata,
  lkm,
  ef,
  fuel_type,
  speed_bin,
  profile,
  agemax = 31,
  net,
  simplify = TRUE,
  verbose = FALSE
)
}
\arguments{
\item{metadata}{data.frame with the metadata for a vein project for MOVES.}

\item{lkm}{Length of each link in miles}

\item{ef}{emission factors from EmissionRates_running exported from MOVES}

\item{fuel_type}{Data.frame of fuelSubtypeID exported by MOVES.}

\item{speed_bin}{Data.frame or vector of avgSpeedBinID as defined by MOVES.}

\item{profile}{Data.frame or Matrix with nrows equal to 24 and ncol 7 day of
the week}

\item{agemax}{Integer; max age for the fleet, assuming the same for all vehicles.}

\item{net}{Road network class sf}

\item{simplify}{Logical, to return the whole object or processed by streets and veh}

\item{verbose}{Logical; To show more information. Not implemented yet}
}
\value{
a list with emissions at each street and data.base aggregated by categories.
}
\description{
\code{\link{moves_rpdy_meta}} estimates running exhaust emissions
using MOVES emission factors.
}
\note{
The idea is the user enter with emissions factors by pollutant
}
\examples{
{
data(decoder)
decoder
}
}
