% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ktdb.R
\name{read_ktdb}
\alias{read_ktdb}
\title{Read old-age mortality from Kannisto-Thatcher (K-T) database and construct a \code{vital} object for use in other functions}
\usage{
read_ktdb(country, triangle = 1)
}
\arguments{
\item{country}{Country name or country code as specified by the KT database. For instance, Australian
data can be obtained using \code{country = "Australia"} or \code{country = 1}.}

\item{triangle}{Lexis triangle number, 1 (default) is lower triangle, 2 is upper triangle.}
}
\value{
\code{read_ktdb} returns a \code{vital} object combining the downloaded data.
}
\description{
\code{read_ktdb} reads old-age mortality data classified by sex, age, year of birth, and calendar year for more than 30 countries.
The series is available in Kannisto-Thatcher (K-T) database (\url{https://www.demogr.mpg.de/cgi-bin/databases/ktdb/datamap.plx})
and constructs a \code{vital} object suitable for use in other functions.
}
\examples{
\dontrun{
australia <- read_ktdb(country = "Australia")
}

}
\author{
Sixian Tang
}
