% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/webhook.R
\name{whapi_log_pretty_json}
\alias{whapi_log_pretty_json}
\title{Convert R objects to pretty JSON for logging}
\usage{
whapi_log_pretty_json(x, max = 2000L)
}
\arguments{
\item{x}{An R object (list, data frame, etc.).}

\item{max}{Integer. Maximum number of characters to print (default: 2000).}
}
\value{
A character string containing JSON (pretty-printed if possible).
}
\description{
Converts R objects to a JSON string for easier inspection in logs.
Falls back to \code{utils::str()} output if \code{jsonlite} is not available
or if JSON conversion fails. Long outputs are truncated with \link{whapi_trunc}.
}
\examples{
whapi_log_pretty_json(list(a = 1, b = "test"))
whapi_log_pretty_json(mtcars[1:2, ], max = 100)
}
