% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{whapi_slugify}
\alias{whapi_slugify}
\title{whapi_slugify strings for safe IDs (e.g., button IDs in Whapi)}
\usage{
whapi_slugify(x)
}
\arguments{
\item{x}{A character vector of labels.}
}
\value{
A character vector of the same length with slugified IDs.
}
\description{
Converts free-text labels into a safe "slug" format suitable for use as
message button IDs or other identifiers in Whapi API requests.
Ensures that IDs contain only lowercase letters, digits, and underscores,
and are never empty (defaults to \code{"btn"} if the input is blank).
}
\details{
This function is particularly useful when creating interactive messages
(buttons, lists) in WhatsApp via Whapi, where each button requires a valid
\code{id}. By whapi_slugifying titles automatically, we can safely generate IDs even if
users provide arbitrary labels with spaces, accents, or symbols.

Transformation steps:
\enumerate{
\item Convert to lowercase;
\item Replace any sequence of non-alphanumeric characters with \verb{_};
\item Trim leading/trailing underscores;
\item Replace empty results with \code{"btn"}.
}
}
\examples{
whapi_slugify(c("Yes!", "Call Us", "Sale!", "###"))
# -> "yes", "call_us", "promocao_rapida", "btn"

# Use case in button creation:
titles <- c("Buy Now", "Learn More")
ids <- whapi_slugify(titles)
tibble::tibble(title = titles, id = ids)

}
\seealso{
Used internally in \code{whapi_send_quick_reply()} and other
interactive message helpers.
}
