% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wikiTools.R
\name{getFiles}
\alias{getFiles}
\title{Downloads a list of files in a specified path of the computer, and return a vector of the no-found names (if any).}
\usage{
getFiles(lista, path = "./", ext = NULL)
}
\arguments{
\item{lista}{A list or data frame of files' URLs to be download (See details).}

\item{path}{Directory where to export the files.}

\item{ext}{Select desired extension of the files. Default= NULL.}
}
\value{
It returns a vector of errors, if any. All pictures are download into the selected directory (NULL= no errors).
}
\description{
Downloads a list of files in a specified path of the computer, and return a vector of the no-found names (if any).
}
\details{
This function allows download a file of files directly into your directory.
This function needs a preexistent data frame of names and pictures' URL. It must be a list (or data.frame) with two values: "name" (specifying the names of the files) and "url" (containing the urls to the files to download)..
All the errors are reported as outcomes (NULL= no errors). The files are donwload into your chosen directory.
}
\examples{
## Not run: 

## In case you want to download a file directly from an URL:

# dta <- data.frame(name = "Data", url = "https://sociocav.usal.es/me/Stata/example.dta")
# getFiles(dta, path = "./")

##  You can can also combine this function with getWikiData (among others).
## In case you want to download a picture of a person:

# A <- data.frame(name= getWikiData("Rembrandt")$label, url=getWikiData("Rembrandt")$pics)
# getFiles(A, path = "./", ext = "png")

## Or the pics of multiple authors: 

# B <- getWikiData(c("Monet", "Renoir", "Caillebotte"))
# data <- data.frame(name = B$label, url = B$pics)
# getFiles(data, path = "./", ext = NULL)

## End(Not run)
}
\author{
Modesto Escobar, Department of Sociology and Communication, University of Salamanca. See \url{https://sociocav.usal.es/blog/modesto-escobar/}
}
