% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ae.R
\name{aeDensity}
\alias{aeDensity}
\title{Asymptotic Expansion - Density}
\usage{
aeDensity(..., ae, eps = 1, order = NULL)
}
\arguments{
\item{...}{named argument, data.frame, list, or environment specifying the grid to evaluate the density. See examples.}

\item{ae}{an object of class \code{\link{yuima.ae-class}}.}

\item{eps}{numeric. The intensity of the perturbation.}

\item{order}{integer. The expansion order. If \code{NULL} (default), it uses the maximum order used in \code{ae}.}
}
\value{
Probability density function evaluated on the given grid.
}
\description{
Asymptotic Expansion - Density
}
\examples{
\dontrun{
# model
gbm <- setModel(drift = 'mu*x', diffusion = 'sigma*x', solve.variable = 'x')

# settings
xinit <- 100
par <- list(mu = 0.01, sigma = 0.2)
sampling <- setSampling(Initial = 0, Terminal = 1, n = 1000)

# asymptotic expansion
approx <- ae(model = gbm, sampling = sampling, order = 4, true.parameter = par, xinit = xinit)

# The following are all equivalent methods to specify the grid via ....
# Notice that the character 'x' corresponds to the solve.variable of the yuima model.

# 1) named argument  
x <- seq(50, 200, by = 0.1)
density <- aeDensity(x = x, ae = approx, order = 4)
# 2) data frame
df <- data.frame(x = seq(50, 200, by = 0.1))
density <- aeDensity(df, ae = approx, order = 4)
# 3) environment
env <- new.env()
env$x <- seq(50, 200, by = 0.1)
density <- aeDensity(env, ae = approx, order = 4)
# 4) list
lst <- list(x = seq(50, 200, by = 0.1))
density <- aeDensity(lst, ae = approx, order = 4)

# exact density
exact <- dlnorm(x = x, meanlog = log(xinit)+(par$mu-0.5*par$sigma^2)*1, sdlog = par$sigma*sqrt(1))

# compare
plot(x = exact, y = density, xlab = "Exact", ylab = "Approximated")
}
}
