\name{ducks}
\alias{ducks}
\title{
Behavioral and Plumage Characteristics of Hybrid Ducks
}
\description{
The \code{ducks} data frame has 11 rows and 2 columns.


Each row of the data frame represents a male duck who is a second
generation cross of mallard and pintail ducks.  For 11 such ducks a
behavioural and plumage index were calculated.  These were measured on
scales devised for this experiment which was to examine whether there
was any link between which species the ducks resembled physically and
which they resembled in behaviour.  The scale for the physical
appearance ranged from 0 (identical in appearance to a mallard) to 20
(identical to a pintail).  The behavioural traits of the ducks were on
a scale from 0 to 15 with lower numbers indicating closer to
mallard-like in behaviour.
}
\usage{
ducks
}
\format{
This data frame contains the following columns:


\describe{
\item{\code{plumage}}{
The index of physical appearance based on the plumage of individual ducks.
}
\item{\code{behaviour}}{
The index of behavioural characteristics of the ducks.
}}}
\source{
The data were obtained from


Larsen, R.J. and Marx, M.L. (1986) 
\emph{An Introduction to Mathematical Statistics and its Applications} 
(Second Edition). Prentice-Hall.
}
\references{
Davison, A.C. and Hinkley, D.V. (1997) 
\emph{Bootstrap Methods and Their Application}. Cambridge University Press.


Sharpe, R.S., and Johnsgard, P.A. (1966)
Inheritance of behavioral characters in
\eqn{F_2}{F2} mallard  x  pintail
(\emph{Anas Platyrhynchos L.  x  Anas Acuta L.}) 
hybrids. \emph{Behaviour}, \bold{27}, 259-272.
}
\keyword{datasets}
