% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generic_support.r
\name{colourToAmigaRaw}
\alias{colourToAmigaRaw}
\alias{amigaRawToColour}
\title{Convert colours to Amiga compatible raw data or vice versa}
\usage{
colourToAmigaRaw(
  x,
  colour.depth = c("12 bit", "24 bit"),
  n.bytes = c("2", "3")
)

amigaRawToColour(
  x,
  colour.depth = c("12 bit", "24 bit"),
  n.bytes = c("2", "3")
)
}
\arguments{
\item{x}{In the case \code{amigaRawToColour} is called, \code{x} should
be a \code{vector} of \code{raw} data. The length of this vector should
be a multiple of 2 (when \code{n.bytes = "2"}) or 3 (when
\code{n.bytes = "3"}). When \code{colourToAmigaRaw} is called, \code{x}
should be a \code{character} strings representing a colour.}

\item{colour.depth}{A \code{character} string: \code{"12 bit"} (default) or
\code{"24 bit"}. The first should be used in most cases, as old Amigas
have a 12 bit colour depth.}

\item{n.bytes}{A \code{character} string: \code{"2"} or \code{"3"}. The
number of bytes that is used or should be used to store each colour.}
}
\value{
In the case \code{amigaRawToColour} is called, a (vector of)
colour \code{character} string(s) is returned. When \code{colourToAmigaRaw}
is called, \code{raw} representing the colour(s) specified in \code{x} is
returned.
}
\description{
Convert colours to Amiga compatible raw data or vice versa, such that
it can be used in graphical objects from the Commodore Amiga.
}
\details{
On the original Commodore Amiga chipset, graphics used indexed palettes of
12 bit colours. Colours are specified by their RGB (Red, Green and Blue)
values, each component requiring 4 bits (with corresponding values ranging
from 0 up to 15). Data structures on the Amiga were WORD (2 bytes) aligned.
Colours are therefore typically stored in either 2 bytes (skipping the
first four bits) or 3 bytes (one byte for each value).

These functions can be used to convert R colours into the closest matching
Amiga colour in a \code{raw} format, or vice versa. Note that later Amiga
models with the advanced (graphics) architecture (known as AA or AGA) allowed
for 24 bit colours.
}
\examples{
## Let's create some Amiga palettes:
colourToAmigaRaw(c("red", "navy blue", "brown", "#34AC5A"))

## let's do the reverse.
## this is white:
amigaRawToColour(as.raw(c(0x0f, 0xff)))

## this is white specified in 3 bytes:
amigaRawToColour(as.raw(c(0xf0, 0xf0, 0xf0)), n.bytes = "3")

## lower nybbles are ignored, you will get a warning when it is not zero:
# amigaRawToColour(as.raw(c(0xf0, 0xf0, 0x0f)), n.bytes = "3")
}
\seealso{
Other raw.operations: 
\code{\link{as.AmigaBasic}()},
\code{\link{as.raw.AmigaBasic}()},
\code{\link{packBitmap}()},
\code{\link{rawToAmigaBasicBMAP}()},
\code{\link{rawToAmigaBasicShape}()},
\code{\link{rawToAmigaBasic}()},
\code{\link{rawToAmigaBitmapFontSet}()},
\code{\link{rawToAmigaBitmapFont}()},
\code{\link{rawToAmigaIcon}()},
\code{\link{rawToHWSprite}()},
\code{\link{rawToIFFChunk}()},
\code{\link{rawToSysConfig}()},
\code{\link{simpleAmigaIcon}()}
}
\author{
Pepijn de Vries
}
\concept{raw.operations}
