% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Object.R
\name{andromeda}
\alias{andromeda}
\title{Create an Andromeda object}
\usage{
andromeda(..., options = list())
}
\arguments{
\item{...}{Named objects. See details for what objects are valid. If no objects are provided, an
empty Andromeda is returned.}

\item{options}{A named list of options. Currently the only supported option is 'threads' (see example).
All other options are ignored.}
}
\value{
Returns an \code{\link{Andromeda}} object.
}
\description{
By default the \code{Andromeda} object is created in the systems temporary file location. You can override
this by specifying a folder using \code{options(andromedaTempFolder = "c:/andromedaTemp")}, where
\code{"c:/andromedaTemp"} is the folder to create the Andromeda objects in.

Although in general Andromeda is well-behaved in terms of memory usage, it can consume a lot of
memory for specific operations such as sorting and aggregating. By default the memory usage is
limited to 75\% of the physical memory. However it is possible to set another limit by using
\code{options(andromedaMemoryLimit = 2.5)}, where \code{2.5} is the number of GB to use at most. One GB is
1,000,000,000 bytes.

Similarly, by default Andromeda will use all available CPU cores when needed. The \code{andromedaThreads}
option controls the maximum number of threads Andromeda is allowed to use.
}
\details{
Valid objects are data frames, \code{Andromeda} tables, or any other \code{dplyr} table.
}
\examples{
andr <- andromeda(cars = cars, iris = iris)

names(andr)
# [1] 'cars' 'iris'

andr$cars \%>\% filter(speed > 10) \%>\% collect()
# # A tibble: 41 x 2 
# speed dist 
# <dbl> <dbl> 
# 1 11 17 
# ...

close(andr)

# Use multiple threads for queries
andr <- andromeda(cars = cars, iris = iris, options = list(threads = 8))


}
