% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-pgs-rank.R
\name{create.pgs.rank.plot}
\alias{create.pgs.rank.plot}
\title{Plot PGS Rank}
\usage{
create.pgs.rank.plot(
  pgs.data,
  phenotype.columns = NULL,
  missing.genotype.style = "count",
  categorical.palette = NULL,
  binary.palette = NULL,
  output.dir = NULL,
  filename.prefix = NULL,
  file.extension = "png",
  width = 8,
  height = 8,
  xaxis.cex = 1.2,
  yaxis.cex = 1,
  titles.cex = 1.2,
  border.padding = 1
)
}
\arguments{
\item{pgs.data}{data.frame PGS data as formatted by \code{apply.polygenic.score()} Required columns: \code{Indiv, percentile, decile, quartile, n.missing.genotypes, percent.missing.genotypes,} and optionally user-defined percentiles and phenotype covariates.
This function is designed to work with the output of the function apply.polygenic.score().}

\item{phenotype.columns}{character vector of column names in pgs.data containing phenotype covariates to plot as color bars. Default is \code{NULL}.}

\item{missing.genotype.style}{character style of missing genotype barplot. Default is "count". Options are "count" or "percent".}

\item{categorical.palette}{character vector of colors to use for categorical phenotype covariates. Default is \code{NULL} in which case the default palette is used, which contains 12 unique colors.
If the number of unique categories exceeds the number of colors in the color palette, an error will be thrown.}

\item{binary.palette}{character vector of colors to use for binary and continuous phenotype covariates. Each color is contrasted with white to create a color ramp or binary categories.
Default is \code{NULL} in which case the default palette is used, which contains 9 unique colors paired with white.
If the number of binary and continuous phenotype covariates exceeds the number of colors in the color palette, an error will be thrown.}

\item{output.dir}{character directory path to write plot to file. Default is \code{NULL} in which case the plot is returned as lattice multipanel object.}

\item{filename.prefix}{character prefix for plot filename.}

\item{file.extension}{character file extension for plot file. Default is "png".}

\item{width}{numeric width of plot in inches.}

\item{height}{numeric height of plot in inches.}

\item{xaxis.cex}{numeric size of x-axis labels.}

\item{yaxis.cex}{numeric size of y-axis labels.}

\item{titles.cex}{numeric size of plot titles.}

\item{border.padding}{numeric padding around plot border.}
}
\value{
If no output directory is provided, a multipanel lattice plot object is returned, otherwise a plot is written to the indicated path and \code{NULL} is returned.

For clarity, certain plot aspects change when sample size exceeds 50:
\itemize{
\item x-axis labels are no longer displayed
\item missing (NA) values are not labeled with text in heatmaps but are color-coded with a legend
}

Colors for continuous and binary phenotypes are chosen from the binary color palettes in \code{BoutrosLab.plotting.general::default.colours()}.
Colors for categorical phenotypes are chosen by default from the qualitative color palette in \code{BoutrosLab.plotting.general::default.colours()}.
}
\description{
Plot PGS percentile rank of each sample outputted by \code{apply.polygenic.score()} as a barplot, plot missing genotypes if any are present, plot corresponding decile and quartile markers as a heatmap, optionally plot phenotype covariates as color bars.
}
\examples{
set.seed(200);
percentiles <- get.pgs.percentiles(rnorm(200, 0, 1));
pgs.data <- data.frame(
    Indiv = paste0('sample', 1:200),
    percentile = percentiles$percentile,
    decile = percentiles$decile,
    quartile = percentiles$quartile,
    n.missing.genotypes = sample(1:10, 200, replace = TRUE),
    percent.missing.genotypes = sample(1:10, 200, replace = TRUE) / 100,
    continuous.pheno = rnorm(200, 1, 1),
    categorical.pheno = sample(letters[1:5], 200, replace = TRUE),
    binary.pheno = sample(c(0,1), 200, replace = TRUE)
    );

temp.dir <- tempdir();

create.pgs.rank.plot(
    pgs.data,
    phenotype.columns = c('continuous.pheno', 'categorical.pheno', 'binary.pheno'),
    missing.genotype.style = 'percent',
    output.dir = temp.dir,
    filename.prefix = 'example-rank-plot'
    );
}
