% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assess-strand-flip.R
\name{flip.DNA.allele}
\alias{flip.DNA.allele}
\title{Flip DNA allele}
\usage{
flip.DNA.allele(alleles, return.indels.as.missing = FALSE)
}
\arguments{
\item{alleles}{A character vector of DNA alleles.}

\item{return.indels.as.missing}{A logical value indicating whether to return NA for INDEL alleles. Default is \code{FALSE}.}
}
\value{
A character vector of flipped DNA alleles. INDEL alleles are returned as is unless \code{return.indels.as.missing} is \code{TRUE}.
}
\description{
Flip single base pair DNA alleles to their reverse complement. INDEL flipping is not supported.
}
\examples{
alleles <- c('A', 'T', 'C', 'G', 'ATG', NA);
flip.DNA.allele(alleles);
}
