/*
 * Decompiled with CFR 0.152.
 */
package dr.evolution.datatype;

import dr.evolution.datatype.DataType;

public class Nucleotides
extends DataType {
    public static final String JC = "JC";
    public static final String F84 = "F84";
    public static final String HKY = "HKY";
    public static final String GTR = "GTR";
    public static final String DESCRIPTION = "nucleotide";
    public static final int TYPE = 0;
    public static final Nucleotides INSTANCE = new Nucleotides();
    public static final int A_STATE = 0;
    public static final int C_STATE = 1;
    public static final int G_STATE = 2;
    public static final int UT_STATE = 3;
    public static final int R_STATE = 5;
    public static final int Y_STATE = 6;
    public static final int UNKNOWN_STATE = 16;
    public static final int GAP_STATE = 17;
    public static final char[] NUCLEOTIDE_CHARS = new char[]{'A', 'C', 'G', 'T', 'U', 'K', 'M', 'R', 'S', 'W', 'Y', 'B', 'D', 'H', 'V', 'N', '?', '-'};
    public static final int[] NUCLEOTIDE_STATES = new int[]{17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 17, 16, 17, 0, 11, 1, 12, 16, 16, 2, 13, 16, 16, 10, 16, 7, 15, 16, 16, 16, 5, 9, 3, 3, 14, 8, 16, 6, 16, 17, 17, 17, 17, 17, 17, 0, 11, 1, 12, 16, 16, 2, 13, 16, 16, 10, 16, 7, 15, 16, 16, 16, 5, 9, 3, 3, 14, 8, 16, 6, 16, 17, 17, 17, 17, 17};
    public static final String[] NUCLEOTIDE_AMBIGUITIES = new String[]{"A", "C", "G", "T", "T", "AG", "CT", "AC", "AT", "CG", "GT", "CGT", "AGT", "ACT", "ACG", "ACGT", "ACGT", "ACGT"};

    protected Nucleotides() {
        this.stateCount = 4;
        this.ambiguousStateCount = 18;
    }

    @Override
    public char[] getValidChars() {
        return NUCLEOTIDE_CHARS;
    }

    @Override
    public int getState(char c) {
        return NUCLEOTIDE_STATES[c];
    }

    @Override
    public int getUnknownState() {
        return 16;
    }

    @Override
    public int getGapState() {
        return 17;
    }

    @Override
    public char getChar(int n) {
        return NUCLEOTIDE_CHARS[n];
    }

    @Override
    public int[] getStates(int n) {
        String string = NUCLEOTIDE_AMBIGUITIES[n];
        int[] nArray = new int[string.length()];
        for (int i = 0; i < string.length(); ++i) {
            nArray[i] = this.getState(string.charAt(i));
        }
        return nArray;
    }

    @Override
    public boolean[] getStateSet(int n) {
        int n2;
        boolean[] blArray = new boolean[this.stateCount];
        for (n2 = 0; n2 < this.stateCount; ++n2) {
            blArray[n2] = false;
        }
        n2 = NUCLEOTIDE_AMBIGUITIES[n].length();
        for (int i = 0; i < n2; ++i) {
            blArray[this.getState((char)Nucleotides.NUCLEOTIDE_AMBIGUITIES[n].charAt((int)i))] = true;
        }
        return blArray;
    }

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    @Override
    public int getType() {
        return 0;
    }
}

