/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.arg;

import dr.evolution.tree.FlexibleTree;
import dr.evolution.tree.MutableTree;
import dr.evolution.tree.MutableTreeListener;
import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evolution.tree.TreeUtils;
import dr.evolution.util.MutableTaxonListListener;
import dr.evolution.util.Taxon;
import dr.evolution.util.Units;
import dr.evomodel.arg.ARGTree;
import dr.evomodel.arg.likelihood.ARGLikelihood;
import dr.evomodel.tree.TreeChangedEvent;
import dr.inference.loggers.LogColumn;
import dr.inference.loggers.Loggable;
import dr.inference.loggers.NumberColumn;
import dr.inference.model.AbstractModel;
import dr.inference.model.Bounds;
import dr.inference.model.CompoundParameter;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.ParameterParser;
import dr.inference.model.Statistic;
import dr.inference.model.Variable;
import dr.inference.parallel.MPIServices;
import dr.math.MathUtils;
import dr.util.Attributable;
import dr.util.NumberFormatter;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.Reference;
import dr.xml.StringAttributeRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import org.jdom.Document;
import org.jdom.Element;

public class ARGModel
extends AbstractModel
implements MutableTree,
Loggable {
    public static final String TREE_MODEL = "argTreeModel";
    public static final String ROOT_HEIGHT = "rootHeight";
    public static final String LEAF_HEIGHT = "leafHeight";
    public static final String NODE_HEIGHTS = "nodeHeights";
    public static final String NODE_RATES = "nodeRates";
    public static final String NODE_TRAITS = "nodeTraits";
    public static final String ROOT_NODE = "rootNode";
    public static final String INTERNAL_NODES = "internalNodes";
    public static final String LEAF_NODES = "leafNodes";
    public static final String TAXON = "taxon";
    public static final String GRAPH_ELEMENT = "graph";
    public static final String NODE_ELEMENT = "node";
    public static final String EDGE_ELEMENT = "edge";
    public static final String ID_ATTRIBUTE = "id";
    public static final String EDGE_FROM = "source";
    public static final String EDGE_TO = "target";
    public static final String TAXON_NAME = "taxonName";
    public static final String EDGE_LENGTH = "len";
    public static final String EDGE_PARTITIONS = "edgePartitions";
    public static final String IS_TIP = "isTip";
    public static final String IS_ROOT = "isRoot";
    public static final String LEFT_PARENT = "leftParent";
    public static final String RIGHT_PARENT = "rightParent";
    public static final String LEFT_CHILD = "leftChild";
    public static final String RIGHT_CHILD = "rightChild";
    public static final String NODE_HEIGHT = "nodeHeight";
    public static final String IS_REASSORTMENT = "true";
    public static final String NUM_PARTITIONS = "numberOfPartitions";
    public static final String GRAPH_SIZE = "size=\"6,6\"";
    public static final String DOT_EDGE_DEF = "edge[style=\"setlinewidth(2)\",arrowhead=none]";
    public static final String DOT_NODE_DEF = "node[shape=plaintext,width=auto,fontname=Helvitica,fontsize=10]";
    public static final int LEFT = 0;
    public static final int RIGHT = 1;
    public static final String PARTITION_TYPE = "partitionType";
    public static final String REASSORTMENT_PARTITION = "reassortment";
    public static final String RECOMBINATION_PARTITION = "recombination";
    public static final String PARTITION_DEFAULT_TYPE = "reassortment";
    protected int storedRootNumber;
    protected int nodeCount;
    protected int storedNodeCount;
    protected int externalNodeCount;
    protected int internalNodeCount;
    protected int storedInternalNodeCount;
    protected boolean inEdit = false;
    protected Node root = null;
    public ArrayList<Node> nodes = null;
    public ArrayList<Node> storedNodes = null;
    protected Parameter[] addedParameters = null;
    protected Parameter[] removedParameters = null;
    protected Parameter addedPartitioningParameter = null;
    protected Parameter removedPartitioningParameter = null;
    protected CompoundParameter partitioningParameters;
    protected CompoundParameter storedInternalNodeHeights;
    protected CompoundParameter storedInternalAndRootNodeHeights;
    protected CompoundParameter storedNodeRates;
    protected Node[] addedNodes = null;
    protected Node[] removedNodes = null;
    private Units.Type units;
    private boolean hasRates = false;
    private boolean hasTraits = false;
    private int nullCounter = 0;
    private int storedNullCounter;
    protected String partitionType = "reassortment";
    public static final int MAX_LABEL_COUNT = 10;
    private ArrayList<ARGLikelihood> likelihoodCalculators;
    private int maxNumberOfPartitions;
    protected final List<TreeChangedEvent> treeChangedEvents = new ArrayList<TreeChangedEvent>();
    protected Node oldRoot;
    protected String id = null;
    private Attributable.AttributeHelper treeAttributes = null;
    public static final String nullEdge = " -";
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private final String[] partitionFormats = new String[]{"reassortment", "recombination"};
        private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{new StringAttributeRule("partitionType", "Describes the partition structure of the model", this.partitionFormats, true), new ElementRule(Tree.class), new ElementRule("rootHeight", Parameter.class, "A parameter definition with id only (cannot be a reference!)", false), new ElementRule("nodeHeights", new XMLSyntaxRule[]{AttributeRule.newBooleanRule("rootNode", true, "If true the root height is included in the parameter"), AttributeRule.newBooleanRule("internalNodes", true, "If true the internal node heights (minus the root) are included in the parameter"), new ElementRule(Parameter.class, "A parameter definition with id only (cannot be a reference!)")}, 1, Integer.MAX_VALUE)};

        @Override
        public String getParserName() {
            return ARGModel.TREE_MODEL;
        }

        @Override
        public String[] getParserNames() {
            return new String[]{this.getParserName(), "argModel"};
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            Tree tree = (Tree)xMLObject.getChild(Tree.class);
            ARGModel aRGModel = new ARGModel(tree);
            Logger.getLogger("dr.evomodel").info("Creating the tree model, '" + xMLObject.getId() + "'");
            if (xMLObject.hasAttribute(ARGModel.PARTITION_TYPE)) {
                aRGModel.partitionType = xMLObject.getStringAttribute(ARGModel.PARTITION_TYPE);
                if (!aRGModel.partitionType.equals("reassortment") && !aRGModel.partitionType.equals(ARGModel.RECOMBINATION_PARTITION)) {
                    throw new XMLParseException("Must use either correct partition type");
                }
            }
            int n = 1;
            if (xMLObject.hasAttribute(ARGModel.NUM_PARTITIONS)) {
                n = xMLObject.getIntegerAttribute(ARGModel.NUM_PARTITIONS);
            }
            Logger.getLogger("dr.evomodel").info(xMLObject.getId() + " has partition type: " + aRGModel.partitionType);
            for (int i = 0; i < xMLObject.getChildCount(); ++i) {
                if (xMLObject.getChild(i) instanceof XMLObject) {
                    boolean bl;
                    XMLObject xMLObject2 = (XMLObject)xMLObject.getChild(i);
                    if (xMLObject2.getName().equals(ARGModel.ROOT_HEIGHT)) {
                        ParameterParser.replaceParameter(xMLObject2, aRGModel.getRootHeightParameter());
                        continue;
                    }
                    if (xMLObject2.getName().equals(ARGModel.LEAF_HEIGHT)) {
                        if (!xMLObject2.hasAttribute(ARGModel.TAXON)) {
                            throw new XMLParseException("taxa element missing from leafHeight element in treeModel element");
                        }
                        String string = xMLObject2.getStringAttribute(ARGModel.TAXON);
                        bl = aRGModel.getTaxonIndex(string);
                        if (bl) {
                            throw new XMLParseException("taxon " + string + " not found for leafHeight element in treeModel element");
                        }
                        NodeRef nodeRef = aRGModel.getExternalNode(bl ? 1 : 0);
                        ParameterParser.replaceParameter(xMLObject2, aRGModel.getLeafHeightParameter(nodeRef));
                        continue;
                    }
                    if (xMLObject2.getName().equals(ARGModel.NODE_HEIGHTS)) {
                        boolean bl2 = false;
                        bl = false;
                        boolean bl3 = false;
                        if (xMLObject2.hasAttribute(ARGModel.ROOT_NODE)) {
                            bl2 = xMLObject2.getBooleanAttribute(ARGModel.ROOT_NODE);
                        }
                        if (xMLObject2.hasAttribute(ARGModel.INTERNAL_NODES)) {
                            bl = xMLObject2.getBooleanAttribute(ARGModel.INTERNAL_NODES);
                        }
                        if (xMLObject2.hasAttribute(ARGModel.LEAF_NODES)) {
                            bl3 = xMLObject2.getBooleanAttribute(ARGModel.LEAF_NODES);
                        }
                        if (!(bl2 || bl || bl3)) {
                            throw new XMLParseException("one or more of root, internal or leaf nodes must be selected for the nodeHeights element");
                        }
                        ParameterParser.replaceParameter(xMLObject2, aRGModel.createNodeHeightsParameter(bl2, bl, bl3));
                        continue;
                    }
                    if (xMLObject2.getName().equals(ARGModel.NODE_RATES)) {
                        boolean bl4 = false;
                        bl = false;
                        boolean bl5 = false;
                        if (xMLObject2.hasAttribute(ARGModel.ROOT_NODE)) {
                            bl4 = xMLObject2.getBooleanAttribute(ARGModel.ROOT_NODE);
                        }
                        if (xMLObject2.hasAttribute(ARGModel.INTERNAL_NODES)) {
                            bl = xMLObject2.getBooleanAttribute(ARGModel.INTERNAL_NODES);
                        }
                        if (xMLObject2.hasAttribute(ARGModel.LEAF_NODES)) {
                            bl5 = xMLObject2.getBooleanAttribute(ARGModel.LEAF_NODES);
                        }
                        if (!(bl4 || bl || bl5)) {
                            throw new XMLParseException("one or more of root, internal or leaf nodes must be selected for the nodeRates element");
                        }
                        ParameterParser.replaceParameter(xMLObject2, aRGModel.createNodeRatesParameter(bl4, bl, bl5, n));
                        continue;
                    }
                    if (xMLObject2.getName().equals(ARGModel.NODE_TRAITS)) {
                        boolean bl6 = false;
                        bl = false;
                        boolean bl7 = false;
                        if (xMLObject2.hasAttribute(ARGModel.ROOT_NODE)) {
                            bl6 = xMLObject2.getBooleanAttribute(ARGModel.ROOT_NODE);
                        }
                        if (xMLObject2.hasAttribute(ARGModel.INTERNAL_NODES)) {
                            bl = xMLObject2.getBooleanAttribute(ARGModel.INTERNAL_NODES);
                        }
                        if (xMLObject2.hasAttribute(ARGModel.LEAF_NODES)) {
                            bl7 = xMLObject2.getBooleanAttribute(ARGModel.LEAF_NODES);
                        }
                        if (!(bl6 || bl || bl7)) {
                            throw new XMLParseException("one or more of root, internal or leaf nodes must be selected for the nodeTraits element");
                        }
                        ParameterParser.replaceParameter(xMLObject2, aRGModel.createNodeTraitsParameter(bl6, bl, bl7));
                        continue;
                    }
                    throw new XMLParseException("illegal child element in " + this.getParserName() + ": " + xMLObject2.getName());
                }
                if (xMLObject.getChild(i) instanceof Tree) continue;
                throw new XMLParseException("illegal child element in  " + this.getParserName() + ": " + xMLObject.getChildName(i) + " " + xMLObject.getChild(i));
            }
            aRGModel.setupHeightBounds();
            Logger.getLogger("dr.evomodel").info("  initial tree topology = " + TreeUtils.uniqueNewick(aRGModel, aRGModel.getRoot()));
            return aRGModel;
        }

        @Override
        public String getParserDescription() {
            return "This element represents a model of the tree. The tree model includes and attributes of the nodes including the age (or <i>height</i>) and the rate of evolution at each node in the tree.";
        }

        @Override
        public String getExample() {
            return "<!-- the tree model as special sockets for attaching parameters to various aspects of the tree     -->\n<!-- The treeModel below shows the standard setup with a parameter associated with the root height -->\n<!-- a parameter associated with the internal node heights (minus the root height) and             -->\n<!-- a parameter associates with all the internal node heights                                     -->\n<!-- Notice that these parameters are overlapping                                                  -->\n<!-- The parameters are subsequently used in operators to propose changes to the tree node heights -->\n<treeModel id=\"treeModel1\">\n\t<tree idref=\"startingTree\"/>\n\t<rootHeight>\n\t\t<parameter id=\"treeModel1.rootHeight\"/>\n\t</rootHeight>\n\t<nodeHeights internalNodes=\"true\" rootNode=\"false\">\n\t\t<parameter id=\"treeModel1.internalNodeHeights\"/>\n\t</nodeHeights>\n\t<nodeHeights internalNodes=\"true\" rootNode=\"true\">\n\t\t<parameter id=\"treeModel1.allInternalNodeHeights\"/>\n\t</nodeHeights>\n</treeModel>";
        }

        @Override
        public Class getReturnType() {
            return ARGModel.class;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }

        public Parameter oldGetParameter(XMLObject xMLObject) throws XMLParseException {
            int n = 0;
            Parameter parameter = null;
            for (int i = 0; i < xMLObject.getChildCount(); ++i) {
                if (!(xMLObject.getChild(i) instanceof Parameter)) continue;
                parameter = (Parameter)xMLObject.getChild(i);
                ++n;
            }
            if (n == 0) {
                throw new XMLParseException("no parameter element in treeModel " + xMLObject.getName() + " element");
            }
            if (n > 1) {
                throw new XMLParseException("More than one parameter element in treeModel " + xMLObject.getName() + " element");
            }
            return parameter;
        }

        public void oldReplaceParameter(XMLObject xMLObject, Parameter parameter) throws XMLParseException {
            for (int i = 0; i < xMLObject.getChildCount(); ++i) {
                if (!(xMLObject.getChild(i) instanceof Parameter)) continue;
                XMLObject xMLObject2 = null;
                Object object = xMLObject.getRawChild(i);
                if (object instanceof Reference) {
                    xMLObject2 = ((Reference)object).getReferenceObject();
                } else if (object instanceof XMLObject) {
                    xMLObject2 = (XMLObject)object;
                } else {
                    throw new XMLParseException("object reference not available");
                }
                if (xMLObject2.getChildCount() > 0) {
                    throw new XMLParseException("No child elements allowed in parameter element.");
                }
                if (xMLObject2.hasAttribute("idref")) {
                    throw new XMLParseException("References to " + xMLObject.getName() + " parameters are not allowed in treeModel.");
                }
                if (xMLObject2.hasAttribute("value")) {
                    throw new XMLParseException("Parameters in " + xMLObject.getName() + " have values set automatically.");
                }
                if (xMLObject2.hasAttribute("upper")) {
                    throw new XMLParseException("Parameters in " + xMLObject.getName() + " have bounds set automatically.");
                }
                if (xMLObject2.hasAttribute("lower")) {
                    throw new XMLParseException("Parameters in " + xMLObject.getName() + " have bounds set automatically.");
                }
                if (xMLObject2.hasAttribute(ARGModel.ID_ATTRIBUTE)) {
                    parameter.setId(xMLObject2.getStringAttribute(ARGModel.ID_ATTRIBUTE));
                }
                xMLObject2.setNativeObject(parameter);
                return;
            }
        }
    };

    public ARGModel(ArrayList<Node> arrayList, Node node, int n, int n2) {
        super(TREE_MODEL);
        this.nodes = arrayList;
        this.root = node;
        this.maxNumberOfPartitions = n;
        this.externalNodeCount = n2;
        if (arrayList != null) {
            this.nodeCount = arrayList.size();
        }
        this.internalNodeCount = this.nodeCount - n2;
    }

    public ARGModel(Tree tree) {
        super(TREE_MODEL);
        int n;
        this.partitioningParameters = new CompoundParameter("partitioning");
        FlexibleTree flexibleTree = new FlexibleTree(tree);
        flexibleTree.resolveTree();
        Node node = new Node(flexibleTree, flexibleTree.getRoot());
        this.internalNodeCount = flexibleTree.getInternalNodeCount();
        this.externalNodeCount = flexibleTree.getExternalNodeCount();
        this.nodeCount = this.internalNodeCount + this.externalNodeCount;
        this.nodes = new ArrayList(this.nodeCount);
        this.storedNodes = new ArrayList(this.nodeCount);
        for (n = 0; n < this.nodeCount; ++n) {
            this.nodes.add(null);
            this.storedNodes.add(null);
        }
        n = 0;
        int n2 = this.externalNodeCount;
        this.root = node;
        do {
            Node node2;
            if ((node = (Node)TreeUtils.postorderSuccessor(this, node)).isExternal()) {
                node.number = n;
                this.nodes.set(n, node);
                node2 = new Node();
                node2.taxon = node.taxon;
                node2.number = n;
                this.storedNodes.set(n, node2);
                ++n;
                continue;
            }
            node.number = n2;
            this.nodes.set(n2, node);
            node2 = new Node();
            node2.number = n2;
            this.storedNodes.set(n2, node2);
            ++n2;
        } while (node != this.root);
    }

    private double nextTime(int n, double d, double d2) {
        double d3 = n;
        double d4 = d3 * (d3 - 1.0 + d2) / (2.0 * d);
        return MathUtils.nextExponential(d4);
    }

    private boolean nextEventIsBifurcation(int n, double d) {
        double d2 = (double)(n - 1) / ((double)(n - 1) + d);
        return MathUtils.nextDouble() < d2;
    }

    public ARGModel(int n, double d, double d2) {
        super("Simulator");
        ArrayList<Object> arrayList = new ArrayList<Object>(50);
        ArrayList<Object> arrayList2 = new ArrayList<Object>(50);
        this.nodes = new ArrayList();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            Node node = new Node();
            node.heightParameter = new Parameter.Default(0.0);
            this.nodes.add(node);
            arrayList2.add(node);
            node.bifurcation = true;
            node.number = n2++;
            node.taxon = new Taxon("" + n2);
            SimulateSticks simulateSticks = new SimulateSticks(node, true);
            arrayList.add(simulateSticks);
        }
        double d3 = 0.0;
        while (arrayList.size() > 1) {
            Node node;
            Object object;
            Object object2;
            Object object3;
            Object object4;
            d3 += this.nextTime(arrayList.size(), d, d2);
            if (this.nextEventIsBifurcation(arrayList.size(), d2)) {
                SimulateSticks[] simulateSticksArray = new SimulateSticks[2];
                for (int i = 0; i < 2; ++i) {
                    int n3 = MathUtils.nextInt(arrayList.size());
                    simulateSticksArray[i] = (SimulateSticks)arrayList.get(n3);
                    arrayList.remove(n3);
                }
                object4 = new Node();
                this.nodes.add((Node)object4);
                ((Node)object4).heightParameter = new Parameter.Default(d3);
                ((Node)object4).number = n2++;
                ((Node)object4).bifurcation = true;
                object3 = new SimulateSticks((Node)object4, true);
                if (simulateSticksArray[0].mySon == simulateSticksArray[1].mySon) {
                    ((Node)object4).leftChild = object2 = simulateSticksArray[0].mySon;
                    ((Node)object4).rightChild = object2;
                    ((Node)object2).rightParent = object4;
                    ((Node)object2).leftParent = object4;
                    arrayList2.remove(arrayList2.indexOf(object2));
                    arrayList2.add(object4);
                    arrayList.add(object3);
                    continue;
                }
                object2 = simulateSticksArray[0].mySon;
                object = simulateSticksArray[1].mySon;
                ((Node)object4).leftChild = object2;
                ((Node)object4).rightChild = object;
                if (((Node)object2).bifurcation) {
                    ((Node)object2).leftParent = object4;
                    ((Node)object2).rightParent = object4;
                    arrayList2.remove(arrayList2.indexOf(object2));
                } else {
                    if (simulateSticksArray[0].leftStick) {
                        ((Node)object2).leftParent = object4;
                    } else {
                        ((Node)object2).rightParent = object4;
                    }
                    if (((Node)object2).leftParent != null && ((Node)object2).rightParent != null) {
                        arrayList2.remove(arrayList2.indexOf(object2));
                    }
                }
                if (((Node)object).bifurcation) {
                    ((Node)object).leftParent = object4;
                    ((Node)object).rightParent = object4;
                    arrayList2.remove(arrayList2.indexOf(object));
                } else {
                    if (simulateSticksArray[1].leftStick) {
                        ((Node)object).leftParent = object4;
                    } else {
                        ((Node)object).rightParent = object4;
                    }
                    if (((Node)object).leftParent != null && ((Node)object).rightParent != null) {
                        arrayList2.remove(arrayList2.indexOf(object));
                    }
                }
                arrayList2.add(object4);
                arrayList.add(object3);
                continue;
            }
            int n4 = MathUtils.nextInt(arrayList.size());
            object4 = (SimulateSticks)arrayList.get(n4);
            arrayList.remove(n4);
            object3 = new Node();
            this.nodes.add((Node)object3);
            ((Node)object3).heightParameter = new Parameter.Default(d3);
            ((Node)object3).number = n2++;
            ((Node)object3).bifurcation = false;
            object2 = new SimulateSticks((Node)object3, true);
            object = new SimulateSticks((Node)object3, false);
            ((Node)object3).leftChild = node = ((SimulateSticks)object4).mySon;
            ((Node)object3).rightChild = node;
            if (node.bifurcation) {
                node.leftParent = object3;
                node.rightParent = object3;
                arrayList2.remove(arrayList2.indexOf(node));
            } else {
                if (((SimulateSticks)object4).leftStick) {
                    node.leftParent = object3;
                } else {
                    node.rightParent = object3;
                }
                if (node.leftParent != null & node.rightParent != null) {
                    arrayList2.remove(arrayList2.indexOf(node));
                }
            }
            arrayList2.add(object3);
            arrayList.add(object2);
            arrayList.add(object);
        }
        this.root = (Node)arrayList2.get(0);
    }

    public int possibleInternalNodePermuations() {
        int n = this.getInternalNodeCount();
        ArrayList<Double> arrayList = new ArrayList<Double>(n - 1);
        for (Node node : this.nodes) {
            if (node.isExternal() || node.isRoot()) continue;
            arrayList.add(node.getHeight());
        }
        int n2 = 0;
        while (this.nodes.get(n2).isExternal() || this.nodes.get(n2).isRoot()) {
            ++n2;
        }
        int n3 = this.possibleInternalNodePermutations(n2, arrayList);
        int n4 = 0;
        for (Node node : this.nodes) {
            if (node.isExternal() || node.isRoot()) continue;
            node.setHeight(arrayList.get(n4++));
        }
        return this.factorial(n - 1) - n3;
    }

    private int factorial(int n) {
        int n2 = 1;
        for (int i = 2; i <= n; ++i) {
            n2 *= i;
        }
        return n2;
    }

    private int possibleInternalNodePermutations(int n, ArrayList<Double> arrayList) {
        int n2 = 0;
        if (arrayList.size() == 0) {
            return 0;
        }
        int n3 = n + 1;
        if (arrayList.size() > 1) {
            while (this.nodes.get(n3).isExternal() || this.nodes.get(n3).isRoot()) {
                ++n3;
            }
        }
        Node node = this.nodes.get(n);
        for (double d : arrayList) {
            if (d < this.getNodeHeight(this.getParent(node, 0)) && d < this.getNodeHeight(this.getParent(node, 1))) {
                this.setNodeHeight(node, d);
                ArrayList<Double> arrayList2 = this.deepCopy(arrayList);
                if (!arrayList2.contains(d)) {
                    System.err.println("where did i go?");
                }
                arrayList2.remove(d);
                n2 += this.possibleInternalNodePermutations(n3, arrayList2);
                continue;
            }
            n2 += this.factorial(arrayList.size() - 1);
        }
        return n2;
    }

    private ArrayList<Double> deepCopy(ArrayList<Double> arrayList) {
        ArrayList<Double> arrayList2 = new ArrayList<Double>();
        for (double d : arrayList) {
            arrayList2.add(d);
        }
        return arrayList2;
    }

    private static boolean containsLessThan(int[] nArray, int n) {
        for (int n2 : nArray) {
            if (n2 >= n) continue;
            return true;
        }
        return false;
    }

    public static void main(String[] stringArray) {
        ARGModel aRGModel = new ARGModel(8, 20.0, 0.5);
        System.out.println(aRGModel.toARGSummary());
        System.out.println(aRGModel.getReassortmentNodeCount());
        System.out.println(aRGModel.toExtendedNewick());
    }

    @Override
    public void sendState(int n) {
        this.sendStateNoParameters(n);
        int n2 = 0;
        for (Node object2 : this.nodes) {
            object2.number = n2++;
        }
        int n3 = this.nodes.size();
        MPIServices.sendInt(n3, n);
        int[] nArray = new int[n3 * 7];
        double[] dArray = new double[n3];
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        ArrayList<Parameter> arrayList = new ArrayList<Parameter>();
        for (Node node : this.nodes) {
            nArray[n4++] = node.number;
            nArray[n4++] = node.leftParent != null ? node.leftParent.number : -1;
            nArray[n4++] = node.rightParent != null ? node.rightParent.number : -1;
            nArray[n4++] = node.leftChild != null ? node.leftChild.number : -1;
            nArray[n4++] = node.rightChild != null ? node.rightChild.number : -1;
            if (node.partitioning != null) {
                nArray[n4++] = n6++;
                arrayList.add(node.partitioning);
            } else {
                nArray[n4++] = -1;
            }
            nArray[n4++] = node.bifurcation ? 1 : 0;
            dArray[n5++] = node.heightParameter.getParameterValue(0);
        }
        MPIServices.sendIntArray(nArray, n);
        MPIServices.sendDoubleArray(dArray, n);
        MPIServices.sendInt(arrayList.size(), n);
        for (Parameter parameter : arrayList) {
            double[] dArray2 = parameter.getParameterValues();
            MPIServices.sendDoubleArray(parameter.getParameterValues(), n);
        }
        MPIServices.sendInt(((Node)this.getRoot()).number, n);
    }

    @Override
    public void receiveState(int n) {
        int n2;
        Object object;
        int n3;
        this.receiveStateNoParameters(n);
        int n4 = MPIServices.receiveInt(n);
        int[] nArray = MPIServices.receiveIntArray(n, n4 * 7);
        double[] dArray = MPIServices.receiveDoubleArray(n, n4);
        int n5 = MPIServices.receiveInt(n);
        int n6 = this.getNumberOfPartitions();
        while (n5 > this.partitioningParameters.getParameterCount()) {
            Parameter.Default default_ = new Parameter.Default(n6);
            this.partitioningParameters.addParameter(default_);
        }
        for (n3 = 0; n3 < n5; ++n3) {
            object = MPIServices.receiveDoubleArray(n, n6);
            Parameter parameter = this.partitioningParameters.getParameter(n3);
            for (n2 = 0; n2 < n6; ++n2) {
                parameter.setParameterValueQuietly(n2, object[n2]);
            }
        }
        n3 = MPIServices.receiveInt(n);
        this.beginTreeEdit();
        while (n4 > this.nodes.size()) {
            object = new Node();
            object.heightParameter = new Parameter.Default(0.0);
            this.nodes.add((Node)object);
        }
        int n7 = 0;
        n2 = 0;
        boolean bl = false;
        for (int i = 0; i < n4; ++i) {
            int n8;
            Node node = this.nodes.get(i);
            node.number = nArray[n7++];
            node.leftParent = (n8 = nArray[n7++]) != -1 ? this.nodes.get(n8) : null;
            n8 = nArray[n7++];
            node.rightParent = n8 != -1 ? this.nodes.get(n8) : null;
            n8 = nArray[n7++];
            node.leftChild = n8 != -1 ? this.nodes.get(n8) : null;
            n8 = nArray[n7++];
            node.rightChild = n8 != -1 ? this.nodes.get(n8) : null;
            node.heightParameter.setParameterValueQuietly(0, dArray[n2++]);
            int n9 = nArray[n7++];
            if (n9 != -1) {
                node.partitioning = this.partitioningParameters.getParameter(n9);
            }
            node.bifurcation = nArray[n7++] == 1;
        }
        this.setRoot(this.nodes.get(n3));
        this.endTreeEditFast();
    }

    public boolean isAncestral() {
        int n;
        Node node;
        int n2;
        for (n2 = 0; n2 < this.getNodeCount(); ++n2) {
            node = (Node)this.getNode(n2);
            node.fullAncestralMaterial = false;
            node.hasSomeAncestralMaterial = false;
            if (node.ancestralMaterial == null) {
                node.ancestralMaterial = new boolean[this.getNumberOfPartitions()];
            }
            for (n = 0; n < node.ancestralMaterial.length; ++n) {
                node.ancestralMaterial[n] = false;
            }
        }
        for (n2 = 0; n2 < this.getExternalNodeCount(); ++n2) {
            node = (Node)this.getExternalNode(n2);
            node.fullAncestralMaterial = true;
            node.hasSomeAncestralMaterial = true;
            for (n = 0; n < node.ancestralMaterial.length; ++n) {
                node.ancestralMaterial[n] = true;
            }
            node.leftParent.setAncestralMaterial(node.ancestralMaterial);
        }
        int n3 = this.getNodeCount();
        for (n2 = 0; n2 < n3; ++n2) {
            Node node2 = (Node)this.getNode(n2);
            if (node2.hasSomeAncestralMaterial) continue;
            return false;
        }
        return true;
    }

    public CompoundParameter getPartitioningParameters() {
        return this.partitioningParameters;
    }

    public void setupHeightBounds() {
        for (Node node : this.nodes) {
            node.setupHeightBounds();
        }
    }

    private String getNameOfNode(Node node) {
        if (node.taxon == null) {
            return "n" + Integer.toString(node.number);
        }
        return node.taxon.getId();
    }

    private Element makeEdge(Node node, Node node2) {
        Element element = new Element(EDGE_ELEMENT);
        element.setAttribute(EDGE_FROM, this.getNameOfNode(node));
        element.setAttribute(EDGE_TO, this.getNameOfNode(node2));
        element.setAttribute(EDGE_LENGTH, Double.toString(this.getNodeHeight(node) - this.getNodeHeight(node2)));
        if (node2.isReassortment()) {
            double[] dArray = node2.partitioning.getParameterValues();
            int n = dArray.length;
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl = node == node2.leftParent;
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                if ((!bl || dArray[i] != 0.0) && (bl || dArray[i] != 1.0)) continue;
                stringBuilder.append(i);
                stringBuilder.append(" ");
                ++n2;
            }
            if (n2 < 10) {
                element.setAttribute(EDGE_PARTITIONS, stringBuilder.toString().trim());
            }
        }
        return element;
    }

    private Element makeNode(Node node) {
        Element element = new Element(NODE_ELEMENT);
        element.setAttribute(ID_ATTRIBUTE, this.getNameOfNode(node));
        if (node.taxon != null) {
            element.setAttribute(IS_TIP, IS_REASSORTMENT);
            element.setAttribute(TAXON_NAME, node.taxon.getId());
        }
        if (node.isRoot()) {
            element.setAttribute(IS_ROOT, IS_REASSORTMENT);
        }
        if (node.isReassortment()) {
            element.setAttribute(IS_REASSORTMENT, IS_REASSORTMENT);
        }
        element.setAttribute(NODE_HEIGHT, Double.toString(node.getHeight()));
        return element;
    }

    private Element makeNodeFullInfo(Node node) {
        Element element = new Element(NODE_ELEMENT);
        element.setAttribute(ID_ATTRIBUTE, this.getNameOfNode(node));
        if (node.isRoot()) {
            element.setAttribute(IS_ROOT, IS_REASSORTMENT);
        } else {
            element.setAttribute(LEFT_PARENT, this.getNameOfNode(node.leftParent));
            element.setAttribute(RIGHT_PARENT, this.getNameOfNode(node.rightParent));
        }
        if (node.taxon != null) {
            element.setAttribute(IS_TIP, IS_REASSORTMENT);
            element.setAttribute(TAXON_NAME, node.taxon.getId());
        } else {
            element.setAttribute(LEFT_CHILD, this.getNameOfNode(node.leftChild));
            element.setAttribute(RIGHT_CHILD, this.getNameOfNode(node.rightChild));
        }
        element.setAttribute(NODE_HEIGHT, Double.toString(node.getHeight()));
        return element;
    }

    public ARGModel fromXML(Element element) {
        Object object;
        String string;
        Serializable serializable;
        Object object22;
        int n = Integer.parseInt(element.getAttributeValue(NUM_PARTITIONS));
        int n2 = 0;
        List list = element.getChildren(NODE_ELEMENT);
        ArrayList<Node> arrayList = new ArrayList<Node>();
        Serializable serializable2 = null;
        for (Object object22 : list) {
            String string2;
            serializable = new Node();
            arrayList.add((Node)serializable);
            String string3 = ((Element)object22).getAttributeValue(IS_ROOT);
            if (string3 != null && string3.compareTo(IS_REASSORTMENT) == 0) {
                serializable2 = serializable;
            }
            ((Node)serializable).bifurcation = (string2 = ((Element)object22).getAttributeValue(IS_REASSORTMENT)) == null || string2.compareTo(IS_REASSORTMENT) != 0;
            double d = Double.parseDouble(((Element)object22).getAttributeValue(NODE_HEIGHT));
            ((Node)serializable).heightParameter = new Parameter.Default(d);
            ((Node)serializable).setHeight(d);
            string = ((Element)object22).getAttributeValue(IS_TIP);
            if (string == null || string.compareTo(IS_REASSORTMENT) != 0) continue;
            ++n2;
            object = ((Element)object22).getAttributeValue(TAXON_NAME);
            ((Node)serializable).taxon = new Taxon((String)object);
        }
        List list2 = element.getChildren(EDGE_ELEMENT);
        object22 = list2.iterator();
        while (object22.hasNext()) {
            serializable = (Element)object22.next();
            int n3 = Integer.parseInt(((Element)serializable).getAttributeValue(EDGE_TO));
            int n4 = Integer.parseInt(((Element)serializable).getAttributeValue(EDGE_FROM));
            Node node = arrayList.get(n3);
            Node node2 = arrayList.get(n4);
            if (node.isBifurcation()) {
                node.leftParent = node.rightParent = node2;
            } else if (node.leftParent == null) {
                node.leftParent = node2;
            } else {
                node.rightParent = node2;
                string = ((Element)serializable).getAttributeValue(EDGE_PARTITIONS);
                object = null;
                object = new Parameter.Default(n, 0.0);
                StringTokenizer stringTokenizer = new StringTokenizer(string);
                while (stringTokenizer.hasMoreTokens()) {
                    int n5 = Integer.parseInt(stringTokenizer.nextToken());
                    object.setParameterValueQuietly(n5, 1.0);
                }
                node.partitioning = object;
            }
            if (node2.leftChild == null) {
                node2.leftChild = node;
                continue;
            }
            node2.rightChild = node;
        }
        return new ARGModel(arrayList, (Node)serializable2, n, n2);
    }

    public Element toXML() {
        int n = 0;
        for (Node object : this.nodes) {
            object.number = n++;
        }
        Element element = new Element(GRAPH_ELEMENT);
        element.setAttribute("edgedefault", "directed");
        element.setAttribute(NUM_PARTITIONS, Integer.toString(this.getNumberOfPartitions()));
        for (Node node : this.nodes) {
            element.addContent(this.makeNode(node));
            if (node.leftParent != null) {
                element.addContent(this.makeEdge(node.leftParent, node));
            }
            if (node.rightParent == null || !node.isReassortment()) continue;
            element.addContent(this.makeEdge(node.rightParent, node));
        }
        return element;
    }

    public String toStrippedNewick() {
        String string = this.root.toExtendedNewick() + ";";
        string = string.replaceAll("[^(),<>;]", "");
        return string;
    }

    public String toExtendedNewick() {
        return this.root.toExtendedNewick() + ";";
    }

    public void pushTreeChangedEvent() {
        this.pushTreeChangedEvent(new ARGTreeChangedEvent());
    }

    public void pushTreeSizeChangedEvent() {
        throw new RuntimeException("No longer supported; use updated operators");
    }

    public void pushTreeSizeIncreasedEvent() {
        this.pushTreeChangedEvent(new ARGTreeChangedEvent(1));
    }

    public void pushTreeSizeDecreasedEvent() {
        this.pushTreeChangedEvent(new ARGTreeChangedEvent(-1));
    }

    public void pushTreeChangedEvent(NodeRef nodeRef) {
        this.pushTreeChangedEvent(new ARGTreeChangedEvent((Node)nodeRef));
    }

    public void pushTreeChangedEvent(Node node, Parameter parameter, int n) {
        this.pushTreeChangedEvent(new ARGTreeChangedEvent(node, parameter, n));
    }

    public void pushTreeChangedEvent(TreeChangedEvent treeChangedEvent) {
        if (this.inEdit) {
            this.treeChangedEvents.add(treeChangedEvent);
        } else {
            this.listenerHelper.fireModelChanged(this, treeChangedEvent);
        }
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
    }

    @Override
    public void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        Node node = this.getNodeOfParameter((Parameter)variable);
        this.pushTreeChangedEvent(node, (Parameter)variable, n);
    }

    public int getNumberOfPartitions() {
        return this.maxNumberOfPartitions;
    }

    public int addLikelihoodCalculator(ARGLikelihood aRGLikelihood) {
        if (this.likelihoodCalculators == null) {
            this.likelihoodCalculators = new ArrayList();
        }
        this.likelihoodCalculators.add(aRGLikelihood);
        int n = this.likelihoodCalculators.size() - 1;
        this.maxNumberOfPartitions = this.likelihoodCalculators.size();
        System.err.println("Add calculator for partition #" + n);
        this.setPartitionRecursively(this.getRoot(), n);
        return n;
    }

    public int getMaxPartitionNumber() {
        return this.maxNumberOfPartitions;
    }

    @Override
    public LogColumn[] getColumns() {
        int n = 3;
        LogColumn[] logColumnArray = new LogColumn[]{new CountReassortmentColumn("numberReassortments"), new ExtremeNodeHeightColumn("maxNodeHeight"){

            @Override
            double getStartValue() {
                return 0.0;
            }

            @Override
            double compare(double d, double d2) {
                if (d2 > d) {
                    return d2;
                }
                return d;
            }
        }, new ExtremeNodeHeightColumn("minNodeHeight"){

            @Override
            double getStartValue() {
                return 0.0;
            }

            @Override
            double compare(double d, double d2) {
                if (d2 == 0.0) {
                    return d;
                }
                if (d == 0.0) {
                    return d2;
                }
                if (d2 < d) {
                    return d2;
                }
                return d;
            }
        }};
        return logColumnArray;
    }

    public void setPartitionType(String string) {
        this.partitionType = string;
    }

    public String getPartitionType() {
        return this.partitionType;
    }

    public boolean isRecombinationPartitionType() {
        return this.partitionType.equals(RECOMBINATION_PARTITION);
    }

    @Override
    public final Units.Type getUnits() {
        return this.units;
    }

    @Override
    public void setUnits(Units.Type type) {
        this.units = type;
    }

    @Override
    public final int getNodeCount() {
        return this.nodes.size();
    }

    @Override
    public final boolean hasNodeHeights() {
        return true;
    }

    public NodeRef getMirrorNode(NodeRef nodeRef) {
        return ((Node)nodeRef).mirrorNode;
    }

    @Override
    public final double getNodeHeight(NodeRef nodeRef) {
        return ((Node)nodeRef).getHeight();
    }

    public final double getMinParentNodeHeight(NodeRef nodeRef) {
        Node node = (Node)nodeRef;
        return Math.min(node.leftParent.getHeight(), node.rightParent.getHeight());
    }

    public final double getNodeHeightUpper(NodeRef nodeRef) {
        return ((Node)nodeRef).heightParameter.getBounds().getUpperLimit(0);
    }

    public final double getNodeHeightLower(NodeRef nodeRef) {
        return ((Node)nodeRef).heightParameter.getBounds().getLowerLimit(0);
    }

    public final double getNodeRate(NodeRef nodeRef, int n) {
        if (!this.hasRates) {
            return 1.0;
        }
        return 0.0;
    }

    @Override
    public Object getNodeAttribute(NodeRef nodeRef, String string) {
        throw new UnsupportedOperationException("ARGModel does not use NodeAttributes");
    }

    @Override
    public Iterator getNodeAttributeNames(NodeRef nodeRef) {
        throw new UnsupportedOperationException("ARGModel does not use NodeAttributes");
    }

    public double getNodeTrait(NodeRef nodeRef) {
        if (!this.hasTraits) {
            throw new IllegalArgumentException("Trait parameters have not been created");
        }
        return ((Node)nodeRef).getTrait();
    }

    @Override
    public final Taxon getNodeTaxon(NodeRef nodeRef) {
        return ((Node)nodeRef).taxon;
    }

    @Override
    public final boolean isExternal(NodeRef nodeRef) {
        return ((Node)nodeRef).isExternal();
    }

    public final boolean isInternal(NodeRef nodeRef) {
        return !this.isExternal(nodeRef);
    }

    @Override
    public final boolean isRoot(NodeRef nodeRef) {
        return nodeRef == this.root;
    }

    public final boolean isBifurcation(NodeRef nodeRef) {
        return ((Node)nodeRef).isBifurcation();
    }

    public final boolean isBifurcationDoublyLinked(NodeRef nodeRef) {
        return ((Node)nodeRef).isBifurcationDoublyLinked();
    }

    public final boolean isReassortment(NodeRef nodeRef) {
        return ((Node)nodeRef).isReassortment();
    }

    public final int countReassortmentNodes(NodeRef nodeRef) {
        Node node = (Node)nodeRef;
        int n = node.countReassortmentChild(this);
        return n / 2;
    }

    @Override
    public final int getChildCount(NodeRef nodeRef) {
        return ((Node)nodeRef).getChildCount();
    }

    public final NodeRef getOtherChild(NodeRef nodeRef, NodeRef nodeRef2) {
        Node node = (Node)nodeRef;
        Node node2 = (Node)nodeRef2;
        if (node.leftChild == node2) {
            return node.rightChild;
        }
        return node.leftChild;
    }

    public final NodeRef getBrother(NodeRef nodeRef) {
        Node node = (Node)nodeRef;
        if (node.isReassortment()) {
            return nodeRef;
        }
        Node node2 = node.leftParent;
        if (node2.leftChild == node) {
            return node2.rightChild;
        }
        return node2.leftChild;
    }

    @Override
    public final NodeRef getChild(NodeRef nodeRef, int n) {
        return ((Node)nodeRef).getChild(n);
    }

    public final NodeRef getChild(NodeRef nodeRef, int n, int n2) {
        return ((Node)nodeRef).getChild(n, n2);
    }

    @Override
    public final NodeRef getParent(NodeRef nodeRef) {
        Node node = ((Node)nodeRef).leftParent;
        Node node2 = ((Node)nodeRef).rightParent;
        if (node == node2) {
            return node;
        }
        throw new IllegalArgumentException("No single parent for reassorted node");
    }

    public final NodeRef getParent(NodeRef nodeRef, int n) {
        if (n == 0) {
            return ((Node)nodeRef).leftParent;
        }
        if (n == 1) {
            return ((Node)nodeRef).rightParent;
        }
        throw new IllegalArgumentException("ARGModel.Node can only have two parents");
    }

    @Override
    public final boolean hasBranchLengths() {
        return true;
    }

    @Override
    public final double getBranchLength(NodeRef nodeRef) {
        NodeRef nodeRef2 = this.getParent(nodeRef);
        if (nodeRef2 == null) {
            return 0.0;
        }
        return this.getNodeHeight(nodeRef2) - this.getNodeHeight(nodeRef);
    }

    @Override
    public final NodeRef getExternalNode(int n) {
        return this.nodes.get(n);
    }

    @Override
    public final NodeRef getInternalNode(int n) {
        return this.nodes.get(n + this.externalNodeCount);
    }

    @Override
    public final NodeRef getNode(int n) {
        return this.nodes.get(n);
    }

    @Override
    public final int getExternalNodeCount() {
        return this.externalNodeCount;
    }

    @Override
    public final int getInternalNodeCount() {
        return this.internalNodeCount;
    }

    public final int getReassortmentNodeCount() {
        int n = 0;
        for (Node node : this.nodes) {
            if (node.bifurcation) continue;
            ++n;
        }
        return n;
    }

    public void addNullCounter() {
        ++this.nullCounter;
    }

    public void removeNullCounter() {
        --this.nullCounter;
    }

    @Override
    public final NodeRef getRoot() {
        return this.root;
    }

    public final NodeRef getRoot(int n) {
        return null;
    }

    @Override
    public final void setRoot(NodeRef nodeRef) {
        if (!this.inEdit) {
            throw new RuntimeException("Must be in edit transaction to call this method!");
        }
        this.root = (Node)nodeRef;
    }

    public void swapHeightParameters(NodeRef nodeRef, NodeRef nodeRef2) {
        Node node = (Node)nodeRef;
        Node node2 = (Node)nodeRef2;
        double d = node.getHeight();
        double d2 = node2.getHeight();
        Parameter parameter = node.heightParameter;
        node.heightParameter = node2.heightParameter;
        node2.heightParameter = parameter;
        node.setHeight(d);
        node2.setHeight(d2);
    }

    @Override
    public void addChild(NodeRef nodeRef, NodeRef nodeRef2) {
        this.checkEditMode();
        Node node = (Node)nodeRef;
        Node node2 = (Node)nodeRef2;
        if (node.bifurcation) {
            node.singleAddChild(node2);
        } else {
            node.doubleAddChild(node2);
        }
    }

    public void addChildWithSingleParent(NodeRef nodeRef, NodeRef nodeRef2) {
        this.checkEditMode();
        Node node = (Node)nodeRef;
        Node node2 = (Node)nodeRef2;
        if (node.bifurcation) {
            node.singleAddChildWithOneParent(node2);
        } else {
            node.doubleAddChildWithOneParent(node2);
        }
    }

    public void singleAddChild(NodeRef nodeRef, NodeRef nodeRef2) {
        if (!this.inEdit) {
            throw new RuntimeException("must be in edit transaction to call this method!");
        }
        Node node = (Node)nodeRef;
        Node node2 = (Node)nodeRef2;
        node.singleAddChild(node2);
    }

    public void singleAddChildWithOneParent(NodeRef nodeRef, NodeRef nodeRef2) {
        if (!this.inEdit) {
            throw new RuntimeException("Must be in edit transaction to call this method!");
        }
        Node node = (Node)nodeRef;
        Node node2 = (Node)nodeRef2;
        node.singleAddChildWithOneParent(node2);
    }

    public void doubleAddChild(NodeRef nodeRef, NodeRef nodeRef2) {
        if (!this.inEdit) {
            throw new RuntimeException("Must be in edit transaction to call this method!");
        }
        Node node = (Node)nodeRef;
        Node node2 = (Node)nodeRef2;
        node.doubleAddChild(node2);
    }

    public void doubleAddChildWithOneParent(NodeRef nodeRef, NodeRef nodeRef2) {
        if (!this.inEdit) {
            throw new RuntimeException("Must be in edit transaction to call this method!");
        }
        Node node = (Node)nodeRef;
        Node node2 = (Node)nodeRef2;
        node.doubleAddChildWithOneParent(node2);
    }

    public void addChildAsRecombinant(NodeRef nodeRef, NodeRef nodeRef2, NodeRef nodeRef3, Parameter parameter) {
        if (!this.inEdit) {
            throw new RuntimeException("Must be in edit transaction to call this method!");
        }
        Node node = (Node)nodeRef;
        Node node2 = (Node)nodeRef2;
        Node node3 = (Node)nodeRef3;
        node.addChildRecombinant(node3, parameter);
        node2.addChildRecombinant(node3, parameter);
    }

    @Override
    public void removeChild(NodeRef nodeRef, NodeRef nodeRef2) {
        this.checkEditMode();
        Node node = (Node)nodeRef;
        Node node2 = (Node)nodeRef2;
        node.doubleRemoveChild(node2);
    }

    @Override
    public void replaceChild(NodeRef nodeRef, NodeRef nodeRef2, NodeRef nodeRef3) {
    }

    public void doubleRemoveChild(NodeRef nodeRef, NodeRef nodeRef2) {
        this.checkEditMode();
        Node node = (Node)nodeRef;
        Node node2 = (Node)nodeRef2;
        node.doubleRemoveChild(node2);
    }

    public void singleRemoveChild(NodeRef nodeRef, NodeRef nodeRef2) {
        this.checkEditMode();
        Node node = (Node)nodeRef;
        Node node2 = (Node)nodeRef2;
        node.singleRemoveChild(node2);
    }

    @Override
    public boolean beginTreeEdit() {
        if (this.inEdit) {
            throw new RuntimeException("Alreading in edit transaction mode!");
        }
        this.oldRoot = this.root;
        this.inEdit = true;
        return false;
    }

    @Override
    public void endTreeEdit() {
        if (!this.inEdit) {
            throw new RuntimeException("Not in edit transaction mode!");
        }
        this.inEdit = false;
        if (this.root != this.oldRoot) {
            this.swapParameterObjects(this.oldRoot, this.root);
        }
        for (TreeChangedEvent treeChangedEvent : this.treeChangedEvents) {
            this.listenerHelper.fireModelChanged(this, treeChangedEvent);
        }
        this.treeChangedEvents.clear();
    }

    public void checkTreeIsValid() throws MutableTree.InvalidTreeException {
        for (Node node : this.nodes) {
            if (node.heightParameter.isWithinBounds()) continue;
            throw new MutableTree.InvalidTreeException("height parameter out of bounds");
        }
    }

    private void endTreeEditFast() {
        this.inEdit = false;
    }

    @Override
    public void setNodeHeight(NodeRef nodeRef, double d) {
        ((Node)nodeRef).setHeight(d);
    }

    @Override
    public void setNodeRate(NodeRef nodeRef, double d) {
        if (!this.hasRates) {
            throw new IllegalArgumentException("Rate parameters have not been created");
        }
        ((Node)nodeRef).setRate(d);
    }

    public void setNodeTrait(NodeRef nodeRef, double d) {
        if (!this.hasTraits) {
            throw new IllegalArgumentException("Trait parameters have not been created");
        }
        ((Node)nodeRef).setTrait(d);
    }

    public void setNodeNumber(NodeRef nodeRef, int n) {
        nodeRef.setNumber(n);
    }

    @Override
    public void setBranchLength(NodeRef nodeRef, double d) {
        throw new UnsupportedOperationException("ARGModel cannot have branch lengths set");
    }

    @Override
    public void setNodeAttribute(NodeRef nodeRef, String string, Object object) {
        throw new UnsupportedOperationException("ARGModel does not use NodeAttributes");
    }

    @Override
    protected void storeState() {
        this.copyNodeStructure(this.storedNodes);
        this.storedRootNumber = this.nodes.indexOf(this.root);
        this.storedNodeCount = this.nodeCount;
        this.storedInternalNodeCount = this.internalNodeCount;
        this.addedParameters = null;
        this.addedPartitioningParameter = null;
        this.addedNodes = null;
        this.removedParameters = null;
        this.removedPartitioningParameter = null;
        this.removedNodes = null;
        this.storedNullCounter = this.nullCounter;
    }

    @Override
    protected void restoreState() {
        ArrayList<Node> arrayList = this.storedNodes;
        this.storedNodes = this.nodes;
        this.nodes = arrayList;
        this.root = this.nodes.get(this.storedRootNumber);
        this.nodeCount = this.storedNodeCount;
        this.internalNodeCount = this.storedInternalNodeCount;
        if (this.addedParameters != null) {
            if (this.addedParameters.length == 5) {
                this.removeVariable(this.addedParameters[0]);
                this.removeVariable(this.addedParameters[1]);
                this.removeVariable(this.addedParameters[2]);
                this.removeVariable(this.addedParameters[3]);
                this.storedInternalNodeHeights.removeParameter(this.addedParameters[0]);
                this.storedInternalNodeHeights.removeParameter(this.addedParameters[4]);
                this.storedInternalAndRootNodeHeights.removeParameter(this.addedParameters[0]);
                this.storedInternalAndRootNodeHeights.removeParameter(this.addedParameters[1]);
                this.storedNodeRates.removeParameter(this.addedParameters[2]);
            } else {
                this.storedInternalNodeHeights.removeParameter(this.addedParameters[0]);
                this.storedInternalNodeHeights.removeParameter(this.addedParameters[1]);
                this.removeVariable(this.addedParameters[0]);
                this.removeVariable(this.addedParameters[1]);
                this.storedInternalAndRootNodeHeights.removeParameter(this.addedParameters[0]);
                this.storedInternalAndRootNodeHeights.removeParameter(this.addedParameters[1]);
                this.removeVariable(this.addedParameters[2]);
                this.removeVariable(this.addedParameters[3]);
                this.storedNodeRates.removeParameter(this.addedParameters[2]);
            }
        }
        if (this.addedPartitioningParameter != null) {
            this.partitioningParameters.removeParameter(this.addedPartitioningParameter);
            this.removeVariable(this.addedPartitioningParameter);
        }
        if (this.removedParameters != null) {
            this.storedInternalNodeHeights.addParameter(this.removedParameters[0]);
            this.storedInternalNodeHeights.addParameter(this.removedParameters[1]);
            this.addVariable(this.removedParameters[0]);
            this.addVariable(this.removedParameters[1]);
            this.storedInternalAndRootNodeHeights.addParameter(this.removedParameters[0]);
            this.storedInternalAndRootNodeHeights.addParameter(this.removedParameters[1]);
            this.addVariable(this.removedParameters[2]);
            this.addVariable(this.removedParameters[3]);
            this.storedNodeRates.addParameter(this.removedParameters[2]);
        }
        if (this.removedPartitioningParameter != null) {
            this.partitioningParameters.addParameter(this.removedPartitioningParameter);
            this.addVariable(this.removedPartitioningParameter);
        }
        this.nullCounter = this.storedNullCounter;
    }

    @Override
    protected void acceptState() {
    }

    protected void adoptState(Model model) {
    }

    public void expandARG(Node node, Node node2, CompoundParameter compoundParameter, CompoundParameter compoundParameter2, CompoundParameter compoundParameter3) {
        this.addVariable(node.heightParameter);
        this.addVariable(node2.heightParameter);
        this.addVariable(node2.partitioning);
        this.addVariable(node.rateParameter);
        this.addVariable(node2.rateParameter);
        this.addedParameters = new Parameter[4];
        this.addedParameters[0] = node.heightParameter;
        this.addedParameters[1] = node2.heightParameter;
        this.addedParameters[2] = node.rateParameter;
        this.addedParameters[3] = node2.rateParameter;
        this.addedPartitioningParameter = node2.partitioning;
        this.storedInternalNodeHeights = compoundParameter;
        this.storedInternalNodeHeights.addParameter(node.heightParameter);
        this.storedInternalNodeHeights.addParameter(node2.heightParameter);
        this.storedInternalAndRootNodeHeights = compoundParameter2;
        this.storedInternalAndRootNodeHeights.addParameter(node.heightParameter);
        this.storedInternalAndRootNodeHeights.addParameter(node2.heightParameter);
        this.storedNodeRates = compoundParameter3;
        this.storedNodeRates.addParameter(node.rateParameter);
        this.partitioningParameters.addParameter(node2.partitioning);
        this.nodes.add(node);
        this.nodes.add(node2);
        this.internalNodeCount += 2;
    }

    public void expandARGWithRecombinant(Node node, Node node2, CompoundParameter compoundParameter, CompoundParameter compoundParameter2, CompoundParameter compoundParameter3) {
        this.addVariable(node.heightParameter);
        this.addVariable(node2.heightParameter);
        this.addVariable(node2.partitioning);
        this.addVariable(node.rateParameter);
        this.addVariable(node2.rateParameter);
        this.addedParameters = new Parameter[4];
        this.addedParameters[0] = node.heightParameter;
        this.addedParameters[1] = node2.heightParameter;
        this.addedParameters[2] = node.rateParameter;
        this.addedParameters[3] = node2.rateParameter;
        this.addedPartitioningParameter = node2.partitioning;
        this.storedInternalNodeHeights = compoundParameter;
        this.storedInternalNodeHeights.addParameter(node.heightParameter);
        this.storedInternalNodeHeights.addParameter(node2.heightParameter);
        this.storedInternalAndRootNodeHeights = compoundParameter2;
        this.storedInternalAndRootNodeHeights.addParameter(node.heightParameter);
        this.storedInternalAndRootNodeHeights.addParameter(node2.heightParameter);
        this.storedNodeRates = compoundParameter3;
        this.storedNodeRates.addParameter(node.rateParameter);
        this.storedNodeRates.addParameter(node2.rateParameter);
        this.partitioningParameters.addParameter(node2.partitioning);
        this.nodes.add(node);
        this.nodes.add(node2);
        this.internalNodeCount += 2;
    }

    public void sanityNodeCheck(CompoundParameter compoundParameter) {
        int n = compoundParameter.getParameterCount();
        for (int i = 0; i < n; ++i) {
            Parameter parameter = compoundParameter.getParameter(i);
            for (int j = 0; j < this.internalNodeCount; ++j) {
                Node node = (Node)this.getInternalNode(j);
                if (node.heightParameter != parameter || !this.isRoot(node)) continue;
                System.err.println("Root height found in internal nodes");
                System.exit(-1);
            }
        }
    }

    public void contractARGWithRecombinantNewRoot(Node node, Node node2, Node node3, CompoundParameter compoundParameter, CompoundParameter compoundParameter2, CompoundParameter compoundParameter3) {
        this.removeVariable(node.heightParameter);
        this.removeVariable(node2.heightParameter);
        this.removeVariable(node.partitioning);
        this.removeVariable(node.rateParameter);
        this.removeVariable(node.rateParameter);
        this.removedParameters = new Parameter[4];
        this.removedParameters[0] = node.heightParameter;
        this.removedParameters[1] = node2.heightParameter;
        this.removedParameters[2] = node.rateParameter;
        this.removedParameters[3] = node2.rateParameter;
        this.partitioningParameters.removeParameter(node.partitioning);
        this.removedPartitioningParameter = node.partitioning;
        this.storedInternalNodeHeights = compoundParameter;
        this.storedInternalNodeHeights.removeParameter(node.heightParameter);
        this.storedInternalAndRootNodeHeights = compoundParameter2;
        this.storedInternalAndRootNodeHeights.removeParameter(node.heightParameter);
        this.storedInternalAndRootNodeHeights.removeParameter(node2.heightParameter);
        this.storedNodeRates = compoundParameter3;
        this.storedNodeRates.removeParameter(node.rateParameter);
        this.storedNodeRates.removeParameter(node2.rateParameter);
        this.nodes.remove(node);
        this.nodes.remove(node2);
        this.internalNodeCount -= 2;
        this.setRoot(node3);
    }

    public void contractARG(Node node, Node node2, CompoundParameter compoundParameter, CompoundParameter compoundParameter2, CompoundParameter compoundParameter3) {
        this.removeVariable(node.heightParameter);
        this.removeVariable(node2.heightParameter);
        this.removeVariable(node2.partitioning);
        this.removeVariable(node.rateParameter);
        this.removeVariable(node2.rateParameter);
        this.removedParameters = new Parameter[4];
        this.removedParameters[0] = node.heightParameter;
        this.removedParameters[1] = node2.heightParameter;
        this.removedParameters[2] = node.rateParameter;
        this.removedParameters[3] = node2.rateParameter;
        this.partitioningParameters.removeParameter(node2.partitioning);
        this.removedPartitioningParameter = node2.partitioning;
        this.storedInternalNodeHeights = compoundParameter;
        this.storedInternalNodeHeights.removeParameter(node.heightParameter);
        this.storedInternalNodeHeights.removeParameter(node2.heightParameter);
        this.storedInternalAndRootNodeHeights = compoundParameter2;
        this.storedInternalAndRootNodeHeights.removeParameter(node.heightParameter);
        this.storedInternalAndRootNodeHeights.removeParameter(node2.heightParameter);
        this.storedNodeRates = compoundParameter3;
        this.storedNodeRates.removeParameter(node.rateParameter);
        this.nodes.remove(node);
        this.nodes.remove(node2);
        this.internalNodeCount -= 2;
    }

    public void contractARGWithRecombinant(Node node, Node node2, CompoundParameter compoundParameter, CompoundParameter compoundParameter2, CompoundParameter compoundParameter3) {
        this.removeVariable(node.heightParameter);
        this.removeVariable(node2.heightParameter);
        this.removeVariable(node2.partitioning);
        this.removeVariable(node.rateParameter);
        this.removeVariable(node2.rateParameter);
        this.removedParameters = new Parameter[4];
        this.removedParameters[0] = node.heightParameter;
        this.removedParameters[1] = node2.heightParameter;
        this.removedParameters[2] = node.rateParameter;
        this.removedParameters[3] = node2.rateParameter;
        this.partitioningParameters.removeParameter(node2.partitioning);
        this.removedPartitioningParameter = node2.partitioning;
        this.storedInternalNodeHeights = compoundParameter;
        this.storedInternalNodeHeights.removeParameter(node.heightParameter);
        this.storedInternalNodeHeights.removeParameter(node2.heightParameter);
        this.storedInternalAndRootNodeHeights = compoundParameter2;
        this.storedInternalAndRootNodeHeights.removeParameter(node.heightParameter);
        this.storedInternalAndRootNodeHeights.removeParameter(node2.heightParameter);
        this.storedNodeRates = compoundParameter3;
        this.storedNodeRates.removeParameter(node.rateParameter);
        this.storedNodeRates.removeParameter(node2.rateParameter);
        this.nodes.remove(node);
        this.nodes.remove(node2);
        this.internalNodeCount -= 2;
    }

    public boolean argStoreCheck() {
        return this.storedInternalNodeHeights.getDimension() == this.internalNodeCount;
    }

    void copyNodeStructure(ArrayList<Node> arrayList) {
        while (arrayList.size() < this.nodes.size()) {
            arrayList.add(new Node());
        }
        while (arrayList.size() > this.nodes.size()) {
            arrayList.remove(0);
        }
        int n = this.nodes.size();
        for (int i = 0; i < n; ++i) {
            Node node = this.nodes.get(i);
            Node node2 = arrayList.get(i);
            node2.heightParameter = node.heightParameter;
            node2.rateParameter = node.rateParameter;
            node2.traitParameter = node.traitParameter;
            node2.partitioning = node.partitioning;
            node2.taxon = node.taxon;
            node2.bifurcation = node.bifurcation;
            node2.number = node.number;
            node2.myHashCode = node.myHashCode;
            node2.leftParent = node.leftParent != null ? this.storedNodes.get(this.nodes.indexOf(node.leftParent)) : null;
            node2.rightParent = node.rightParent != null ? this.storedNodes.get(this.nodes.indexOf(node.rightParent)) : null;
            node2.leftChild = node.leftChild != null ? this.storedNodes.get(this.nodes.indexOf(node.leftChild)) : null;
            node2.rightChild = node.rightChild != null ? this.storedNodes.get(this.nodes.indexOf(node.rightChild)) : null;
        }
    }

    public void setPartitionRecursively(NodeRef nodeRef, int n) {
        Node node = (Node)nodeRef;
        node.setPartitionRecursively(n);
    }

    @Override
    public int getStatisticCount() {
        return 1;
    }

    @Override
    public Statistic getStatistic(int n) {
        if (n == 0) {
            return this.root.heightParameter;
        }
        throw new IllegalArgumentException();
    }

    public String getModelComponentName() {
        return TREE_MODEL;
    }

    @Override
    public int getTaxonCount() {
        return this.getExternalNodeCount();
    }

    @Override
    public Taxon getTaxon(int n) {
        return ((Node)this.getExternalNode((int)n)).taxon;
    }

    @Override
    public String getTaxonId(int n) {
        Taxon taxon = this.getTaxon(n);
        if (taxon != null) {
            return taxon.getId();
        }
        return null;
    }

    @Override
    public int getTaxonIndex(String string) {
        int n = this.getTaxonCount();
        for (int i = 0; i < n; ++i) {
            if (!this.getTaxonId(i).equals(string)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int getTaxonIndex(Taxon taxon) {
        int n = this.getTaxonCount();
        for (int i = 0; i < n; ++i) {
            if (this.getTaxon(i) != taxon) continue;
            return i;
        }
        return -1;
    }

    @Override
    public List<Taxon> asList() {
        ArrayList<Taxon> arrayList = new ArrayList<Taxon>();
        int n = this.getTaxonCount();
        for (int i = 0; i < n; ++i) {
            arrayList.add(this.getTaxon(i));
        }
        return arrayList;
    }

    @Override
    public Iterator<Taxon> iterator() {
        return new Iterator<Taxon>(){
            private int index = -1;

            @Override
            public boolean hasNext() {
                return this.index < ARGModel.this.getTaxonCount() - 1;
            }

            @Override
            public Taxon next() {
                ++this.index;
                return ARGModel.this.getTaxon(this.index);
            }

            @Override
            public void remove() {
            }
        };
    }

    @Override
    public final Object getTaxonAttribute(int n, String string) {
        Taxon taxon = this.getTaxon(n);
        if (taxon != null) {
            return taxon.getAttribute(string);
        }
        return null;
    }

    @Override
    public int addTaxon(Taxon taxon) {
        throw new IllegalArgumentException("Cannot add taxon to a ARGModel");
    }

    @Override
    public boolean removeTaxon(Taxon taxon) {
        throw new IllegalArgumentException("Cannot add taxon to a ARGModel");
    }

    @Override
    public void setTaxonId(int n, String string) {
        throw new IllegalArgumentException("Cannot set taxon id in a ARGModel");
    }

    @Override
    public void setTaxonAttribute(int n, String string, Object object) {
        throw new IllegalArgumentException("Cannot set taxon attribute in a ARGModel");
    }

    @Override
    public void addMutableTreeListener(MutableTreeListener mutableTreeListener) {
    }

    @Override
    public void addMutableTaxonListListener(MutableTaxonListListener mutableTaxonListListener) {
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String string) {
        this.id = string;
    }

    @Override
    public void setAttribute(String string, Object object) {
        if (this.treeAttributes == null) {
            this.treeAttributes = new Attributable.AttributeHelper();
        }
        this.treeAttributes.setAttribute(string, object);
    }

    @Override
    public Object getAttribute(String string) {
        if (this.treeAttributes == null) {
            return null;
        }
        return this.treeAttributes.getAttribute(string);
    }

    @Override
    public Iterator<String> getAttributeNames() {
        if (this.treeAttributes == null) {
            return null;
        }
        return this.treeAttributes.getAttributeNames();
    }

    public final String getNewick(int n) {
        return TreeUtils.newick(new ARGTree(this, n));
    }

    private void checkEditMode() throws RuntimeException {
        if (!this.inEdit) {
            throw new RuntimeException("Not in edit transaction mode!");
        }
    }

    public void checkBranchSanity() {
        boolean bl = false;
        for (Node node : this.nodes) {
            if (node.isRoot()) continue;
            double d = 0.0;
            double d2 = 0.0;
            if (node.leftParent != null) {
                d = this.getNodeHeight(node.leftParent) - this.getNodeHeight(node);
            }
            if (node.rightParent != null) {
                d2 = this.getNodeHeight(node.rightParent) - this.getNodeHeight(node);
            }
            if (!String.valueOf(d).equals("NaN") && !String.valueOf(d2).equals("NaN")) continue;
            if (!bl) {
                System.err.println(this.toGraphString());
                bl = true;
            }
            System.err.println("Caught the NaN: node=" + node.number + " (" + node.getHeight() + ") lp=" + node.leftParent.number + " (" + node.leftParent.getHeight() + ") rp=" + node.rightParent.number + " (" + node.rightParent.getHeight() + ")");
            System.exit(-1);
        }
    }

    @Override
    public String toString() {
        return this.toExtendedNewick();
    }

    public void appendGraphStringOld(StringBuffer stringBuffer) {
        int n = 0;
        for (Node node : this.nodes) {
            node.number = n++;
        }
        n = 0;
        for (Node node : this.nodes) {
            stringBuffer.append(n == 0 ? "[" : ",[");
            ++n;
            stringBuffer.append(node.number + ":");
            if (node.leftParent == null) {
                stringBuffer.append(nullEdge);
            } else {
                stringBuffer.append(" " + node.leftParent.number);
            }
            if (node.rightParent == null) {
                stringBuffer.append(nullEdge);
            } else {
                stringBuffer.append(" " + node.rightParent.number);
            }
            if (node.leftChild == null) {
                stringBuffer.append(nullEdge);
            } else {
                stringBuffer.append(" " + node.leftChild.number);
            }
            if (node.rightChild == null) {
                stringBuffer.append(nullEdge);
            } else {
                stringBuffer.append(" " + node.rightChild.number);
            }
            if (node.taxon != null) {
                stringBuffer.append(" " + node.taxon.toString());
            }
            stringBuffer.append("]");
        }
    }

    public boolean validRoot() {
        boolean bl = true;
        for (int i = 0; bl && i < this.maxNumberOfPartitions; ++i) {
            ARGTree aRGTree = new ARGTree(this, i);
            if (!aRGTree.wasRootTrimmed()) continue;
            bl = false;
        }
        return bl;
    }

    public String toGraphString() {
        int n = 1;
        for (Node object : this.nodes) {
            object.number = n++;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Total length: " + this.nodes.size() + "\n");
        for (Node node : this.nodes) {
            stringBuffer.append(node.number + ":");
            if (node.leftParent == null) {
                stringBuffer.append(" 0");
            } else {
                stringBuffer.append(" " + node.leftParent.number);
            }
            if (node.rightParent == null) {
                stringBuffer.append(" 0");
            } else {
                stringBuffer.append(" " + node.rightParent.number);
            }
            if (node.leftChild == null) {
                stringBuffer.append(" 0");
            } else {
                stringBuffer.append(" " + node.leftChild.number);
            }
            if (node.rightChild == null) {
                stringBuffer.append(" 0");
            } else {
                stringBuffer.append(" " + node.rightChild.number);
            }
            if (node.taxon != null) {
                stringBuffer.append(" " + node.taxon.toString());
            }
            if (node.partitioning != null) {
                stringBuffer.append(" p");
            }
            stringBuffer.append("\t" + this.getNodeHeight(node));
            stringBuffer.append("\n");
        }
        stringBuffer.append("Root = " + ((Node)this.getRoot()).number + "\n");
        return new String(stringBuffer);
    }

    public ARGModel fromGraphStringCompressed(String string) {
        Object object;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        int n = Integer.parseInt(stringTokenizer.nextToken());
        int n2 = Integer.parseInt(stringTokenizer.nextToken());
        int n3 = Integer.parseInt(stringTokenizer.nextToken());
        int n4 = 0;
        ArrayList<Node> arrayList = new ArrayList<Node>();
        int n5 = 0;
        while (n5 < n) {
            object = new Node();
            ((Node)object).number = n5++;
            arrayList.add((Node)object);
        }
        for (n5 = 0; n5 < n; ++n5) {
            String string2;
            object = stringTokenizer.nextToken();
            StringTokenizer stringTokenizer2 = new StringTokenizer((String)object);
            Node node = arrayList.get(n5);
            int n6 = Integer.parseInt(stringTokenizer2.nextToken());
            int n7 = Integer.parseInt(stringTokenizer2.nextToken());
            int n8 = Integer.parseInt(stringTokenizer2.nextToken());
            int n9 = Integer.parseInt(stringTokenizer2.nextToken());
            if (n6 != -1) {
                node.leftParent = arrayList.get(n6);
            }
            if (n7 != -1) {
                node.rightParent = arrayList.get(n7);
            }
            if (n8 != -1) {
                node.leftChild = arrayList.get(n8);
            }
            if (n9 != -1) {
                node.rightChild = arrayList.get(n9);
            }
            double d = Double.parseDouble(stringTokenizer2.nextToken());
            node.heightParameter = new Parameter.Default(d);
            String string3 = stringTokenizer2.nextToken();
            if (string3.compareTo("NA") != 0) {
                node.taxon = new Taxon(string3);
                ++n4;
            }
            if ((string2 = stringTokenizer2.nextToken()).compareTo("NA") == 0) {
                node.bifurcation = true;
                continue;
            }
            node.bifurcation = false;
            node.partitioning = new Parameter.Default(n2, 0.0);
            node.partitioning.setParameterValueQuietly(Integer.parseInt(string2), 1.0);
            while (stringTokenizer2.hasMoreTokens()) {
                node.partitioning.setParameterValueQuietly(Integer.parseInt(stringTokenizer2.nextToken()), 1.0);
            }
        }
        return new ARGModel(arrayList, (Node)arrayList.get(n3), n2, n4);
    }

    public String toARGSummary() {
        NumberFormatter numberFormatter = new NumberFormatter(4);
        String string = "   ";
        String string2 = "----------------------\nARG Summary \n---------------------- \n";
        string2 = string2 + "Number of nodes: " + this.nodes.size() + "\n";
        string2 = string2 + "Number of partitions: " + this.maxNumberOfPartitions + "\n";
        string2 = string2 + "Number of Reassorments: " + this.getReassortmentNodeCount() + "\n";
        string2 = string2 + "Root number: " + this.getRoot().getNumber() + "\n";
        string2 = string2 + "Node Summary\n----------------------------------------\nID  LP   RP   LC   RC   Height" + string + "TX  \n----------------------------------------\n";
        for (Node node : this.nodes) {
            string2 = string2 + node.getNumber() + string;
            string2 = node.leftParent == null ? string2 + "-1" + string : string2 + " " + node.leftParent.number + string;
            string2 = node.rightParent == null ? string2 + "-1" + string : string2 + " " + node.rightParent.number + string;
            string2 = node.leftChild == null ? string2 + "-1" + string : string2 + " " + node.leftChild.number + string;
            string2 = node.rightChild == null ? string2 + "-1" + string : string2 + " " + node.rightChild.number + string;
            string2 = string2 + numberFormatter.formatDecimal(this.getNodeHeight(node), 4) + string;
            if (node.partitioning != null) {
                int n = this.getNumberOfPartitions();
                for (int i = 0; i < n; ++i) {
                    string2 = string2 + node.partitioning.getParameterValue(i) + string;
                }
            }
            string2 = node.taxon == null ? string2 + "internal" + string : string2 + node.taxon + string;
            string2 = string2 + "\n";
        }
        string2 = string2 + "\nInduced Trees\n----------------------------------------\n";
        return string2;
    }

    public String toGraphStringCompressed(boolean bl) {
        int n = 0;
        for (Node object2 : this.nodes) {
            object2.number = n++;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.nodes.size());
        stringBuffer.append(":");
        stringBuffer.append(this.maxNumberOfPartitions);
        stringBuffer.append(":");
        stringBuffer.append(this.getRoot().getNumber());
        for (Node node : this.nodes) {
            stringBuffer.append(":");
            if (node.leftParent == null) {
                stringBuffer.append(" -1");
            } else {
                stringBuffer.append(" " + node.leftParent.number);
            }
            if (node.rightParent == null) {
                stringBuffer.append(" -1");
            } else {
                stringBuffer.append(" " + node.rightParent.number);
            }
            if (node.leftChild == null) {
                stringBuffer.append(" -1");
            } else {
                stringBuffer.append(" " + node.leftChild.number);
            }
            if (node.rightChild == null) {
                stringBuffer.append(" -1");
            } else {
                stringBuffer.append(" " + node.rightChild.number);
            }
            stringBuffer.append(" " + this.getNodeHeight(node));
            if (node.taxon != null) {
                stringBuffer.append(" " + node.taxon.toString());
            } else {
                stringBuffer.append(" NA");
            }
            if (node.partitioning != null) {
                double[] dArray = node.partitioning.getParameterValues();
                for (int i = 0; i < dArray.length; ++i) {
                    if (dArray[i] != 1.0) continue;
                    stringBuffer.append(" " + i);
                }
                continue;
            }
            stringBuffer.append(" NA");
        }
        String string = new String(stringBuffer);
        return new String(stringBuffer);
    }

    @Override
    public Tree getCopy() {
        throw new UnsupportedOperationException("please don't call this function");
    }

    public Element createElement(Document document) {
        throw new RuntimeException("Not implemented yet");
    }

    protected Node getNodeOfParameter(Parameter parameter) {
        if (parameter == null) {
            throw new IllegalArgumentException("Parameter is null!");
        }
        for (Node node : this.nodes) {
            if (node.heightParameter == parameter) {
                return node;
            }
            if (this.hasRates && node.rateParameter == parameter) {
                return node;
            }
            if (!this.hasTraits || node.traitParameter != parameter) continue;
            return node;
        }
        throw new RuntimeException("Parameter not found in any nodes:" + parameter.getId());
    }

    public Parameter getRootHeightParameter() {
        return this.root.heightParameter;
    }

    public Parameter createNodeHeightsParameter(boolean bl, boolean bl2, boolean bl3) {
        int n;
        if (!(bl || bl2 || bl3)) {
            throw new IllegalArgumentException("At least one of rootNode, internalNodes or leafNodes must be true");
        }
        CompoundParameter compoundParameter = new CompoundParameter(NODE_HEIGHTS);
        for (n = this.externalNodeCount; n < this.nodeCount; ++n) {
            Node node = this.nodes.get(n);
            if ((!bl || node != this.root) && (!bl2 || node == this.root)) continue;
            compoundParameter.addParameter(node.heightParameter);
        }
        if (bl3) {
            for (n = 0; n < this.externalNodeCount; ++n) {
                compoundParameter.addParameter(this.nodes.get((int)n).heightParameter);
            }
        }
        return compoundParameter;
    }

    public Parameter getLeafHeightParameter(NodeRef nodeRef) {
        Node node = (Node)nodeRef;
        if (!this.isExternal(node)) {
            throw new RuntimeException("only root and leaves can be used with setNodeHeightParameter");
        }
        return this.nodes.get((int)this.nodes.indexOf((Object)node)).heightParameter;
    }

    public Parameter createNodeRatesParameter(boolean bl, boolean bl2, boolean bl3, int n) {
        Node node;
        int n2;
        if (!(bl || bl2 || bl3)) {
            throw new IllegalArgumentException("At least one of rootNode, internalNodes or leafNodes must be true");
        }
        CompoundParameter compoundParameter = new CompoundParameter(NODE_RATES);
        this.hasRates = true;
        for (n2 = this.externalNodeCount; n2 < this.nodeCount; ++n2) {
            node = this.nodes.get(n2);
            node.createRateParameter(n);
            if ((!bl || node != this.root) && (!bl2 || node == this.root)) continue;
            compoundParameter.addParameter(node.rateParameter);
        }
        for (n2 = 0; n2 < this.externalNodeCount; ++n2) {
            node = this.nodes.get(n2);
            node.createRateParameter(n);
            if (!bl3) continue;
            compoundParameter.addParameter(node.rateParameter);
        }
        return compoundParameter;
    }

    public Parameter createNodeTraitsParameter(boolean bl, boolean bl2, boolean bl3) {
        Node node;
        int n;
        if (!(bl || bl2 || bl3)) {
            throw new IllegalArgumentException("At least one of rootNode, internalNodes or leafNodes must be true");
        }
        CompoundParameter compoundParameter = new CompoundParameter(NODE_TRAITS);
        this.hasTraits = true;
        for (n = this.externalNodeCount; n < this.nodeCount; ++n) {
            node = this.nodes.get(n);
            node.createTraitParameter();
            if ((!bl || node != this.root) && (!bl2 || node == this.root)) continue;
            compoundParameter.addParameter(node.traitParameter);
        }
        for (n = 0; n < this.externalNodeCount; ++n) {
            node = this.nodes.get(n);
            node.createTraitParameter();
            if (!bl3) continue;
            compoundParameter.addParameter(node.traitParameter);
        }
        return compoundParameter;
    }

    private void swapParameterObjects(Node node, Node node2) {
        double d = node.getHeight();
        double d2 = node2.getHeight();
        double d3 = 1.0;
        double d4 = 1.0;
        double d5 = 0.0;
        double d6 = 0.0;
        if (this.hasRates) {
            System.exit(-1);
            d3 = node.getRate(0);
            d4 = node2.getRate(0);
        }
        if (this.hasTraits) {
            d5 = node.getTrait();
            d6 = node2.getTrait();
        }
        Parameter parameter = node.heightParameter;
        node.heightParameter = node2.heightParameter;
        node2.heightParameter = parameter;
        if (this.hasRates) {
            parameter = node.rateParameter;
            node.rateParameter = node2.rateParameter;
            node2.rateParameter = parameter;
        }
        if (this.hasTraits) {
            parameter = node.traitParameter;
            node.traitParameter = node2.traitParameter;
            node2.traitParameter = parameter;
        }
        node.heightParameter.setParameterValueQuietly(0, d);
        node2.heightParameter.setParameterValueQuietly(0, d2);
        if (this.hasRates) {
            node.rateParameter.setParameterValueQuietly(0, d3);
            node2.rateParameter.setParameterValueQuietly(0, d4);
        }
        if (this.hasTraits) {
            node.traitParameter.setParameterValueQuietly(0, d5);
            node2.traitParameter.setParameterValueQuietly(0, d6);
        }
    }

    @Override
    public double getNodeRate(NodeRef nodeRef) {
        throw new RuntimeException("This should not be called");
    }

    private class NodeHeightBounds
    implements Bounds<Double> {
        private Parameter nodeHeightParameter = null;

        public NodeHeightBounds(Parameter parameter) {
            this.nodeHeightParameter = parameter;
        }

        @Override
        public Double getUpperLimit(int n) {
            Node node = ARGModel.this.getNodeOfParameter(this.nodeHeightParameter);
            if (node.isRoot()) {
                return Double.POSITIVE_INFINITY;
            }
            if (node.leftParent == null) {
                System.err.println("leftParent of " + node.number + " is null");
            }
            if (node.rightParent == null) {
                System.err.println("rightParent of " + node.number + " is null");
            }
            return Math.min(node.leftParent.getHeight(), node.rightParent.getHeight());
        }

        @Override
        public Double getLowerLimit(int n) {
            Node node = ARGModel.this.getNodeOfParameter(this.nodeHeightParameter);
            if (node.isExternal()) {
                return 0.0;
            }
            if (node.leftChild == null) {
                System.err.println("Node " + node.number + " has null leftChild");
            }
            if (node.rightChild == null) {
                System.err.println("Node " + node.number + " has null rightChild");
            }
            return Math.max(node.leftChild.getHeight(), node.rightChild.getHeight());
        }

        @Override
        public int getBoundsDimension() {
            return 1;
        }
    }

    public class Node
    implements NodeRef {
        public boolean[] ancestralMaterial;
        public boolean fullAncestralMaterial;
        public boolean hasSomeAncestralMaterial;
        public int myHashCode = 0;
        public NodeRef mirrorNode;
        public Node leftParent = null;
        public Node rightParent = null;
        public Node leftChild = null;
        public Node rightChild = null;
        public int number;
        public Parameter heightParameter;
        public Parameter rateParameter = null;
        public Parameter traitParameter = null;
        public Taxon taxon = null;
        public Parameter partitioning;
        public boolean bifurcation = true;

        public boolean hasReassortmentAncestor() {
            Node node = this;
            while (node != null) {
                if (!node.bifurcation) {
                    return true;
                }
                node = node.leftParent;
            }
            return false;
        }

        public void setAncestralMaterial(boolean[] blArray) {
            if (this.fullAncestralMaterial) {
                return;
            }
            this.fullAncestralMaterial = true;
            for (int i = 0; i < this.ancestralMaterial.length; ++i) {
                this.ancestralMaterial[i] = this.ancestralMaterial[i] || blArray[i];
                this.fullAncestralMaterial = this.fullAncestralMaterial && this.ancestralMaterial[i];
                this.hasSomeAncestralMaterial = this.hasSomeAncestralMaterial || this.ancestralMaterial[i];
            }
            if (this.bifurcation) {
                if (this.leftParent != null) {
                    this.leftParent.setAncestralMaterial(this.ancestralMaterial);
                }
            } else {
                boolean[] blArray2 = new boolean[this.ancestralMaterial.length];
                boolean[] blArray3 = new boolean[this.ancestralMaterial.length];
                System.arraycopy(this.ancestralMaterial, 0, blArray2, 0, blArray2.length);
                System.arraycopy(this.ancestralMaterial, 0, blArray3, 0, blArray3.length);
                for (int i = 0; i < this.ancestralMaterial.length; ++i) {
                    if (this.partitioning.getParameterValue(i) == 0.0) {
                        blArray3[i] = false;
                        continue;
                    }
                    blArray2[i] = false;
                }
                this.leftParent.setAncestralMaterial(blArray2);
                this.rightParent.setAncestralMaterial(blArray3);
            }
        }

        public int hashCode() {
            if (this.myHashCode == 0) {
                this.myHashCode = super.hashCode();
            }
            return this.myHashCode;
        }

        public boolean equals(Object object) {
            return this.hashCode() == object.hashCode();
        }

        public int countReassortmentChild(Tree tree) {
            if (this.isExternal()) {
                return 0;
            }
            if (this.isReassortment()) {
                return 1 + this.leftChild.countReassortmentChild(tree);
            }
            if (this.isBifurcationDoublyLinked()) {
                return this.leftChild.countReassortmentChild(tree);
            }
            return this.leftChild.countReassortmentChild(tree) + this.rightChild.countReassortmentChild(tree);
        }

        public Node() {
            this.heightParameter = null;
            this.number = 0;
            this.taxon = null;
            this.partitioning = null;
        }

        public Node(Node node) {
            this.heightParameter = node.heightParameter;
            this.taxon = node.taxon;
            this.number = node.number;
            if (node.leftChild != null) {
                if (node.leftChild.isReassortment()) {
                    this.singleAddChild(new Node(node.leftChild.leftChild));
                } else {
                    this.singleAddChild(new Node(node.leftChild));
                }
            }
            if (node.rightChild != null) {
                if (node.rightChild.isReassortment()) {
                    this.singleAddChild(new Node(node.rightChild.leftChild));
                } else {
                    this.singleAddChild(new Node(node.rightChild));
                }
            }
        }

        public Node(Tree tree, NodeRef nodeRef) {
            this.partitioning = null;
            this.heightParameter = new Parameter.Default(tree.getNodeHeight(nodeRef));
            ARGModel.this.addVariable(this.heightParameter);
            this.number = nodeRef.getNumber();
            this.taxon = tree.getNodeTaxon(nodeRef);
            for (int i = 0; i < tree.getChildCount(nodeRef); ++i) {
                this.singleAddChild(new Node(tree, tree.getChild(nodeRef, i)));
            }
        }

        public Node(Node node, int n) {
            Node node2 = node;
            while (node2.isBifurcationDoublyLinked()) {
                node2 = node2.leftChild.leftChild;
            }
            this.heightParameter = node2.heightParameter;
            this.number = node2.number;
            this.taxon = node2.taxon;
            this.bifurcation = true;
            this.mirrorNode = node2;
            if (node2.isExternal()) {
                return;
            }
            Node node3 = node2.getChild(0, n);
            Node node4 = node2.getChild(1, n);
            if (node3 != null || node4 != null) {
                if (node3 != null) {
                    this.singleAddChild(new Node(node3, n));
                }
                if (node4 != null) {
                    this.singleAddChild(new Node(node4, n));
                }
            }
        }

        public void setPartitionRecursively(int n) {
            boolean bl = MathUtils.nextBoolean();
            if (this.leftChild != null) {
                if (this.partitioning != null && bl) {
                    this.partitioning.setParameterValue(n, 1.0);
                }
                this.leftChild.setPartitionRecursively(n);
            }
            if (this.rightChild != null) {
                if (this.partitioning != null && !bl) {
                    this.partitioning.setParameterValue(n, 1.0);
                }
                this.rightChild.setPartitionRecursively(n);
            }
        }

        public void stripOutDeadEnds() {
            if (this.leftChild != null) {
                this.leftChild.stripOutDeadEnds();
            }
            if (this.rightChild != null && this.rightChild != this.leftChild) {
                this.rightChild.stripOutDeadEnds();
            }
            if (this.taxon == null && this.leftChild == null && this.rightChild == null) {
                this.leftParent.doubleRemoveChild(this);
            }
        }

        public Node stripOutSingleChildNodes(Node node) {
            int n = this.getChildCount();
            if (n == 0) {
                return node;
            }
            if (n == 2) {
                if (this.hasEqualChildren()) {
                    return this.leftChild.stripOutSingleChildNodes(this.leftChild);
                }
                this.leftChild.stripOutSingleChildNodes(node);
                this.rightChild.stripOutSingleChildNodes(node);
                return node;
            }
            if (this.isRoot()) {
                if (this.leftChild != null) {
                    this.leftChild.rightParent = null;
                    this.leftChild.leftParent = null;
                    return this.leftChild.stripOutSingleChildNodes(this.leftChild);
                }
                this.rightChild.rightParent = null;
                this.rightChild.leftParent = null;
                return this.rightChild.stripOutSingleChildNodes(this.rightChild);
            }
            Node node2 = this.leftParent;
            Node node3 = this.leftChild;
            if (node3 == null) {
                node3 = this.rightChild;
            }
            node2.doubleRemoveChild(this);
            this.doubleRemoveChild(node3);
            node2.singleAddChild(node3);
            return node3.stripOutSingleChildNodes(node);
        }

        public final void setupHeightBounds() {
            this.heightParameter.addBounds(new NodeHeightBounds(this.heightParameter));
        }

        public final void createRateParameter(int n) {
            if (this.rateParameter == null) {
                double[] dArray = new double[n];
                for (int i = 0; i < dArray.length; ++i) {
                    dArray[i] = 1.0;
                }
                this.rateParameter = new Parameter.Default(dArray);
                if (this.isRoot()) {
                    this.rateParameter.setId("root.rate");
                } else if (this.isExternal()) {
                    this.rateParameter.setId(ARGModel.this.getTaxonId(this.getNumber()) + ".rate");
                } else {
                    this.rateParameter.setId(ARGModel.NODE_ELEMENT + this.getNumber() + ".rate");
                }
                this.rateParameter.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, dArray.length));
                ARGModel.this.addVariable(this.rateParameter);
            }
        }

        public final void createTraitParameter() {
            if (this.traitParameter == null) {
                this.traitParameter = new Parameter.Default(1.0);
                if (this.isRoot()) {
                    this.traitParameter.setId("root.trait");
                } else if (this.isExternal()) {
                    this.traitParameter.setId(ARGModel.this.getTaxonId(this.getNumber()) + ".trait");
                } else {
                    this.traitParameter.setId(ARGModel.NODE_ELEMENT + this.getNumber() + ".trait");
                }
                this.rateParameter.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, 1));
                ARGModel.this.addVariable(this.traitParameter);
            }
        }

        public final double getHeight() {
            return this.heightParameter.getParameterValue(0);
        }

        public final double getRate(int n) {
            return this.rateParameter.getParameterValue(n);
        }

        public final double getTrait() {
            return this.traitParameter.getParameterValue(0);
        }

        public final void setHeight(double d) {
            this.heightParameter.setParameterValue(0, d);
        }

        public final void setRate(double d) {
            this.rateParameter.setParameterValue(0, d);
        }

        public final void setTrait(double d) {
            this.traitParameter.setParameterValue(0, d);
        }

        @Override
        public int getNumber() {
            return this.number;
        }

        @Override
        public void setNumber(int n) {
            this.number = n;
        }

        public final int getChildCount() {
            int n = 0;
            if (this.leftChild != null) {
                ++n;
            }
            if (this.rightChild != null && this.bifurcation) {
                ++n;
            }
            return n;
        }

        public final int getParentCount() {
            int n = 0;
            if (this.leftParent != null) {
                ++n;
            }
            if (this.rightParent != null) {
                ++n;
            }
            return n;
        }

        public Node getChild(int n) {
            if (n == 0) {
                return this.leftChild;
            }
            if (n == 1) {
                return this.rightChild;
            }
            throw new IllegalArgumentException("ARGModel.Nodes can only have up to 2 children");
        }

        private boolean isBifurcationDoublyLinked() {
            return this.bifurcation && this.leftChild == this.rightChild && this.leftChild != null;
        }

        private boolean recombinantIsLinked(Node node, int n) {
            boolean bl = this.leftParent == node;
            boolean bl2 = this.rightParent == node;
            double d = this.partitioning.getParameterValue(n);
            if (bl && d == 0.0) {
                return true;
            }
            return bl2 && d == 1.0;
        }

        public int getDescendentTipCount() {
            if (this.isExternal()) {
                return 1;
            }
            return this.leftChild.getDescendentTipCount() + this.rightChild.getDescendentTipCount();
        }

        public boolean checkForNullRights() {
            if (this.isExternal()) {
                return false;
            }
            if (this.rightChild == null) {
                return true;
            }
            return this.rightChild.checkForNullRights() || this.leftChild.checkForNullRights();
        }

        private Node findNextTreeNode(Node node, int n) {
            if (this.isExternal()) {
                return this;
            }
            Node node2 = this;
            if (node2.isReassortment()) {
                if (this.recombinantIsLinked(node, n)) {
                    return this.leftChild.findNextTreeNode(node, n);
                }
                return null;
            }
            node2 = this.leftChild.findNextTreeNode(node, n);
            if (node2 == null) {
                node2 = this.rightChild.findNextTreeNode(node, n);
            }
            if (node2 == null) {
                throw new IllegalArgumentException("Can't find next tree node.");
            }
            return node2;
        }

        private Node getChild(int n, int n2) {
            Node node = null;
            if (n == 0) {
                node = this.leftChild;
            }
            if (n == 1) {
                node = this.rightChild;
            }
            if (node.isExternal()) {
                return node;
            }
            if (node.isBifurcationDoublyLinked()) {
                return node.leftChild.getChild(0, n2);
            }
            if (node.isReassortment()) {
                if (node.recombinantIsLinked(this, n2)) {
                    return node.getChild(0, n2);
                }
                return null;
            }
            if (node.leftChild.isReassortment() && node.rightChild.isReassortment()) {
                if (node.leftChild.recombinantIsLinked(node, n2)) {
                    return node;
                }
                if (node.rightChild.recombinantIsLinked(node, n2)) {
                    return node;
                }
                return null;
            }
            return node;
        }

        public Node getParent(int n) {
            if (n == 0) {
                return this.leftParent;
            }
            if (n == 1) {
                return this.rightParent;
            }
            throw new IllegalArgumentException("ARGModel.Nodes can only have 2 parents");
        }

        public boolean hasChild(Node node) {
            return this.leftChild == node || this.rightChild == node;
        }

        public void singleAddChild(Node node) {
            if (this.leftChild == null) {
                this.leftChild = node;
            } else if (this.rightChild == null) {
                this.rightChild = node;
            } else {
                throw new IllegalArgumentException("ARGModel.Nodes can only have 2 children");
            }
            if (node.leftParent == null) {
                node.leftParent = this;
            }
            if (node.rightParent == null) {
                node.rightParent = this;
            }
        }

        public void singleAddChildWithOneParent(Node node) {
            if (this.leftChild == null) {
                this.leftChild = node;
            } else if (this.rightChild == null) {
                this.rightChild = node;
            } else {
                throw new IllegalArgumentException("ARGModel.Node " + this.number + " can only have 2 children");
            }
            if (node.leftParent == null) {
                node.leftParent = this;
            } else if (node.rightParent == null) {
                node.rightParent = this;
            } else {
                throw new IllegalArgumentException("ARGModel.Nodes can only have 2 parents");
            }
        }

        public void doubleAddChild(Node node) {
            if (this.leftChild == null) {
                this.leftChild = node;
            }
            if (this.rightChild == null) {
                this.rightChild = node;
            }
            if (node.leftParent == null) {
                node.leftParent = this;
            }
            if (node.rightParent == null) {
                node.rightParent = this;
            }
        }

        public void doubleAddChildWithOneParent(Node node) {
            if (this.leftChild == null) {
                this.leftChild = node;
            }
            if (this.rightChild == null) {
                this.rightChild = node;
            }
            if (node.leftParent == null) {
                node.leftParent = this;
            } else if (node.rightParent == null) {
                node.rightParent = this;
            } else {
                throw new IllegalArgumentException("ARGModel.Nodes can only have 2 parents");
            }
        }

        public void addChildNoParentConnection(Node node) {
            if (this.leftChild == null) {
                this.leftChild = node;
            } else if (this.rightChild == null) {
                this.rightChild = node;
            } else {
                throw new IllegalArgumentException("Nodes can only have 2 children.");
            }
        }

        public void addChildRecombinant(Node node, Parameter parameter) {
            if (this.leftChild == null) {
                this.leftChild = node;
            }
            if (this.rightChild == null) {
                this.rightChild = node;
            }
            if (node.leftParent == null) {
                node.leftParent = this;
                node.partitioning = parameter;
            } else if (node.rightParent == null) {
                node.rightParent = this;
                node.partitioning = parameter;
            } else {
                throw new IllegalArgumentException("Recombinant nodes can only have 2 parents.");
            }
        }

        public Node doubleRemoveChild(Node node) {
            boolean bl = false;
            if (this.leftChild == node) {
                this.leftChild = null;
                bl = true;
            }
            if (this.rightChild == node) {
                this.rightChild = null;
                bl = true;
            }
            if (!bl) {
                throw new IllegalArgumentException("Unknown child node");
            }
            if (node.leftParent == this) {
                node.leftParent = null;
            }
            if (node.rightParent == this) {
                node.rightParent = null;
            }
            return node;
        }

        public Node singleRemoveChild(Node node) {
            if (this.leftChild == node) {
                this.leftChild = null;
            } else if (this.rightChild == node) {
                this.rightChild = null;
            } else {
                throw new IllegalArgumentException("Unknown child node");
            }
            if (node.bifurcation) {
                node.rightParent = null;
                node.leftParent = null;
                return null;
            }
            if (node.leftParent == this) {
                node.leftParent = null;
            } else if (node.rightParent == this) {
                node.rightParent = null;
            }
            return node;
        }

        public Node removeChild(int n) {
            Node node;
            if (n == 0) {
                node = this.leftChild;
                this.leftChild = null;
            } else if (n == 1) {
                node = this.rightChild;
                this.rightChild = null;
            } else {
                throw new IllegalArgumentException("TreeModel.Nodes can only have 2 children");
            }
            if (node.leftParent == this) {
                node.leftParent = null;
            }
            if (node.rightParent == this) {
                node.rightParent = null;
            }
            return node;
        }

        public boolean hasChildren() {
            return this.leftChild != null || this.rightChild != null;
        }

        public boolean isExternal() {
            return !this.hasChildren();
        }

        public boolean isRoot() {
            return this.leftParent == null && this.rightParent == null;
        }

        public boolean hasEqualChildren() {
            return this.leftChild == this.rightChild;
        }

        public boolean isBifurcation() {
            return this.bifurcation;
        }

        public boolean isReassortment() {
            return !this.bifurcation;
        }

        private String toExtendedNewick() {
            if (this.isExternal()) {
                return this.taxon.getId();
            }
            if (this.isBifurcation()) {
                String string;
                String string2 = this.leftChild.toExtendedNewick();
                if (string2.compareTo(string = this.rightChild.toExtendedNewick()) < 0) {
                    return "(" + string2 + "," + string + ")";
                }
                return "(" + string + "," + string2 + ")";
            }
            return "<" + this.leftChild.toExtendedNewick() + ">";
        }

        public String toString() {
            if (this.taxon == null) {
                return "" + this.number;
            }
            return "" + this.number + " (" + this.taxon.getId() + ")";
        }
    }

    private class CountReassortmentColumn
    extends NumberColumn {
        public CountReassortmentColumn(String string) {
            super(string);
        }

        @Override
        public double getDoubleValue() {
            return ARGModel.this.getReassortmentNodeCount();
        }
    }

    private class IsRootTooHighColumn
    extends NumberColumn {
        public IsRootTooHighColumn(String string) {
            super(string);
        }

        @Override
        public double getDoubleValue() {
            return ARGModel.this.isBifurcationDoublyLinked(ARGModel.this.getRoot()) ? 1.0 : 0.0;
        }
    }

    private class IsReassortmentColumn
    extends NumberColumn {
        public IsReassortmentColumn(String string) {
            super(string);
        }

        @Override
        public double getDoubleValue() {
            return ARGModel.this.getReassortmentNodeCount() == 0 ? 0.0 : 1.0;
        }
    }

    private class ArgTreeHeightColumn
    extends NumberColumn {
        private final int partition;
        private final ARGModel argModel;

        public ArgTreeHeightColumn(String string, ARGModel aRGModel2, int n) {
            super(string + n);
            this.argModel = aRGModel2;
            this.partition = n;
        }

        @Override
        public double getDoubleValue() {
            ARGTree aRGTree = new ARGTree(this.argModel, this.partition);
            return aRGTree.getNodeHeight(aRGTree.getRoot());
        }
    }

    private abstract class ExtremeNodeHeightColumn
    extends NumberColumn {
        public ExtremeNodeHeightColumn(String string) {
            super(string);
        }

        abstract double compare(double var1, double var3);

        abstract double getStartValue();

        @Override
        public double getDoubleValue() {
            double d = this.getStartValue();
            for (Node node : ARGModel.this.nodes) {
                double d2 = node.heightParameter.getParameterValue(0);
                if (!(d2 > 0.0) || ARGModel.this.isRoot(node)) continue;
                d = this.compare(d, d2);
            }
            return d;
        }
    }

    public class ARGTreeChangedEvent
    implements TreeChangedEvent {
        final Node node;
        final Parameter parameter;
        final int index;
        int size = 0;

        public ARGTreeChangedEvent() {
            this(null, null, -1);
        }

        public ARGTreeChangedEvent(Node node) {
            this(node, null, -1);
        }

        public ARGTreeChangedEvent(Node node, Parameter parameter, int n) {
            this.node = node;
            this.parameter = parameter;
            this.index = n;
        }

        public ARGTreeChangedEvent(int n) {
            this(null, null, -1);
            this.size = n;
        }

        @Override
        public int getIndex() {
            return this.index;
        }

        @Override
        public Node getNode() {
            return this.node;
        }

        @Override
        public Parameter getParameter() {
            return this.parameter;
        }

        public int getSize() {
            return this.size;
        }

        public boolean isSizeChanged() {
            return this.size != 0;
        }

        @Override
        public boolean isTreeChanged() {
            return this.parameter == null;
        }

        @Override
        public boolean isNodeChanged() {
            return this.node != null;
        }

        @Override
        public boolean isNodeParameterChanged() {
            return this.parameter != null;
        }

        @Override
        public boolean isHeightChanged() {
            return this.parameter == this.node.heightParameter;
        }

        public boolean isRateChanged() {
            return this.parameter == this.node.rateParameter;
        }

        public boolean isTraitChanged() {
            return this.parameter == this.node.traitParameter;
        }
    }

    private class SimulateSticks {
        public final Node mySon;
        public final boolean leftStick;

        public SimulateSticks(Node node, boolean bl) {
            this.mySon = node;
            this.leftStick = bl;
        }
    }
}

