/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.coalescent;

import dr.evolution.io.Importer;
import dr.evomodel.coalescent.operators.GaussianProcessSkytrackBlockUpdateOperator;
import dr.inference.model.Parameter;
import dr.inference.trace.LogFileTraces;
import dr.inference.trace.TraceException;
import dr.stats.DiscreteStatistics;
import dr.util.TabularData;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;

@Deprecated
public class GPSkytrackAnalysis
extends TabularData {
    private final double[] xPoints;
    private final double[] means;
    private final double[] medians;
    private final double[] hpdLower;
    private final double[] hpdHigh;
    private final double[][] gValues;
    private final double[][] tValues;
    private final double[][] newGvalues;
    private final double[][] popValues;
    private Parameter numGridPoints;
    private final String[] columnNames = new String[]{"time", "mean", "median", "lower", "upper"};

    public GPSkytrackAnalysis(File file, double d, Parameter parameter) throws IOException, Importer.ImportException, TraceException {
        int n;
        GaussianProcessSkytrackBlockUpdateOperator gaussianProcessSkytrackBlockUpdateOperator = new GaussianProcessSkytrackBlockUpdateOperator();
        this.numGridPoints = parameter;
        LogFileTraces logFileTraces = new LogFileTraces(file.getCanonicalPath(), file);
        logFileTraces.loadTraces();
        logFileTraces.setBurnIn(0L);
        int n2 = logFileTraces.getStateCount();
        int n3 = (int)Math.floor(d < 1.0 ? (double)n2 * d : d);
        int n4 = n2 - n3;
        logFileTraces.setBurnIn((long)n3 * logFileTraces.getStepSize());
        assert (logFileTraces.getStateCount() == n4);
        this.xPoints = new double[(int)parameter.getParameterValue(0) + 1];
        this.means = new double[(int)parameter.getParameterValue(0) + 1];
        this.medians = new double[(int)parameter.getParameterValue(0) + 1];
        this.hpdHigh = new double[(int)parameter.getParameterValue(0) + 1];
        this.hpdLower = new double[(int)parameter.getParameterValue(0) + 1];
        int n5 = -1;
        int n6 = -1;
        int n7 = -1;
        int n8 = -1;
        int n9 = -1;
        int n10 = -1;
        for (int i = 0; i < logFileTraces.getTraceCount(); ++i) {
            String string = logFileTraces.getTraceName(i);
            System.err.println(string);
            if (string.equals("skyride.points")) {
                n5 = i;
                continue;
            }
            if (string.equals("skyride.lambda_bound")) {
                n8 = i;
                continue;
            }
            if (string.equals("skyride.precision")) {
                n9 = i;
                continue;
            }
            if (string.equals("skyride.tmrca")) {
                n10 = i;
                continue;
            }
            if (string.equals("changePoints")) {
                n7 = i;
                continue;
            }
            if (!string.equals("Gvalues")) continue;
            n6 = i;
        }
        if (n5 < 0 || n8 < 0 || n9 < 0 || n10 < 0 || n7 < 0 || n6 < 0) {
            throw new TraceException("incorrect trace column names: unable to find correct columns for summary");
        }
        double d2 = 0.0;
        int[] nArray = new int[n4];
        double[] dArray = new double[n4];
        double[] dArray2 = new double[n4];
        double d3 = 0.0;
        double d4 = 0.0;
        int n11 = 0;
        for (n = 0; n < n4; ++n) {
            dArray[n] = logFileTraces.getTrace(n8).getValue(n);
            nArray[n] = (int)Math.round(logFileTraces.getTrace(n5).getValue(n));
            dArray2[n] = logFileTraces.getTrace(n9).getValue(n);
            d4 = logFileTraces.getTrace(n10).getValue(n);
            System.exit(-1);
            if (d4 > d3) {
                d3 = d4;
            }
            if (nArray[n] <= n11) continue;
            n11 = nArray[n];
        }
        d2 = d3 / parameter.getParameterValue(0);
        this.xPoints[0] = 0.0;
        for (n = 1; n < this.xPoints.length; ++n) {
            this.xPoints[n] = this.xPoints[n - 1] + d2;
        }
        this.gValues = new double[n4][];
        this.tValues = new double[n4][];
        this.newGvalues = new double[n4][];
        this.popValues = new double[(int)parameter.getParameterValue(0) + 1][];
        this.readChain(this.gValues, "gvalues.txt");
        this.readChain(this.tValues, "locations.txt");
        n = 0;
        while ((double)n <= parameter.getParameterValue(0)) {
            this.popValues[n] = new double[n4 - 1];
            ++n;
        }
        for (n = 0; n < n4 - 1; ++n) {
            this.newGvalues[n] = gaussianProcessSkytrackBlockUpdateOperator.getGPvaluesS(this.tValues[n], this.gValues[n], this.xPoints, dArray2[n]);
            int n12 = 0;
            while ((double)n12 <= parameter.getParameterValue(0)) {
                this.popValues[n12][n] = (1.0 + Math.exp(-this.newGvalues[n][n12])) / dArray[n];
                ++n12;
            }
        }
        for (n = 0; n < this.xPoints.length; ++n) {
            this.means[n] = DiscreteStatistics.mean(this.popValues[n]);
            this.medians[n] = DiscreteStatistics.median(this.popValues[n]);
            this.hpdLower[n] = DiscreteStatistics.quantile(0.025, this.popValues[n]);
            this.hpdHigh[n] = DiscreteStatistics.quantile(0.975, this.popValues[n]);
        }
    }

    public void readChain(double[][] dArray, String string) {
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            String string2 = null;
            int n = 0;
            while ((string2 = bufferedReader.readLine()) != null) {
                String[] stringArray = string2.split(" ");
                dArray[n] = new double[stringArray.length];
                for (int i = 0; i < stringArray.length; ++i) {
                    dArray[n][i] = Double.parseDouble(stringArray[i]);
                }
                ++n;
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            System.err.println("IOException:" + iOException.getMessage());
        }
    }

    @Override
    public int nColumns() {
        return 5;
    }

    @Override
    public String columnName(int n) {
        return this.columnNames[n];
    }

    @Override
    public int nRows() {
        return (int)this.numGridPoints.getParameterValue(0) + 1;
    }

    @Override
    public Object data(int n, int n2) {
        switch (n2) {
            case 0: {
                if (n >= this.xPoints.length) break;
                return this.xPoints[n];
            }
            case 1: {
                if (n >= this.means.length) break;
                return this.means[n];
            }
            case 2: {
                if (n >= this.medians.length) break;
                return this.medians[n];
            }
            case 3: {
                if (n >= this.hpdLower.length) break;
                return this.hpdLower[n];
            }
            case 4: {
                if (n >= this.hpdHigh.length) break;
                return this.hpdHigh[n];
            }
        }
        return "";
    }
}

