/*
 * Decompiled with CFR 0.152.
 */
package dr.evolution.alignment;

import dr.evolution.alignment.Alignment;
import dr.evolution.alignment.PatternList;
import dr.evolution.alignment.WrappedAlignment;
import dr.evolution.datatype.DataType;
import dr.evolution.datatype.StateDependentDataType;
import dr.evolution.datatype.StateDependentNucleotides;
import java.util.Arrays;

public class ExpandAlignmentStateSpace
extends WrappedAlignment {
    private DataType dataType = null;
    private int numDependentStates;
    private int[] expansionIndices = null;

    public ExpandAlignmentStateSpace(DataType dataType) {
        this(dataType, null, null);
    }

    public ExpandAlignmentStateSpace(DataType dataType, PatternList patternList) {
        this(dataType, null, patternList);
    }

    public ExpandAlignmentStateSpace(DataType dataType, Alignment alignment) {
        this(dataType, alignment, null);
    }

    public ExpandAlignmentStateSpace(DataType dataType, Alignment alignment, PatternList patternList) {
        super(alignment);
        if (alignment.getTaxonCount() != patternList.getTaxonCount()) {
            throw new RuntimeException("Alignment and trait must have same number of taxa.");
        }
        if (!this.checkTaxa(alignment, patternList)) {
            throw new RuntimeException("Alignment and trait must have same taxa.");
        }
        this.setDataType(dataType);
        this.setExpansionIndices(patternList);
        this.setAlignment(alignment);
    }

    public void setExpansionIndices(PatternList patternList) {
        int[] nArray = new int[patternList.getTaxonCount()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = patternList.getPatternState(i, 0);
        }
        this.numDependentStates = patternList.getStateCount();
        this.expansionIndices = nArray;
    }

    public void setAlignment(Alignment alignment) {
        if (this.dataType == null) {
            this.dataType = alignment.getDataType();
        }
        this.alignment = alignment;
        int n = alignment.getDataType().getType();
        if (((StateDependentDataType)((Object)this.dataType)).getDependentClassCount() != this.numDependentStates) {
            throw new RuntimeException("Number of dependent states found (" + this.numDependentStates + ") incompatible with data type " + this.dataType);
        }
        if (n == 0) {
            if (!(this.dataType instanceof StateDependentNucleotides)) {
                throw new RuntimeException("Incompatible alignment DataType for ExpandedStateSpaceAlignment");
            }
        } else {
            throw new RuntimeException("Incompatible alignment DataType for ExpandedStateSpaceAlignment");
        }
    }

    @Override
    public void setDataType(DataType dataType) {
        this.dataType = dataType;
    }

    @Override
    public DataType getDataType() {
        return this.dataType;
    }

    @Override
    public int getSiteCount() {
        if (this.alignment == null) {
            throw new RuntimeException("ExpandAlignmentStateSpace has no alignment");
        }
        return this.alignment.getSiteCount();
    }

    @Override
    public int getState(int n, int n2) {
        if (this.alignment == null) {
            throw new RuntimeException("ExpandAlignmentStateSpace has no alignment");
        }
        int n3 = this.dataType.getType();
        int n4 = this.alignment.getDataType().getType();
        int n5 = 0;
        if (n4 == 0) {
            int n6 = this.alignment.getState(n, n2);
            n5 = ((StateDependentNucleotides)this.dataType).getState(n6, this.expansionIndices[n]);
        }
        return n5;
    }

    private boolean checkTaxa(Alignment alignment, PatternList patternList) {
        int n;
        boolean bl = true;
        String[] stringArray = new String[alignment.getTaxonCount()];
        for (n = 0; n < alignment.getTaxonCount(); ++n) {
            stringArray[n] = patternList.getTaxon(n).getId();
        }
        for (n = 0; n < alignment.getTaxonCount(); ++n) {
            String string = alignment.getTaxon(n).getId();
            if (string == stringArray[n] || Arrays.asList(stringArray).contains(string)) continue;
            bl = false;
            break;
        }
        return bl;
    }
}

