/*
 * Decompiled with CFR 0.152.
 */
package dr.evolution.coalescent;

import dr.evolution.coalescent.ExponentialGrowth;
import dr.evolution.util.Units;

public class ExponentialExponential
extends ExponentialGrowth {
    private double transitionTime;
    private double r1;

    public ExponentialExponential(Units.Type type) {
        super(type);
    }

    public double getTransitionTime() {
        return this.transitionTime;
    }

    public void setTransitionTime(double d) {
        this.transitionTime = d;
    }

    public final double getAncestralGrowthRate() {
        return this.r1;
    }

    public void setAncestralGrowthRate(double d) {
        this.r1 = d;
    }

    public void setN1(double d) {
        double d2 = this.getGrowthRate();
        double d3 = this.getTransitionTime();
        double d4 = d * Math.exp(d2 * d3);
        this.setN0(d4);
    }

    @Override
    public double getDemographic(double d) {
        double d2 = this.getN0();
        double d3 = this.getGrowthRate();
        double d4 = this.getAncestralGrowthRate();
        double d5 = this.getTransitionTime();
        if (d < d5) {
            return d2 * Math.exp(-d3 * d);
        }
        return d2 * Math.exp(-d3 * d5 - d4 * (d - d5));
    }

    @Override
    public double getIntegral(double d, double d2) {
        return this.getNumericalIntegral(d, d2);
    }

    @Override
    public double getIntensity(double d) {
        throw new RuntimeException("Not implemented!");
    }

    @Override
    public double getInverseIntensity(double d) {
        throw new RuntimeException("Not implemented!");
    }

    @Override
    public int getNumArguments() {
        return 4;
    }

    @Override
    public String getArgumentName(int n) {
        switch (n) {
            case 0: {
                return "N0";
            }
            case 1: {
                return "r0";
            }
            case 2: {
                return "r1";
            }
            case 3: {
                return "transitionTime";
            }
        }
        throw new IllegalArgumentException("Argument " + n + " does not exist");
    }

    @Override
    public double getArgument(int n) {
        switch (n) {
            case 0: {
                return this.getN0();
            }
            case 1: {
                return this.getGrowthRate();
            }
            case 2: {
                return this.getAncestralGrowthRate();
            }
            case 3: {
                return this.getTransitionTime();
            }
        }
        throw new IllegalArgumentException("Argument " + n + " does not exist");
    }

    @Override
    public void setArgument(int n, double d) {
        switch (n) {
            case 0: {
                this.setN0(d);
                break;
            }
            case 1: {
                this.setGrowthRate(d);
                break;
            }
            case 2: {
                this.setAncestralGrowthRate(d);
                break;
            }
            case 3: {
                this.setTransitionTime(d);
                break;
            }
            default: {
                throw new IllegalArgumentException("Argument " + n + " does not exist");
            }
        }
    }

    @Override
    public double getLowerBound(int n) {
        switch (n) {
            case 0: {
                return 0.0;
            }
            case 1: {
                return Double.NEGATIVE_INFINITY;
            }
            case 2: {
                return Double.NEGATIVE_INFINITY;
            }
            case 3: {
                return Double.NEGATIVE_INFINITY;
            }
        }
        throw new IllegalArgumentException("Argument " + n + " does not exist");
    }

    @Override
    public double getUpperBound(int n) {
        return Double.POSITIVE_INFINITY;
    }
}

