/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.stuff;

import dr.evomodel.stuff.HDPPolyaUrn;
import dr.inference.model.CompoundParameter;
import dr.inference.model.Parameter;
import dr.inference.operators.GibbsOperator;
import dr.inference.operators.MCMCOperator;
import dr.inference.operators.SimpleMCMCOperator;
import dr.math.MathUtils;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;

public class HDPStickPropsOperator
extends SimpleMCMCOperator
implements GibbsOperator {
    private static final String HDP_STICK_PROPS_OPERATOR = "hdpStickPropsOperator";
    private HDPPolyaUrn hdp;
    private CompoundParameter tableCounts;
    private CompoundParameter stickProportions;
    private Parameter groupAssignments;
    private Parameter categoriesParameter;
    private double pathWeight = 1.0;
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private XMLSyntaxRule[] rules = new XMLSyntaxRule[]{AttributeRule.newDoubleRule("weight"), new ElementRule(HDPPolyaUrn.class, false)};

        @Override
        public String getParserName() {
            return HDPStickPropsOperator.HDP_STICK_PROPS_OPERATOR;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            double d = xMLObject.getDoubleAttribute("weight");
            HDPPolyaUrn hDPPolyaUrn = (HDPPolyaUrn)xMLObject.getChild(HDPPolyaUrn.class);
            return new HDPStickPropsOperator(hDPPolyaUrn, d);
        }

        @Override
        public String getParserDescription() {
            return "This element returns a Gibbs operator for sampling weights corresponding to the common base distribution for HDPs";
        }

        @Override
        public Class getReturnType() {
            return MCMCOperator.class;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }
    };

    public HDPStickPropsOperator(HDPPolyaUrn hDPPolyaUrn, double d) {
        this.hdp = hDPPolyaUrn;
        this.tableCounts = hDPPolyaUrn.getTableCounts();
        this.stickProportions = hDPPolyaUrn.getStickProportions();
        this.categoriesParameter = hDPPolyaUrn.getCategoriesParameter();
        this.groupAssignments = hDPPolyaUrn.getGroupAssignments();
        this.setWeight(d);
    }

    @Override
    public double doOperation() {
        int n;
        int n2;
        int[][] nArray = new int[this.hdp.maxGroupCount][this.hdp.maxCategoryCount];
        double d = this.hdp.getCommonBaseDistMass().getParameterValue(0);
        for (int i = 0; i < this.categoriesParameter.getSize(); ++i) {
            int[] nArray2 = nArray[(int)this.groupAssignments.getParameterValue(i)];
            int n3 = (int)this.categoriesParameter.getParameterValue(i);
            nArray2[n3] = nArray2[n3] + 1;
        }
        int[] nArray3 = new int[this.hdp.maxCategoryCount];
        int[] nArray4 = new int[this.hdp.maxCategoryCount];
        int[] nArray5 = new int[this.hdp.maxCategoryCount];
        for (n2 = 0; n2 < this.hdp.maxCategoryCount; ++n2) {
            for (n = 0; n < this.hdp.maxGroupCount; ++n) {
                nArray3[n2] = nArray3[n2] + (int)this.tableCounts.getParameter(n).getParameterValue(n2);
                nArray4[n2] = nArray4[n2] + nArray[n][n2];
            }
        }
        for (n2 = 0; n2 < this.hdp.maxCategoryCount; ++n2) {
            for (n = n2 + 1; n < this.hdp.maxCategoryCount; ++n) {
                nArray5[n2] = nArray5[n2] + nArray3[n];
            }
        }
        for (n2 = 0; n2 < this.hdp.maxCategoryCount; ++n2) {
            if (nArray4[n2] > 0) {
                double d2 = MathUtils.nextBeta(1 + nArray3[n2], d + (double)nArray5[n2]);
                while (d2 == 0.0 || d2 == 1.0) {
                    d2 = MathUtils.nextBeta(1 + nArray3[n2], d + (double)nArray5[n2]);
                }
                this.stickProportions.getParameter(n2).setParameterValue(0, d2);
                continue;
            }
            this.stickProportions.getParameter(n2).setParameterValue(0, 0.0);
        }
        return 0.0;
    }

    @Override
    public void setPathParameter(double d) {
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("Illegal path weight of " + d);
        }
        this.pathWeight = d;
    }

    @Override
    public String getOperatorName() {
        return HDP_STICK_PROPS_OPERATOR;
    }
}

