/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.substmodel.codon;

import dr.evolution.datatype.AminoAcids;
import dr.evolution.datatype.Codons;
import dr.evolution.datatype.GeneticCode;
import dr.evolution.datatype.Nucleotides;
import dr.evomodel.substmodel.BaseSubstitutionModel;
import dr.evomodel.substmodel.EigenSystem;
import dr.evomodel.substmodel.FrequencyModel;

public abstract class AbstractCodonModel
extends BaseSubstitutionModel {
    protected byte[] rateMap;
    protected Codons codonDataType;
    protected GeneticCode geneticCode;

    public AbstractCodonModel(String string, Codons codons, FrequencyModel frequencyModel, EigenSystem eigenSystem) {
        super(string, codons, frequencyModel, eigenSystem);
        this.codonDataType = codons;
        this.geneticCode = codons.getGeneticCode();
        this.constructRateMap();
        this.updateMatrix = true;
    }

    @Override
    protected void frequenciesChanged() {
    }

    @Override
    protected void ratesChanged() {
    }

    @Override
    protected abstract void setupRelativeRates(double[] var1);

    protected void constructRateMap() {
        this.rateMap = Codons.constructRateMap(this.rateCount, this.stateCount, this.codonDataType, this.geneticCode);
    }

    public void printRateMap() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int[] nArray;
        int n6;
        System.out.print("\t");
        for (n6 = 0; n6 < this.stateCount; ++n6) {
            nArray = this.codonDataType.getTripletStates(n6);
            n5 = nArray[0];
            n4 = nArray[1];
            n3 = nArray[2];
            System.out.print("\t" + Nucleotides.INSTANCE.getChar(n5));
            System.out.print(Nucleotides.INSTANCE.getChar(n4));
            System.out.print(Nucleotides.INSTANCE.getChar(n3));
        }
        System.out.println();
        System.out.print("\t");
        for (n6 = 0; n6 < this.stateCount; ++n6) {
            nArray = this.codonDataType.getTripletStates(n6);
            n5 = nArray[0];
            n4 = nArray[1];
            n3 = nArray[2];
            n2 = this.codonDataType.getState(n5, n4, n3);
            n = this.geneticCode.getAminoAcidState(this.codonDataType.getCanonicalState(n2));
            System.out.print("\t" + AminoAcids.INSTANCE.getChar(n));
        }
        System.out.println();
        for (int i = 0; i < this.stateCount; ++i) {
            nArray = this.codonDataType.getTripletStates(i);
            int n7 = nArray[0];
            int n8 = nArray[1];
            int n9 = nArray[2];
            System.out.print(Nucleotides.INSTANCE.getChar(n7));
            System.out.print(Nucleotides.INSTANCE.getChar(n8));
            System.out.print(Nucleotides.INSTANCE.getChar(n9));
            int n10 = this.codonDataType.getState(n7, n8, n9);
            int n11 = this.geneticCode.getAminoAcidState(this.codonDataType.getCanonicalState(n10));
            System.out.print("\t" + AminoAcids.INSTANCE.getChar(n11));
            for (n6 = 0; n6 < this.stateCount; ++n6) {
                nArray = this.codonDataType.getTripletStates(n6);
                n5 = nArray[0];
                n4 = nArray[1];
                n3 = nArray[2];
                n2 = this.codonDataType.getState(n5, n4, n3);
                n = this.geneticCode.getAminoAcidState(this.codonDataType.getCanonicalState(n2));
                int n12 = -1;
                if (n7 != n5) {
                    n12 = n7 == 0 && n5 == 2 || n7 == 2 && n5 == 0 || n7 == 1 && n5 == 3 || n7 == 3 && n5 == 1 ? 1 : 2;
                }
                if (n8 != n4) {
                    n12 = n12 == -1 ? (n8 == 0 && n4 == 2 || n8 == 2 && n4 == 0 || n8 == 1 && n4 == 3 || n8 == 3 && n4 == 1 ? 1 : 2) : 0;
                }
                if (n9 != n3) {
                    n12 = n12 == -1 ? (n9 == 0 && n3 == 2 || n9 == 2 && n3 == 0 || n9 == 1 && n3 == 3 || n9 == 3 && n3 == 1 ? 1 : 2) : 0;
                }
                if (n12 != 0 && n11 != n) {
                    n12 = (byte)(n12 + 2);
                }
                System.out.print("\t" + n12);
            }
            System.out.println();
        }
    }
}

