/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.tree;

import dr.evolution.io.NewickImporter;
import dr.evolution.tree.MutableTreeModel;
import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evolution.tree.TreeTrait;
import dr.evomodel.tree.DefaultTreeModel;
import dr.evomodel.tree.SingleScalarTreeTransform;
import dr.evomodel.tree.TransformedTreeModel;
import dr.evomodel.tree.TreeTransform;
import dr.evomodel.tree.TrialTreeParameterModel;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.util.Citable;
import java.util.logging.Logger;

public class ProgressiveScalarTreeTransform
extends TreeTransform {
    private final Parameter scale;
    private final TrialTreeParameterModel treeParameterModel;

    public ProgressiveScalarTreeTransform(Parameter parameter) {
        this(parameter, null);
    }

    public ProgressiveScalarTreeTransform(MutableTreeModel mutableTreeModel, Parameter parameter) {
        this(parameter, new TrialTreeParameterModel(mutableTreeModel, parameter, false, false, TreeTrait.Intent.BRANCH));
    }

    public ProgressiveScalarTreeTransform(Parameter parameter, TrialTreeParameterModel trialTreeParameterModel) {
        super("progressiveScalarTreeTransform");
        int n = 1;
        this.treeParameterModel = trialTreeParameterModel;
        this.scale = parameter;
        if (trialTreeParameterModel != null) {
            n = trialTreeParameterModel.getParameterSize();
            this.addModel(trialTreeParameterModel);
        } else {
            this.addVariable(parameter);
        }
        parameter.addBounds(new Parameter.DefaultBounds(1.0, 0.0, n));
        StringBuilder stringBuilder = new StringBuilder("Creating a branch-specific phenotypic mixture model.\n");
        stringBuilder.append("\tPlease cite:\n");
        stringBuilder.append(Citable.Utils.getCitationString(this));
        Logger.getLogger("dr.evomodel.tree").info(stringBuilder.toString());
    }

    @Override
    public double transform(Tree tree, NodeRef nodeRef, double d) {
        if (tree.isExternal(nodeRef)) {
            return d;
        }
        if (tree.isRoot(nodeRef)) {
            return tree.getNodeHeight(nodeRef);
        }
        double d2 = tree.getNodeHeight(tree.getParent(nodeRef));
        return d2 - this.getScaleForNode(tree, nodeRef) * (d2 - d);
    }

    @Override
    protected double getScaleForNode(Tree tree, NodeRef nodeRef) {
        if (this.treeParameterModel != null) {
            return this.treeParameterModel.getNodeValue(tree, nodeRef);
        }
        return this.scale.getParameterValue(0);
    }

    @Override
    public String getInfo() {
        return "Linear, progressive transform by " + this.scale.getId();
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
        this.fireModelChanged(this.treeParameterModel);
    }

    @Override
    protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        this.fireModelChanged(this.scale);
    }

    public static void main(String[] stringArray) throws Exception {
        NewickImporter newickImporter = new NewickImporter("((((A:2,B:1):0.5,C:3):1.5,(D:1.5,E:1):3.5):1,F:5);");
        Tree tree = newickImporter.importTree(null);
        Parameter.Default default_ = new Parameter.Default(0.5);
        ProgressiveScalarTreeTransform progressiveScalarTreeTransform = new ProgressiveScalarTreeTransform(default_);
        DefaultTreeModel defaultTreeModel = new DefaultTreeModel("original", tree);
        TransformedTreeModel transformedTreeModel = new TransformedTreeModel("tree", defaultTreeModel, progressiveScalarTreeTransform);
        System.err.println(transformedTreeModel.toString());
        SingleScalarTreeTransform singleScalarTreeTransform = new SingleScalarTreeTransform(default_);
        TransformedTreeModel transformedTreeModel2 = new TransformedTreeModel("tree2", defaultTreeModel, singleScalarTreeTransform);
        System.err.println(transformedTreeModel2.toString());
    }
}

