/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.tree;

import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evomodel.branchratemodel.BranchRateModel;
import dr.evomodel.tree.TreeStatistic;
import dr.stats.DiscreteStatistics;

public class RateCovarianceStatistic
extends TreeStatistic {
    private Tree tree = null;
    private BranchRateModel branchRateModel = null;
    private double[] childRate = null;
    private double[] parentRate = null;

    public RateCovarianceStatistic(String string, Tree tree, BranchRateModel branchRateModel) {
        super(string);
        this.tree = tree;
        this.branchRateModel = branchRateModel;
        int n = tree.getExternalNodeCount();
        this.childRate = new double[2 * n - 4];
        this.parentRate = new double[this.childRate.length];
    }

    @Override
    public void setTree(Tree tree) {
        this.tree = tree;
    }

    @Override
    public Tree getTree() {
        return this.tree;
    }

    @Override
    public int getDimension() {
        return 1;
    }

    @Override
    public double getStatisticValue(int n) {
        int n2 = this.tree.getNodeCount();
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            NodeRef nodeRef = this.tree.getNode(i);
            NodeRef nodeRef2 = this.tree.getParent(nodeRef);
            if (!(nodeRef2 != null & !this.tree.isRoot(nodeRef2))) continue;
            this.childRate[n3] = this.branchRateModel.getBranchRate(this.tree, nodeRef);
            this.parentRate[n3] = this.branchRateModel.getBranchRate(this.tree, nodeRef2);
            ++n3;
        }
        return DiscreteStatistics.covariance(this.childRate, this.parentRate);
    }
}

