/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.treedatalikelihood.preorder;

import dr.evolution.tree.Tree;
import dr.evomodel.continuous.MultivariateDiffusionModel;
import dr.evomodel.treedatalikelihood.continuous.ConjugateRootTraitPrior;
import dr.evomodel.treedatalikelihood.continuous.ContinuousDataLikelihoodDelegate;
import dr.evomodel.treedatalikelihood.continuous.ContinuousRateTransformation;
import dr.evomodel.treedatalikelihood.continuous.ContinuousTraitPartialsProvider;
import dr.evomodel.treedatalikelihood.continuous.cdi.ContinuousDiffusionIntegrator;
import dr.evomodel.treedatalikelihood.continuous.cdi.PrecisionType;
import dr.evomodel.treedatalikelihood.continuous.cdi.SafeMultivariateIntegrator;
import dr.evomodel.treedatalikelihood.preorder.AbstractRealizedContinuousTraitDelegate;
import dr.math.distributions.MultivariateNormalDistribution;

public class ConditionalOnTipsRealizedDelegate
extends AbstractRealizedContinuousTraitDelegate {
    private static final boolean DEBUG = false;
    protected final int dimPartial;
    final boolean hasDrift;
    final boolean hasActualization;
    final ContinuousDataLikelihoodDelegate likelihoodDelegate;
    final ContinuousDiffusionIntegrator cdi;
    final double[] partialNodeBuffer;
    final double[] partialPriorBuffer;
    final double[] precisionBuffer;
    final double[] displacementBuffer;
    final double[] actualizationBuffer;
    final double[] tmpMean;

    public ConditionalOnTipsRealizedDelegate(String string, Tree tree, MultivariateDiffusionModel multivariateDiffusionModel, ContinuousTraitPartialsProvider continuousTraitPartialsProvider, ConjugateRootTraitPrior conjugateRootTraitPrior, ContinuousRateTransformation continuousRateTransformation, ContinuousDataLikelihoodDelegate continuousDataLikelihoodDelegate) {
        super(string, tree, multivariateDiffusionModel, continuousTraitPartialsProvider, conjugateRootTraitPrior, continuousRateTransformation, continuousDataLikelihoodDelegate);
        this.likelihoodDelegate = continuousDataLikelihoodDelegate;
        this.cdi = continuousDataLikelihoodDelegate.getIntegrator();
        this.dimPartial = continuousDataLikelihoodDelegate.getPrecisionType().getPartialsDimension(this.dimTrait);
        this.partialNodeBuffer = new double[this.numTraits * this.dimPartial];
        this.partialPriorBuffer = new double[this.numTraits * this.dimPartial];
        this.tmpMean = new double[this.dimTrait];
        this.hasDrift = continuousDataLikelihoodDelegate.getDiffusionProcessDelegate().hasDrift();
        this.hasActualization = continuousDataLikelihoodDelegate.getDiffusionProcessDelegate().hasActualization();
        boolean bl = continuousDataLikelihoodDelegate.getDiffusionProcessDelegate().hasDiagonalActualization();
        if (!this.hasDrift) {
            this.precisionBuffer = null;
            this.displacementBuffer = null;
            this.actualizationBuffer = null;
        } else {
            this.precisionBuffer = new double[this.dimTrait * this.dimTrait];
            this.displacementBuffer = new double[this.dimTrait];
            this.actualizationBuffer = (double[])(!this.hasActualization ? null : (bl ? new double[this.dimTrait] : new double[this.dimTrait * this.dimTrait]));
        }
    }

    @Override
    protected void simulateRoot(int n) {
        this.cdi.getPostOrderPartial(this.rootProcessDelegate.getPriorBufferIndex(), this.partialPriorBuffer);
        this.cdi.getPostOrderPartial(this.likelihoodDelegate.getActiveNodeIndex(n), this.partialNodeBuffer);
        int n2 = 0;
        int n3 = this.dimNode * n;
        for (int i = 0; i < this.numTraits; ++i) {
            this.simulateTraitForRoot(n3, n2);
            n3 += this.dimTrait;
            n2 += this.dimPartial;
        }
    }

    protected void simulateTraitForRoot(int n, int n2) {
        assert (this.likelihoodDelegate.getPrecisionType() == PrecisionType.SCALAR);
        double d = this.partialNodeBuffer[n2 + this.dimTrait];
        if (Double.isInfinite(d)) {
            System.arraycopy(this.partialNodeBuffer, n2, this.sample, n, this.dimTrait);
        } else {
            double d2 = this.partialPriorBuffer[n2 + this.dimTrait];
            double d3 = d2 + d;
            for (int i = 0; i < this.dimTrait; ++i) {
                this.tmpMean[i] = (d * this.partialNodeBuffer[n2 + i] + d2 * this.partialPriorBuffer[n2 + i]) / d3;
            }
            double d4 = Math.sqrt(1.0 / d3);
            MultivariateNormalDistribution.nextMultivariateNormalCholesky(this.tmpMean, 0, this.cholesky, d4, this.sample, n, this.tmpEpsilon);
        }
    }

    @Override
    protected void simulateNode(int n, int n2, int n3, int n4, int n5) {
        this.cdi.getPostOrderPartial(n3, this.partialNodeBuffer);
        double d = 1.0 / this.cdi.getBranchLength(n4);
        int n6 = 0;
        int n7 = this.dimNode * n2;
        int n8 = this.dimNode * n;
        if (this.hasDrift) {
            ((SafeMultivariateIntegrator)this.cdi).getBranchPrecision(n4, this.precisionBuffer);
            this.cdi.getBranchDisplacement(n4, this.displacementBuffer);
        }
        if (this.hasActualization) {
            this.cdi.getBranchActualization(n4, this.actualizationBuffer);
        }
        for (int i = 0; i < this.numTraits; ++i) {
            this.simulateTraitForNode(n2, i, n7, n8, n6, n5, d);
            n7 += this.dimTrait;
            n8 += this.dimTrait;
            n6 += this.dimPartial;
        }
    }

    protected void simulateTraitForNode(int n, int n2, int n3, int n4, int n5, int n6, double d) {
        double d2 = this.partialNodeBuffer[n5 + this.dimTrait];
        if (Double.isInfinite(d2)) {
            System.arraycopy(this.partialNodeBuffer, n5, this.sample, n3, this.dimTrait);
        } else if (Double.isInfinite(d)) {
            System.arraycopy(this.sample, n4, this.sample, n3, this.dimTrait);
        } else {
            double d3 = d2 + d;
            for (int i = 0; i < this.dimTrait; ++i) {
                this.tmpMean[i] = (d2 * this.partialNodeBuffer[n5 + i] + d * this.sample[n4 + i]) / d3;
            }
            double d4 = Math.sqrt(1.0 / d3);
            MultivariateNormalDistribution.nextMultivariateNormalCholesky(this.tmpMean, 0, this.cholesky, d4, this.sample, n3, this.tmpEpsilon);
        }
    }
}

